// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class FtileCircleEnd extends AbstractFtile {

	private static final int SIZE = 20;

	private HColor borderColor;
	private HColor backColor;
	private final Swimlane swimlane;
	private double shadowing;

	@Override
	public Collection<Ftile> getMyChildren() {
		return Collections.emptyList();
	}

	public FtileCircleEnd(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, Style style) {
		super(skinParam);
		this.borderColor = borderColor;
		this.backColor = backColor;
		this.swimlane = swimlane;
		this.shadowing = style.value(PName.Shadowing).asDouble();
		this.backColor = style.value(PName.BackGroundColor).asColor(getIHtmlColorSet());
		this.borderColor = style.value(PName.LineColor).asColor(getIHtmlColorSet());

	}

	public Set<Swimlane> getSwimlanes() {
		if (swimlane == null)
			return Collections.emptySet();

		return Collections.singleton(swimlane);
	}

	public Swimlane getSwimlaneIn() {
		return swimlane;
	}

	public Swimlane getSwimlaneOut() {
		return swimlane;
	}

	public void drawU(UGraphic ug) {
		double xTheoricalPosition = 0;
		double yTheoricalPosition = 0;
		xTheoricalPosition = Math.round(xTheoricalPosition);
		yTheoricalPosition = Math.round(yTheoricalPosition);

		final UEllipse circle = UEllipse.build(SIZE, SIZE);
		circle.setDeltaShadow(shadowing);
		ug = ug.apply(borderColor);
		final double thickness = 2.5;
		ug.apply(backColor.bg()).apply(UStroke.withThickness(1.5)).apply(new UTranslate(xTheoricalPosition, yTheoricalPosition))
				.draw(circle);

		final double size2 = (SIZE - thickness) / Math.sqrt(2);
		final double delta = (SIZE - size2) / 2;
		ug = ug.apply(UStroke.withThickness(thickness));
		ug.apply(new UTranslate(delta, delta)).draw(new ULine(size2, size2));
		ug.apply(new UTranslate(delta, SIZE - delta)).draw(new ULine(size2, -size2));

	}

	@Override
	protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
		return new FtileGeometry(SIZE, SIZE, SIZE / 2, 0);
	}

}
