/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Iterator;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.factplusplusad.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.factplusplusad.Signature;

class LowerBoundComplementEvaluator
extends CardinalityEvaluatorBase {
    LowerBoundComplementEvaluator(Signature s) {
        super(s);
    }

    @Override
    int getNoneValue() {
        return 0;
    }

    @Override
    int getAllValue() {
        return -1;
    }

    @Override
    int getOneNoneLower(boolean v) {
        return v ? 1 : this.getNoneValue();
    }

    @Override
    int getEntityValue(OWLEntity entity) {
        if (entity.isTopEntity()) {
            return this.noLowerValue();
        }
        if ((entity.isOWLObjectProperty() || entity.isOWLDataProperty() || entity.isOWLDatatype()) && entity.isBottomEntity()) {
            return this.anyLowerValue();
        }
        if (entity.isBottomEntity()) {
            return 1;
        }
        return this.getOneNoneLower(this.botCLocal() && this.nc(entity));
    }

    @Override
    int getForallValue(OWLPropertyExpression r, OWLPropertyRange c) {
        return this.getOneNoneLower(this.isTopEquivalent((OWLObject)r) && this.isLowerGE(this.getLowerBoundComplement((OWLObject)c), 1));
    }

    @Override
    int getMinValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (m <= 0) {
            return this.noLowerValue();
        }
        if (this.isBotEquivalent((OWLObject)r)) {
            return 1;
        }
        return this.getOneNoneLower(this.isUpperLT(this.getUpperBoundDirect((OWLObject)c), m));
    }

    @Override
    int getMaxValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        if (!this.isTopEquivalent((OWLObject)r)) {
            return this.noLowerValue();
        }
        if (this.isLowerGT(this.getLowerBoundDirect((OWLObject)c), m)) {
            return m + 1;
        }
        return this.noLowerValue();
    }

    @Override
    int getExactValue(int m, OWLPropertyExpression r, OWLPropertyRange c) {
        return Math.max(this.getMinValue(m, r, c), this.getMaxValue(m, r, c));
    }

    <C extends OWLObject> int getAndValue(HasOperands<C> expr) {
        int max = this.getNoneValue();
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int n = this.getLowerBoundComplement(p);
            if (n == this.anyLowerValue()) {
                return this.anyLowerValue();
            }
            max = Math.max(max, n);
        }
        return max;
    }

    <C extends OWLObject> int getOrValue(HasOperands<C> expr) {
        boolean foundC = false;
        int foundM = 0;
        int mMax = 0;
        int kMax = 0;
        int sumK = 0;
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int m = this.getLowerBoundComplement(p);
            int k = this.getUpperBoundDirect(p);
            if (m == this.noLowerValue() && k == this.noUpperValue()) {
                return this.noLowerValue();
            }
            if (m == this.noLowerValue()) {
                sumK += k;
                continue;
            }
            if (k == this.noUpperValue()) {
                if (foundC) {
                    return this.noLowerValue();
                }
                foundC = true;
                foundM = m;
                continue;
            }
            sumK += k;
            if (k + m <= kMax + mMax) continue;
            kMax = k;
            mMax = m;
        }
        if (foundC) {
            return (foundM -= sumK) > 0 ? foundM : this.noLowerValue();
        }
        return (mMax -= (sumK -= kMax)) > 0 ? mMax : this.noLowerValue();
    }

    public void visit(OWLObjectComplementOf expr) {
        this.value = this.getLowerBoundDirect(expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLObjectUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLObjectOneOf o) {
        this.value = this.noLowerValue();
    }

    public void visit(OWLObjectHasSelf expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectHasValue expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLDataHasValue expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent((OWLObject)expr.getProperty()));
    }

    public void visit(OWLObjectInverseOf expr) {
        this.value = this.getLowerBoundComplement((OWLObject)expr.getInverseProperty());
    }

    public void visit(OWLSubPropertyChainOfAxiom expr) {
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (!this.isBotEquivalent((OWLObject)p)) continue;
            this.value = this.anyLowerValue();
            return;
        }
        this.value = this.noLowerValue();
    }

    public void visit(OWLLiteral o) {
        this.value = 1;
    }

    public void visit(OWLDataComplementOf expr) {
        this.value = this.getLowerBoundDirect((OWLObject)expr.getDataRange());
    }

    public void visit(OWLDataIntersectionOf expr) {
        this.value = this.getAndValue((HasOperands)expr);
    }

    public void visit(OWLDataUnionOf expr) {
        this.value = this.getOrValue((HasOperands)expr);
    }

    public void visit(OWLDataOneOf o) {
        this.value = this.noLowerValue();
    }
}

