/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPIOwl2Obo {
    private static final String MAX_CARDINALITY = "maxCardinality";
    private static final String MIN_CARDINALITY = "minCardinality";
    public static final Map<String, String> ANNOTATIONPROPERTYMAP = OWLAPIOwl2Obo.initAnnotationPropertyMap();
    private static final String TOP_BOTTOM_NONTRANSLATEABLE = "Assertions using owl:Thing or owl:Nothing are not translateable OBO";
    private static final Logger LOG = LoggerFactory.getLogger(OWLAPIOwl2Obo.class);
    private static final String IRI_CLASS_SYNONYMTYPEDEF = "http://purl.obolibrary.org/obo/IAO_synonymtypedef";
    private static final String IRI_CLASS_SUBSETDEF = "http://purl.obolibrary.org/obo/IAO_subsetdef";
    private static final Set<String> SKIPPED_QUALIFIERS = new HashSet<String>(Arrays.asList("gci_relation", "gci_filler", "cardinality", "minCardinality", "maxCardinality", "all_some", "all_only"));
    protected final Pattern absoluteURLPattern = Pattern.compile("<\\s*http.*?>");
    protected final Set<OWLAxiom> untranslatableAxioms = new HashSet<OWLAxiom>();
    protected final Map<String, String> idSpaceMap = new HashMap<String, String>();
    protected final Set<OWLAnnotationProperty> apToDeclare = new HashSet<OWLAnnotationProperty>();
    private final OWLDataFactory df;
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected OBODoc obodoc;
    protected String ontologyId;
    protected boolean strictConversion;
    protected boolean discardUntranslatable = false;
    private boolean muteUntranslatableAxioms = false;

    public OWLAPIOwl2Obo(OWLOntologyManager translationManager) {
        this.manager = translationManager;
        this.df = this.manager.getOWLDataFactory();
        this.init();
    }

    protected static Map<String, String> initAnnotationPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : OWLAPIObo2Owl.ANNOTATIONPROPERTYMAP.keySet()) {
            IRI propIRI = OWLAPIObo2Owl.ANNOTATIONPROPERTYMAP.get(key);
            map.put(propIRI.toString(), key);
        }
        return map;
    }

    protected static boolean shorthand(@Nullable String propId) {
        return "shorthand".equals(propId);
    }

    protected static void addQualifiers(Clause c, Stream<OWLAnnotation> qualifiers) {
        qualifiers.forEach(a -> OWLAPIOwl2Obo.addQualifiers(c, a));
    }

    protected static void addQualifiers(Clause c, OWLAnnotation qualifier) {
        String prop = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)qualifier.getProperty());
        if (prop == null) {
            prop = qualifier.getProperty().getIRI().toString();
        }
        if (SKIPPED_QUALIFIERS.contains(prop)) {
            return;
        }
        String value = qualifier.getValue().toString();
        if (qualifier.getValue() instanceof OWLLiteral) {
            value = ((OWLLiteral)qualifier.getValue()).getLiteral();
        } else if (qualifier.getValue().isIRI()) {
            value = OWLAPIOwl2Obo.getIdentifier((IRI)qualifier.getValue());
        }
        QualifierValue qv = new QualifierValue(prop, value);
        c.addQualifierValue(qv);
    }

    public static String getOntologyId(OWLOntology ontology) {
        Optional ontologyIRI = ontology.getOntologyID().getOntologyIRI();
        if (!ontologyIRI.isPresent()) {
            return "";
        }
        return OWLAPIOwl2Obo.getOntologyId((IRI)ontologyIRI.get());
    }

    public static String getOntologyId(IRI iriObj) {
        String id;
        String iri = iriObj.toString();
        if (iri.startsWith("http://purl.obolibrary.org/obo/")) {
            id = iri.replace("http://purl.obolibrary.org/obo/", "");
            if (id.endsWith(".owl")) {
                id = id.replaceFirst(".owl$", "");
            }
        } else {
            id = iri;
        }
        return id;
    }

    @Nullable
    public static String getDataVersion(OWLOntology ontology) {
        String oid = OWLAPIOwl2Obo.getOntologyId(ontology);
        Optional v = ontology.getOntologyID().getVersionIRI();
        if (v.isPresent()) {
            String vs = ((IRI)v.get()).toString().replace("http://purl.obolibrary.org/obo/", "");
            vs = vs.replaceFirst(oid + '/', "");
            vs = vs.replace('/' + oid + ".owl", "");
            return vs;
        }
        return null;
    }

    private static Optional<OboAltIdCheckResult> checkForOboAltId(Collection<OWLAnnotationAssertionAxiom> annotations) {
        String replacedBy = null;
        boolean isMerged = false;
        boolean isDeprecated = false;
        HashSet<OWLAnnotationAssertionAxiom> unrelatedAxioms = new HashSet<OWLAnnotationAssertionAxiom>();
        for (OWLAnnotationAssertionAxiom axiom : annotations) {
            OWLAnnotationProperty prop = (OWLAnnotationProperty)axiom.getProperty();
            if (prop.isDeprecated()) {
                isDeprecated = true;
                continue;
            }
            if (Obo2OWLConstants.IRI_IAO_0000231.equals((Object)prop.getIRI())) {
                isMerged = OWLAPIOwl2Obo.handleIAO227(isMerged, unrelatedAxioms, axiom);
                continue;
            }
            if (Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0100001.iri.equals((Object)prop.getIRI())) {
                replacedBy = OWLAPIOwl2Obo.handleIAO10001(replacedBy, unrelatedAxioms, axiom);
                continue;
            }
            unrelatedAxioms.add(axiom);
        }
        Optional result = replacedBy != null && isMerged && isDeprecated ? OWLAPIPreconditions.optional((Object)new OboAltIdCheckResult(replacedBy, unrelatedAxioms)) : OWLAPIPreconditions.emptyOptional();
        return result;
    }

    protected static boolean handleIAO227(boolean isMerged, Set<OWLAnnotationAssertionAxiom> unrelatedAxioms, OWLAnnotationAssertionAxiom axiom) {
        OWLAnnotationValue value = axiom.getValue();
        Optional asIRI = value.asIRI();
        if (asIRI.isPresent()) {
            return Obo2OWLConstants.IRI_IAO_0000227.equals(asIRI.get());
        }
        unrelatedAxioms.add(axiom);
        return isMerged;
    }

    @Nullable
    protected static String handleIAO10001(@Nullable String replacedBy, Set<OWLAnnotationAssertionAxiom> unrelatedAxioms, OWLAnnotationAssertionAxiom axiom) {
        OWLAnnotationValue value = axiom.getValue();
        Optional asLiteral = value.asLiteral();
        if (asLiteral.isPresent()) {
            return ((OWLLiteral)asLiteral.get()).getLiteral();
        }
        Optional asIRI = value.asIRI();
        if (asIRI.isPresent()) {
            return OWLAPIOwl2Obo.getIdentifier((IRI)asIRI.get());
        }
        unrelatedAxioms.add(axiom);
        return replacedBy;
    }

    public static String getIdentifierFromObject(OWLObject obj, OWLOntology ont, String defaultValue) {
        String id = defaultValue;
        try {
            id = OWLAPIOwl2Obo.getIdentifierFromObject(obj, ont);
            if (id == null) {
                id = defaultValue;
            }
        }
        catch (UntranslatableAxiomException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return id;
    }

    @Nullable
    public static String getIdentifierFromObject(OWLObject obj, OWLOntology ont) throws UntranslatableAxiomException {
        if (obj instanceof OWLObjectProperty || obj instanceof OWLAnnotationProperty) {
            OWLEntity entity = (OWLEntity)obj;
            for (OWLAnnotationAssertionAxiom ax : OWLAPIStreamUtils.asList((Stream)ont.annotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI()))) {
                String propId = OWLAPIOwl2Obo.getIdentifierFromObject((OWLObject)((OWLAnnotationProperty)ax.getProperty()).getIRI(), ont);
                if (!OWLAPIOwl2Obo.shorthand(propId)) continue;
                OWLAnnotationValue value = ax.getValue();
                if (value instanceof OWLLiteral) {
                    return ((OWLLiteral)value).getLiteral();
                }
                throw new UntranslatableAxiomException("Untranslatable axiom, expected literal value, but was: " + value + " in axiom: " + ax);
            }
        }
        if (obj instanceof OWLEntity) {
            return OWLAPIOwl2Obo.getIdentifier(((OWLEntity)obj).getIRI());
        }
        if (obj.isIRI()) {
            return OWLAPIOwl2Obo.getIdentifier((IRI)obj);
        }
        return null;
    }

    public static String getIdentifier(IRI iriId) {
        String iri = iriId.toString();
        String id = OWLAPIOwl2Obo.getId(iri);
        String[] s = id.split("#_");
        if (s.length > 1) {
            return s[0] + ':' + s[1];
        }
        s = id.split("#");
        if (s.length > 1) {
            String prefix = "";
            if ("owl".equals(s[0]) || "rdf".equals(s[0]) || "rdfs".equals(s[0])) {
                prefix = s[0] + ':';
            }
            return prefix + s[1];
        }
        s = id.split("_");
        if (s.length == 2 && !id.contains("#") && !s[1].contains("_")) {
            try {
                String localId = URLDecoder.decode(s[1], "UTF-8");
                return s[0] + ':' + localId;
            }
            catch (UnsupportedEncodingException e) {
                throw new OWLRuntimeException("UTF-8 not supported, JRE corrupted?", (Throwable)e);
            }
        }
        if (s.length > 2 && !id.contains("#") && s[s.length - 1].replaceAll("[0-9]", "").isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    if (i == s.length - 1) {
                        sb.append(':');
                    } else {
                        sb.append('_');
                    }
                }
                sb.append(s[i]);
            }
            return sb.toString();
        }
        return iri;
    }

    protected static String getId(String iri) {
        int indexSlash = iri.lastIndexOf(47);
        if (indexSlash > -1) {
            return iri.substring(indexSlash + 1);
        }
        return iri;
    }

    @Nullable
    public static String owlObjectToTag(OWLObject obj) {
        IRI iriObj = null;
        if (obj instanceof OWLNamedObject) {
            iriObj = ((OWLNamedObject)obj).getIRI();
        } else if (obj.isIRI()) {
            iriObj = (IRI)obj;
        }
        if (iriObj == null) {
            return null;
        }
        String iri = iriObj.toString();
        String tag = ANNOTATIONPROPERTYMAP.get(iri);
        if (tag == null) {
            String prefix;
            if (iri.startsWith("http://purl.obolibrary.org/obo/IAO_")) {
                String legacyId = iri.replace("http://purl.obolibrary.org/obo/", "");
                if ("IAO_xref".equals(legacyId)) {
                    return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
                }
                if ("IAO_id".equals(legacyId)) {
                    return OBOFormatConstants.OboFormatTag.TAG_ID.getTag();
                }
                if ("IAO_namespace".equals(legacyId)) {
                    return OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag();
                }
            }
            if (iri.startsWith(prefix = "http://www.geneontology.org/formats/oboInOwl#")) {
                tag = iri.substring(prefix.length());
            }
        }
        return tag;
    }

    public static List<Clause> normalizeRelationshipClauses(List<Clause> clauses) {
        ArrayList<Clause> normalized = new ArrayList<Clause>();
        while (!clauses.isEmpty()) {
            Clause target = clauses.remove(0);
            List<Clause> similar = OWLAPIOwl2Obo.findSimilarClauses(clauses, target);
            normalized.add(target);
            OWLAPIOwl2Obo.mergeSimilarIntoTarget(target, similar);
        }
        return normalized;
    }

    static List<Clause> findSimilarClauses(List<Clause> clauses, Clause target) {
        String targetTag = target.getTag();
        ArrayList<Clause> similar = new ArrayList<Clause>();
        if (targetTag == null) {
            return similar;
        }
        int size = target.getValues().size();
        Object targetValue = target.getValue();
        Object targetValue2 = null;
        if (size > 1) {
            targetValue2 = target.getValue2();
        }
        Iterator<Clause> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            Clause current = iterator.next();
            int sizeCurrent = current.getValues().size();
            Object currentValue = current.getValue();
            Object currentValue2 = null;
            if (sizeCurrent > 1) {
                currentValue2 = current.getValue2();
            }
            if (!targetTag.equals(current.getTag()) || !targetValue.equals(currentValue) || !Objects.equals(targetValue2, currentValue2)) continue;
            similar.add(current);
            iterator.remove();
        }
        return similar;
    }

    static void mergeSimilarIntoTarget(Clause target, List<Clause> similar) {
        if (similar.isEmpty()) {
            return;
        }
        Collection<QualifierValue> targetQVs = target.getQualifierValues();
        for (Clause current : similar) {
            Collection<QualifierValue> newQVs = current.getQualifierValues();
            for (QualifierValue newQV : newQVs) {
                String newQualifier = newQV.getQualifier();
                if (MIN_CARDINALITY.equals(newQualifier) || MAX_CARDINALITY.equals(newQualifier)) {
                    QualifierValue match = OWLAPIOwl2Obo.findMatchingQualifierValue(newQV, targetQVs);
                    if (match != null) {
                        OWLAPIOwl2Obo.mergeQualifierValues(match, newQV);
                        continue;
                    }
                    target.addQualifierValue(newQV);
                    continue;
                }
                target.addQualifierValue(newQV);
            }
        }
    }

    @Nullable
    static QualifierValue findMatchingQualifierValue(QualifierValue query, Collection<QualifierValue> list) {
        String queryQualifier = query.getQualifier();
        for (QualifierValue qv : list) {
            if (!queryQualifier.equals(qv.getQualifier())) continue;
            return qv;
        }
        return null;
    }

    static void mergeQualifierValues(QualifierValue target, QualifierValue newQV) {
        if (!target.getValue().equals(newQV.getValue())) {
            if (MIN_CARDINALITY.equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue());
                int newValue = Integer.parseInt(newQV.getValue());
                int mergedValue = Math.min(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            } else if (MAX_CARDINALITY.equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue());
                int newValue = Integer.parseInt(newQV.getValue());
                int mergedValue = Math.max(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            }
        }
    }

    protected final void init() {
        this.idSpaceMap.clear();
        this.idSpaceMap.put("http://www.obofoundry.org/ro/ro.owl#", "OBO_REL");
        this.untranslatableAxioms.clear();
        this.apToDeclare.clear();
    }

    public boolean getStrictConversion() {
        return this.strictConversion;
    }

    public void setStrictConversion(boolean b) {
        this.strictConversion = b;
    }

    public boolean isDiscardUntranslatable() {
        return this.discardUntranslatable;
    }

    public void setDiscardUntranslatable(boolean discardUntranslatable) {
        this.discardUntranslatable = discardUntranslatable;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return (OBODoc)OWLAPIPreconditions.verifyNotNull((Object)this.obodoc);
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    public OBODoc convert(OWLOntology ont) {
        this.owlOntology = ont;
        this.ontologyId = OWLAPIOwl2Obo.getOntologyId(ont);
        this.init();
        return this.tr();
    }

    protected OWLOntology getOWLOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.owlOntology);
    }

    public Collection<OWLAxiom> getUntranslatableAxioms() {
        return this.untranslatableAxioms;
    }

    protected OBODoc tr() {
        String axiomString;
        this.setObodoc(new OBODoc());
        this.preProcess();
        this.tr(this.getOWLOntology());
        this.accept(this.getOWLOntology().axioms(AxiomType.DECLARATION).sorted());
        AxiomType.skipDeclarations().forEach(t -> this.accept(this.getOWLOntology().axioms(t)));
        if (!(this.untranslatableAxioms.isEmpty() || this.discardUntranslatable || (axiomString = OwlStringTools.translate(this.untranslatableAxioms)).isEmpty())) {
            Frame headerFrame = this.getObodoc().getHeaderFrame();
            if (headerFrame == null) {
                headerFrame = new Frame(Frame.FrameType.HEADER);
                this.getObodoc().setHeaderFrame(headerFrame);
            }
            headerFrame.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS, axiomString));
        }
        return this.getObodoc();
    }

    private void accept(Stream<? extends OWLAxiom> axioms) {
        Translator visitor = new Translator();
        axioms.forEach(ax -> ax.accept(visitor));
    }

    protected void preProcess() {
        String viewRel = null;
        OWLAnnotationProperty logicalDef = this.manager.getOWLDataFactory().getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.getIRI());
        List collect = OWLAPIStreamUtils.asList((Stream)this.getOWLOntology().annotations(logicalDef));
        if (!collect.isEmpty()) {
            OWLAnnotationValue v = ((OWLAnnotation)collect.get(0)).getValue();
            if (v instanceof OWLLiteral) {
                viewRel = ((OWLLiteral)v).getLiteral();
            } else if (v.isIRI()) {
                viewRel = OWLAPIOwl2Obo.getIdentifier((IRI)v);
            }
        }
        if (viewRel == null) {
            return;
        }
        String view = viewRel;
        HashSet rmAxioms = new HashSet();
        HashSet newAxioms = new HashSet();
        this.getOWLOntology().axioms(AxiomType.EQUIVALENT_CLASSES).forEach(eca -> this.preprocessEquivalents(view, rmAxioms, newAxioms, (OWLEquivalentClassesAxiom)eca));
        this.getOWLOntology().remove(rmAxioms);
        this.getOWLOntology().add(newAxioms);
    }

    protected void preprocessEquivalents(String view, Set<OWLAxiom> rmAxioms, Set<OWLAxiom> newAxioms, OWLEquivalentClassesAxiom eca) {
        AtomicInteger numNamed = new AtomicInteger();
        HashSet xs = new HashSet();
        eca.classExpressions().forEach(x -> {
            if (x instanceof OWLClass) {
                xs.add(x);
                numNamed.incrementAndGet();
            } else if (x instanceof OWLObjectSomeValuesFrom) {
                OWLObjectProperty p = (OWLObjectProperty)((OWLObjectSomeValuesFrom)x).getProperty();
                if (!view.equals(this.getIdentifier((OWLObject)p))) {
                    LOG.error("Expected: {} got: {} in {}", new Object[]{view, p, eca});
                }
                xs.add(((OWLObjectSomeValuesFrom)x).getFiller());
            } else {
                LOG.error("Unexpected: {}", (Object)eca);
            }
        });
        if (numNamed.get() == 1) {
            rmAxioms.add((OWLAxiom)eca);
            newAxioms.add((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(xs));
        } else {
            LOG.error("ECA did not fit expected pattern: {}", (Object)eca);
        }
    }

    protected void add(@Nullable Frame f) {
        if (f != null) {
            try {
                this.getObodoc().addFrame(f);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected boolean trObjectProperty(@Nullable OWLObjectProperty prop, @Nullable String tag, @Nullable String value, Stream<OWLAnnotation> annotations) {
        if (prop == null || value == null) {
            return false;
        }
        OWLAPIOwl2Obo.addQualifiers(this.clause(prop, tag, value), annotations);
        return true;
    }

    protected Clause clause(OWLObjectProperty prop, @Nullable String tag, String value) {
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(tag)) {
            Clause clause = f.getClause(tag);
            assert (clause != null);
            clause.setValue(value);
            return clause;
        }
        Clause clause = new Clause(tag, value);
        f.addClause(clause);
        return clause;
    }

    protected boolean trObjectProperty(@Nullable OWLObjectProperty prop, String tag, @Nullable Boolean value, Stream<OWLAnnotation> annotations) {
        if (prop == null || value == null) {
            return false;
        }
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        Clause clause = new Clause(tag);
        clause.addValue(value);
        f.addClause(clause);
        OWLAPIOwl2Obo.addQualifiers(clause, annotations);
        return true;
    }

    protected void trNaryPropertyAxiom(OWLNaryPropertyAxiom<OWLObjectPropertyExpression> ax, String tag) {
        List set = OWLAPIStreamUtils.asList((Stream)ax.properties());
        if (set.size() > 1) {
            boolean first = true;
            OWLObjectProperty prop = null;
            String disjointFrom = null;
            for (OWLObjectPropertyExpression ex : set) {
                if (ex.isBottomEntity() || ex.isTopEntity()) {
                    this.error(tag + " using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
                    return;
                }
                if (first) {
                    first = false;
                    if (!ex.isOWLObjectProperty()) continue;
                    prop = ex.asOWLObjectProperty();
                    continue;
                }
                disjointFrom = this.getIdentifier((OWLObject)ex);
            }
            if (this.trObjectProperty(prop, tag, disjointFrom, (Stream<OWLAnnotation>)ax.annotations())) {
                return;
            }
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLSubPropertyChainOfAxiom ax) {
        Clause clause;
        OWLObjectPropertyExpression pEx = ax.getSuperProperty();
        if (pEx.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLObjectProperty p = pEx.asOWLObjectProperty();
        if (p.isBottomEntity() || p.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
            return;
        }
        List list = ax.getPropertyChain();
        if (list.size() != 2) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLObjectPropertyExpression exp1 = (OWLObjectPropertyExpression)list.get(0);
        OWLObjectPropertyExpression exp2 = (OWLObjectPropertyExpression)list.get(1);
        if (exp1.isBottomEntity() || exp1.isTopEntity() || exp2.isBottomEntity() || exp2.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
            return;
        }
        String rel1 = this.getIdentifier((OWLObject)exp1);
        String rel2 = this.getIdentifier((OWLObject)exp2);
        if (rel1 == null || rel2 == null) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        List unprocessedAnnotations = OWLAPIStreamUtils.asList((Stream)ax.annotations());
        Frame f = this.getTypedefFrame((OWLEntity)p);
        if (rel1.equals(f.getId())) {
            clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER, rel2);
        } else {
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN;
            List collect = OWLAPIStreamUtils.asList((Stream)ax.annotations());
            for (OWLAnnotation ann : collect) {
                if (!"http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain".equals(ann.getProperty().getIRI().toString())) continue;
                tag = OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN;
                unprocessedAnnotations.remove(ann);
                break;
            }
            clause = new Clause(tag);
            clause.addValue(rel1);
            clause.addValue(rel2);
        }
        f.addClause(clause);
        OWLAPIOwl2Obo.addQualifiers(clause, unprocessedAnnotations.stream());
    }

    protected void tr(OWLEquivalentObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
    }

    protected void tr(OWLTransitiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLDisjointObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
    }

    protected void tr(OWLReflexiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLInverseFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLInverseObjectPropertiesAxiom ax) {
        OWLObjectPropertyExpression prop1 = ax.getFirstProperty();
        OWLObjectPropertyExpression prop2 = ax.getSecondProperty();
        if (prop1.isOWLObjectProperty() && prop2.isOWLObjectProperty() && this.trObjectProperty(prop1.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag(), this.getIdentifier((OWLObject)prop2), (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLObjectPropertyDomainAxiom ax) {
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        OWLClassExpression domain = (OWLClassExpression)ax.getDomain();
        if (domain.isBottomEntity() || domain.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("domains using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax, false);
            return;
        }
        String range = this.getIdentifier((OWLObject)domain);
        if (range != null) {
            if (this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag(), range, (Stream<OWLAnnotation>)ax.annotations())) {
                return;
            }
            this.error("trObjectProperty failed for " + prop, (OWLAxiom)ax, true);
        } else {
            this.error("no range translatable for " + ax, false);
        }
    }

    protected void tr(OWLAsymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLSymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop.isOWLObjectProperty() && this.trObjectProperty(prop.asOWLObjectProperty(), OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL.getTag(), Boolean.TRUE, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, true);
    }

    protected void tr(OWLObjectPropertyRangeAxiom ax) {
        OWLClassExpression owlRange = (OWLClassExpression)ax.getRange();
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        if (owlRange.isBottomEntity() || owlRange.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("ranges using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax, false);
            return;
        }
        String range = this.getIdentifier((OWLObject)owlRange);
        if (range != null && this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag(), range, (Stream<OWLAnnotation>)ax.annotations())) {
            return;
        }
        this.error((OWLAxiom)ax, false);
    }

    protected void tr(OWLSubObjectPropertyOfAxiom ax) {
        OWLObjectPropertyExpression sup = (OWLObjectPropertyExpression)ax.getSuperProperty();
        OWLObjectPropertyExpression sub = (OWLObjectPropertyExpression)ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sup.isTopEntity()) {
            this.error("SubProperties using Top or Bottom entites are not supported in OBO.", false);
            return;
        }
        if (sub.isOWLObjectProperty() && sup.isOWLObjectProperty()) {
            String supId = (String)OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)sup));
            if (supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)((OWLObjectProperty)sub));
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            OWLAPIOwl2Obo.addQualifiers(clause, ax.annotations());
        } else {
            this.error((OWLAxiom)ax, true);
        }
    }

    protected void tr(OWLSubAnnotationPropertyOfAxiom ax) {
        OWLAnnotationProperty sup = ax.getSuperProperty();
        OWLAnnotationProperty sub = ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sup.isTopEntity()) {
            this.error("SubAnnotationProperties using Top or Bottom entites are not supported in OBO.", false);
            return;
        }
        String tagObject = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)sup);
        if (OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag().equals(tagObject)) {
            String name = "";
            String scope = null;
            for (OWLAnnotationAssertionAxiom axiom : OWLAPIStreamUtils.asList((Stream)this.getOWLOntology().annotationAssertionAxioms((OWLAnnotationSubject)sub.getIRI()))) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag(axiom.getProperty());
                if (OBOFormatConstants.OboFormatTag.TAG_NAME.getTag().equals(tg)) {
                    name = ((OWLLiteral)axiom.getValue()).getLiteral();
                    continue;
                }
                if (!OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag().equals(tg)) continue;
                scope = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getValue());
            }
            Frame hf = (Frame)OWLAPIPreconditions.checkNotNull((Object)this.getObodoc().getHeaderFrame());
            assert (hf != null);
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(name);
            if (scope != null) {
                clause.addValue(scope);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, ax.annotations());
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.error("duplicate clause: {} in header", (Object)clause);
            }
            return;
        }
        if (OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag().equals(tagObject)) {
            String comment = "";
            for (OWLAnnotationAssertionAxiom axiom : OWLAPIStreamUtils.asList((Stream)this.getOWLOntology().annotationAssertionAxioms((OWLAnnotationSubject)sub.getIRI()))) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag(axiom.getProperty());
                if (!OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tg)) continue;
                comment = ((OWLLiteral)axiom.getValue()).getLiteral();
                break;
            }
            Frame hf = (Frame)OWLAPIPreconditions.checkNotNull((Object)this.getObodoc().getHeaderFrame());
            assert (hf != null);
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(comment);
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.error("duplicate clause: {} in header", (Object)clause);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, ax.annotations());
            return;
        }
        if (sub.isOWLObjectProperty() && sup.isOWLObjectProperty()) {
            String supId = this.getIdentifier((OWLObject)sup);
            if (supId == null || supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)sub);
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            OWLAPIOwl2Obo.addQualifiers(clause, ax.annotations());
        } else {
            this.error((OWLAxiom)ax, true);
        }
    }

    protected void tr(OWLAnnotationAssertionAxiom ax, Frame frame) {
        boolean success = this.tr((OWLAnnotationProperty)ax.getProperty(), ax.getValue(), OWLAPIStreamUtils.asList((Stream)ax.annotations()), frame);
        if (!success) {
            this.untranslatableAxioms.add((OWLAxiom)ax);
        }
    }

    protected boolean tr(OWLAnnotationProperty prop, OWLAnnotationValue annVal, Collection<OWLAnnotation> qualifiers, Frame frame) {
        String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
        OBOFormatConstants.OboFormatTag tag = null;
        if (tagString != null) {
            tag = OBOFormatConstants.getTag(tagString);
        }
        if (tag == null) {
            String propId;
            if (annVal.isIRI() && Frame.FrameType.TERM.equals((Object)frame.getType()) && this.isMetadataTag(prop) && (propId = this.getIdentifier((OWLObject)prop)) != null) {
                Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP);
                clause.addValue(propId);
                clause.addValue(OWLAPIOwl2Obo.getIdentifier((IRI)annVal));
                OWLAPIOwl2Obo.addQualifiers(clause, qualifiers.stream());
                frame.addClause(clause);
                return true;
            }
            return this.trGenericPropertyValue(prop, annVal, qualifiers.stream(), frame);
        }
        Object value = this.getValue(annVal, tagString);
        String valueString = value.toString().trim();
        if (!valueString.isEmpty()) {
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ID) {
                if (!value.equals(frame.getId())) {
                    this.warn("Conflicting id definitions: 1) " + frame.getId() + "  2)" + valueString);
                    return false;
                }
                return true;
            }
            Clause clause = new Clause(tag);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                try {
                    clause.addValue(OBOFormatConstants.headerDateFormat().parseObject(valueString));
                }
                catch (ParseException e) {
                    this.error("Could not parse date string: " + value, true);
                    return false;
                }
            } else {
                clause.addValue(value);
            }
            HashSet<OWLAnnotation> unprocessedQualifiers = new HashSet<OWLAnnotation>(qualifiers);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
                for (OWLAnnotation aan : qualifiers) {
                    String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
                    if (!"xref".equals(propId)) continue;
                    OWLAnnotationValue v = aan.getValue();
                    String xrefValue = v.isIRI() ? v.toString() : ((OWLLiteral)v).getLiteral();
                    Xref xref = new Xref(xrefValue);
                    clause.addXref(xref);
                    unprocessedQualifiers.remove(aan);
                }
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
                Xref xref = new Xref(valueString);
                for (OWLAnnotation annotation : qualifiers) {
                    OWLAnnotationValue owlAnnotationValue;
                    if (!this.df.getRDFSLabel().equals(annotation.getProperty()) || !((owlAnnotationValue = annotation.getValue()) instanceof OWLLiteral)) continue;
                    unprocessedQualifiers.remove(annotation);
                    String xrefAnnotation = ((OWLLiteral)owlAnnotationValue).getLiteral();
                    if ((xrefAnnotation = xrefAnnotation.trim()).isEmpty()) continue;
                    xref.setAnnotation(xrefAnnotation);
                }
                clause.setValue(xref);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EXACT || tag == OBOFormatConstants.OboFormatTag.TAG_NARROW || tag == OBOFormatConstants.OboFormatTag.TAG_BROAD || tag == OBOFormatConstants.OboFormatTag.TAG_RELATED) {
                this.handleSynonym(qualifiers, tag.getTag(), clause, unprocessedQualifiers);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
                String synonymType = null;
                this.handleSynonym(qualifiers, synonymType, clause, unprocessedQualifiers);
            }
            OWLAPIOwl2Obo.addQualifiers(clause, unprocessedQualifiers.stream());
            boolean redundant = false;
            for (Clause frameClause : frame.getClauses()) {
                if (!clause.equals(frameClause)) continue;
                redundant = this.handleDuplicateClause(frame, frameClause);
            }
            if (!redundant) {
                frame.addClause(clause);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isMetadataTag(OWLAnnotationProperty p) {
        IRI metadataTagIRI = IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#", (String)OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag());
        return this.owlOntology.annotationAssertionAxioms((OWLAnnotationSubject)p.getIRI()).anyMatch(ax -> metadataTagIRI.equals((Object)((OWLAnnotationProperty)ax.getProperty()).getIRI()));
    }

    protected void handleSynonym(Collection<OWLAnnotation> qualifiers, @Nullable String scope, Clause clause, Set<OWLAnnotation> unprocessedQualifiers) {
        clause.setTag(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag());
        String type = null;
        clause.setXrefs(new ArrayList<Xref>());
        for (OWLAnnotation aan : qualifiers) {
            String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
            if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(propId)) {
                OWLAnnotationValue v = aan.getValue();
                String xrefValue = v.isIRI() ? v.toString() : ((OWLLiteral)v).getLiteral();
                Xref xref = new Xref(xrefValue);
                clause.addXref(xref);
                unprocessedQualifiers.remove(aan);
                continue;
            }
            if (!OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag().equals(propId)) continue;
            type = this.getIdentifier((OWLObject)aan.getValue());
            unprocessedQualifiers.remove(aan);
        }
        if (scope != null) {
            clause.addValue(scope);
            if (type != null) {
                clause.addValue(type);
            }
        }
    }

    protected boolean handleDuplicateClause(Frame frame, Clause clause) {
        LOG.error("Duplicate clause '{}' generated in frame: {}", (Object)clause, (Object)frame.getId());
        return true;
    }

    protected boolean trGenericPropertyValue(OWLAnnotationProperty prop, OWLAnnotationValue annVal, Stream<OWLAnnotation> qualifiers, Frame frame) {
        Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        String propId = this.getIdentifier((OWLObject)prop);
        OWLAPIOwl2Obo.addQualifiers(clause, qualifiers);
        if (!OWLAPIOwl2Obo.shorthand(propId)) {
            clause.addValue(propId);
            if (annVal instanceof OWLLiteral) {
                OWLLiteral owlLiteral = (OWLLiteral)annVal;
                clause.addValue(owlLiteral.getLiteral());
                OWLDatatype datatype = owlLiteral.getDatatype();
                IRI dataTypeIri = datatype.getIRI();
                if (!OWL2Datatype.isBuiltIn((IRI)dataTypeIri)) {
                    this.error("Untranslatable axiom due to unknown data type: " + annVal, true);
                    return false;
                }
                if (Namespaces.XSD.inNamespace(dataTypeIri)) {
                    clause.addValue(dataTypeIri.prefixedBy("xsd:"));
                } else if (dataTypeIri.isPlainLiteral()) {
                    clause.addValue("xsd:string");
                } else {
                    clause.addValue(dataTypeIri.toString());
                }
            } else if (annVal.isIRI()) {
                clause.addValue(OWLAPIOwl2Obo.getIdentifier((IRI)annVal));
            }
            frame.addClause(clause);
        }
        return true;
    }

    protected Object getValue(OWLAnnotationValue annVal, @Nullable String tag) {
        Object value = annVal.toString();
        if (annVal instanceof OWLLiteral) {
            OWLLiteral l = (OWLLiteral)annVal;
            value = l.isBoolean() ? Boolean.valueOf(l.parseBoolean()) : l.getLiteral();
        } else if (annVal.isIRI()) {
            value = OWLAPIOwl2Obo.getIdentifier((IRI)annVal);
        }
        if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(tag)) {
            String s = value.toString();
            Matcher matcher = this.absoluteURLPattern.matcher(s);
            while (matcher.find()) {
                String m = matcher.group();
                m = m.replace("<", "");
                m = m.replace(">", "");
                int i = m.lastIndexOf(47);
                m = m.substring(i + 1);
                s = s.replace(matcher.group(), m);
            }
            value = s;
        }
        return value;
    }

    protected void tr(OWLOntology ontology) {
        Frame f = new Frame(Frame.FrameType.HEADER);
        this.getObodoc().setHeaderFrame(f);
        ontology.directImportsDocuments().forEach(iri -> f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_IMPORT.getTag()).withValue(iri.toString())));
        String id = OWLAPIOwl2Obo.getOntologyId(ontology);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY.getTag());
        c.setValue(id);
        f.addClause(c);
        String vid = OWLAPIOwl2Obo.getDataVersion(ontology);
        if (vid != null) {
            Clause c2 = new Clause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION.getTag());
            c2.setValue(vid);
            f.addClause(c2);
        }
        List collect = OWLAPIStreamUtils.asList((Stream)ontology.annotations());
        for (OWLAnnotation ann : collect) {
            OWLAnnotationProperty property = ann.getProperty();
            String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)property);
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tagString)) {
                property = this.df.getOWLAnnotationProperty(OWLAPIObo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
            }
            this.tr(property, ann.getValue(), OWLAPIStreamUtils.asList((Stream)ann.annotations()), f);
        }
    }

    protected void tr(OWLEquivalentClassesAxiom ax) {
        ArrayList<Clause> equivalenceAxiomClauses;
        boolean isUntranslateable;
        Frame f;
        block23: {
            block25: {
                String cls2;
                OWLClassExpression ce2;
                block24: {
                    block22: {
                        if (ax.classExpressions().count() != 2L) {
                            this.error((OWLAxiom)ax, false);
                            return;
                        }
                        Iterator it = ax.classExpressions().iterator();
                        OWLClassExpression ce1 = (OWLClassExpression)it.next();
                        ce2 = (OWLClassExpression)it.next();
                        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
                            this.error("Equivalent classes axioms using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax, false);
                            return;
                        }
                        if (!(ce1 instanceof OWLClass)) {
                            if (ce2 instanceof OWLClass) {
                                OWLClassExpression temp = ce2;
                                ce2 = ce1;
                                ce1 = temp;
                            } else {
                                this.error("GCI axioms are not expressible in OBO.", (OWLAxiom)ax, false);
                                return;
                            }
                        }
                        f = this.getTermFrame(ce1.asOWLClass());
                        isUntranslateable = false;
                        equivalenceAxiomClauses = new ArrayList<Clause>();
                        cls2 = this.getIdentifier((OWLObject)ce2);
                        if (cls2 == null) break block22;
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
                        c.setValue(cls2);
                        f.addClause(c);
                        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
                        break block23;
                    }
                    if (!(ce2 instanceof OWLObjectUnionOf)) break block24;
                    List list2 = ((OWLObjectUnionOf)ce2).getOperandsAsList();
                    for (OWLClassExpression oce : list2) {
                        String id = this.getIdentifier((OWLObject)oce);
                        if (id == null) {
                            this.error((OWLAxiom)ax, true);
                            return;
                        }
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
                        c.setValue(id);
                        equivalenceAxiomClauses.add(c);
                        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
                    }
                    break block23;
                }
                if (!(ce2 instanceof OWLObjectIntersectionOf)) break block25;
                List list2 = ((OWLObjectIntersectionOf)ce2).getOperandsAsList();
                for (OWLClassExpression ce : list2) {
                    Boolean allOnly;
                    Boolean allSome;
                    Integer max;
                    Integer min;
                    Integer exact;
                    String r;
                    block27: {
                        Set operands;
                        block31: {
                            OWLClassExpression filler;
                            OWLObjectAllValuesFrom all;
                            block32: {
                                block30: {
                                    OWLObjectExactCardinality card;
                                    block29: {
                                        block28: {
                                            block26: {
                                                r = null;
                                                cls2 = this.getIdentifier((OWLObject)ce);
                                                exact = null;
                                                min = null;
                                                max = null;
                                                allSome = null;
                                                allOnly = null;
                                                if (!(ce instanceof OWLObjectSomeValuesFrom)) break block26;
                                                OWLObjectSomeValuesFrom ristriction = (OWLObjectSomeValuesFrom)ce;
                                                r = this.getIdentifier((OWLObject)ristriction.getProperty());
                                                cls2 = this.getIdentifier(ristriction.getFiller());
                                                break block27;
                                            }
                                            if (!(ce instanceof OWLObjectExactCardinality)) break block28;
                                            card = (OWLObjectExactCardinality)ce;
                                            r = this.getIdentifier((OWLObject)card.getProperty());
                                            cls2 = this.getIdentifier(card.getFiller());
                                            exact = card.getCardinality();
                                            break block27;
                                        }
                                        if (!(ce instanceof OWLObjectMinCardinality)) break block29;
                                        card = (OWLObjectMinCardinality)ce;
                                        r = this.getIdentifier((OWLObject)card.getProperty());
                                        cls2 = this.getIdentifier(card.getFiller());
                                        min = card.getCardinality();
                                        break block27;
                                    }
                                    if (!(ce instanceof OWLObjectMaxCardinality)) break block30;
                                    card = (OWLObjectMaxCardinality)ce;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier(card.getFiller());
                                    max = card.getCardinality();
                                    break block27;
                                }
                                if (!(ce instanceof OWLObjectAllValuesFrom)) break block31;
                                all = (OWLObjectAllValuesFrom)ce;
                                filler = (OWLClassExpression)all.getFiller();
                                if (!(filler instanceof OWLClass)) break block32;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier((OWLObject)filler);
                                allOnly = Boolean.TRUE;
                                break block27;
                            }
                            if (!(filler instanceof OWLObjectComplementOf)) break block27;
                            OWLObjectComplementOf restriction = (OWLObjectComplementOf)filler;
                            r = this.getIdentifier((OWLObject)all.getProperty());
                            cls2 = this.getIdentifier((OWLObject)restriction.getOperand());
                            exact = 0;
                            break block27;
                        }
                        if (ce instanceof OWLObjectIntersectionOf && (operands = OWLAPIStreamUtils.asSet((Stream)((OWLObjectIntersectionOf)ce).operands(), OWLClassExpression.class)).size() == 2) {
                            for (OWLClassExpression operand : operands) {
                                OWLObjectAllValuesFrom all;
                                OWLObjectMinCardinality card;
                                if (operand instanceof OWLObjectMinCardinality) {
                                    card = (OWLObjectMinCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier(card.getFiller());
                                    min = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectMaxCardinality) {
                                    card = (OWLObjectMaxCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier(card.getFiller());
                                    max = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectAllValuesFrom) {
                                    all = (OWLObjectAllValuesFrom)operand;
                                    r = this.getIdentifier((OWLObject)all.getProperty());
                                    cls2 = this.getIdentifier(all.getFiller());
                                    allOnly = Boolean.TRUE;
                                    continue;
                                }
                                if (!(operand instanceof OWLObjectSomeValuesFrom)) continue;
                                all = (OWLObjectSomeValuesFrom)operand;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier(all.getFiller());
                                allSome = Boolean.TRUE;
                            }
                        }
                    }
                    if (cls2 != null) {
                        String string;
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
                        if (r != null) {
                            c.addValue(r);
                        }
                        c.addValue(cls2);
                        equivalenceAxiomClauses.add(c);
                        if (exact != null) {
                            string = exact.toString();
                            c.addQualifierValue(new QualifierValue("cardinality", string));
                        }
                        if (min != null) {
                            string = min.toString();
                            c.addQualifierValue(new QualifierValue(MIN_CARDINALITY, string));
                        }
                        if (max != null) {
                            string = max.toString();
                            c.addQualifierValue(new QualifierValue(MAX_CARDINALITY, string));
                        }
                        if (allSome != null) {
                            string = allSome.toString();
                            c.addQualifierValue(new QualifierValue("all_some", string));
                        }
                        if (allOnly != null) {
                            string = allOnly.toString();
                            c.addQualifierValue(new QualifierValue("all_only", string));
                        }
                        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
                        continue;
                    }
                    if (!f.getClauses(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF).isEmpty()) {
                        this.error("The axiom is not translated (maximimum one IntersectionOf EquivalenceAxiom)", (OWLAxiom)ax, false);
                        continue;
                    }
                    isUntranslateable = true;
                    this.error((OWLAxiom)ax, false);
                }
                break block23;
            }
            isUntranslateable = true;
            this.error((OWLAxiom)ax, false);
        }
        if (!isUntranslateable) {
            equivalenceAxiomClauses.forEach(f::addClause);
        }
    }

    protected void tr(OWLDisjointClassesAxiom ax) {
        String cls2;
        if (ax.classExpressions().count() != 2L) {
            this.error("Expected two classes in a disjoin classes axiom.", (OWLAxiom)ax, false);
        }
        Iterator it = ax.classExpressions().iterator();
        OWLClassExpression ce1 = (OWLClassExpression)it.next();
        OWLClassExpression ce2 = (OWLClassExpression)it.next();
        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
            this.error("Disjoint classes axiom using Top or Bottom entities are not supported.", (OWLAxiom)ax, false);
        }
        if ((cls2 = this.getIdentifier((OWLObject)ce2)) == null) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        if (ce1.isAnonymous()) {
            this.error((OWLAxiom)ax, false);
            return;
        }
        OWLClass cls1 = ce1.asOWLClass();
        Frame f = this.getTermFrame(cls1);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        c.setValue(cls2);
        f.addClause(c);
        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
    }

    protected void tr(OWLDeclarationAxiom axiom) {
        OWLEntity entity = axiom.getEntity();
        if (entity.isBottomEntity() || entity.isTopEntity()) {
            return;
        }
        List set = OWLAPIStreamUtils.asList((Stream)this.owlOntology.annotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI()));
        if (set.isEmpty()) {
            return;
        }
        boolean isClass = entity.isOWLClass();
        boolean isObjectProperty = entity.isOWLObjectProperty();
        Optional<OboAltIdCheckResult> altIdOptional = OWLAPIOwl2Obo.checkForOboAltId(set);
        if (altIdOptional.isPresent()) {
            String currentId = OWLAPIOwl2Obo.getIdentifier(entity.getIRI());
            this.addAltId(altIdOptional.get().replacedBy, currentId, isClass, isObjectProperty);
            this.untranslatableAxioms.addAll(altIdOptional.get().unrelated);
            return;
        }
        Frame f = null;
        if (isClass) {
            f = this.getTermFrame(entity.asOWLClass());
        } else if (isObjectProperty) {
            f = this.getTypedefFrame((OWLEntity)entity.asOWLObjectProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            for (OWLAnnotationAssertionAxiom ax : set) {
                OWLAnnotationProperty prop = (OWLAnnotationProperty)ax.getProperty();
                String tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
                if (!OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag().equals(tag)) continue;
                f = this.getTypedefFrame(entity);
                break;
            }
        }
        if (f != null) {
            Frame f1 = f;
            set.forEach(a -> this.tr((OWLAnnotationAssertionAxiom)a, f1));
            this.add(f);
        }
    }

    private void addAltId(String replacedBy, String altId, boolean isClass, boolean isProperty) {
        Frame replacedByFrame = null;
        if (isClass) {
            replacedByFrame = this.getTermFrame(replacedBy);
        } else if (isProperty) {
            replacedByFrame = this.getTypedefFrame(replacedBy);
        }
        if (replacedByFrame != null) {
            boolean addClause = true;
            List<Clause> existing = replacedByFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_ALT_ID);
            for (Clause clause : existing) {
                if (!altId.equals(clause.getValue(String.class))) continue;
                addClause = false;
            }
            if (addClause) {
                replacedByFrame.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ALT_ID, altId));
            }
        }
    }

    @Nullable
    public String getIdentifier(OWLObject obj) {
        try {
            return OWLAPIOwl2Obo.getIdentifierFromObject(obj, this.getOWLOntology());
        }
        catch (UntranslatableAxiomException e) {
            this.error(e.getMessage(), true);
            return null;
        }
    }

    public boolean isMuteUntranslatableAxioms() {
        return this.muteUntranslatableAxioms;
    }

    public void setMuteUntranslatableAxioms(boolean muteUntranslatableAxioms) {
        this.muteUntranslatableAxioms = muteUntranslatableAxioms;
    }

    protected Frame getTermFrame(OWLClass entity) {
        String id = OWLAPIOwl2Obo.getIdentifier(entity.getIRI());
        return this.getTermFrame(id);
    }

    private Frame getTermFrame(String id) {
        Frame f = this.getObodoc().getTermFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TERM);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected Frame getTypedefFrame(OWLEntity entity) {
        String id = this.getIdentifier((OWLObject)entity);
        return this.getTypedefFrame((String)OWLAPIPreconditions.checkNotNull((Object)id));
    }

    private Frame getTypedefFrame(String id) {
        Frame f = this.getObodoc().getTypedefFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TYPEDEF);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected void tr(OWLClassAssertionAxiom ax) {
        OWLClassExpression cls = ax.getClassExpression();
        if (!(cls instanceof OWLClass)) {
            return;
        }
        String clsIRI = ((OWLClass)cls).getIRI().toString();
        Frame f = (Frame)OWLAPIPreconditions.checkNotNull((Object)this.getObodoc().getHeaderFrame());
        assert (f != null);
        if (IRI_CLASS_SYNONYMTYPEDEF.equals(clsIRI)) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag());
            OWLNamedIndividual indv = (OWLNamedIndividual)ax.getIndividual();
            String indvId = (String)OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)indv));
            indvId = indvId.replaceFirst(".*:", "");
            c.addValue(indvId);
            c.addValue(indvId);
            String nameValue = "";
            String scopeValue = null;
            Optional<Object> a = EntitySearcher.getAnnotationObjects((OWLEntity)indv, (OWLOntology)this.getOWLOntology(), (OWLAnnotationProperty)this.df.getRDFSLabel()).findFirst();
            if (a.isPresent()) {
                nameValue = '\"' + ((OWLLiteral)((OWLAnnotation)a.get()).getValue().asLiteral().get()).getLiteral() + '\"';
            }
            if ((a = EntitySearcher.getAnnotationObjects((OWLEntity)indv, (OWLOntology)this.getOWLOntology()).filter(ann -> !ann.getProperty().equals(this.df.getRDFSLabel())).findFirst()).isPresent()) {
                scopeValue = ((OWLLiteral)((OWLAnnotation)a.get()).getValue().asLiteral().get()).getLiteral();
            }
            c.addValue(nameValue);
            if (scopeValue != null && !scopeValue.isEmpty()) {
                c.addValue(scopeValue);
            }
            f.addClause(c);
        } else if (IRI_CLASS_SUBSETDEF.equals(clsIRI)) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag());
            OWLNamedIndividual indv = (OWLNamedIndividual)ax.getIndividual();
            String indvId = (String)OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)indv));
            indvId = indvId.replaceFirst(".*:", "");
            c.addValue(indvId);
            String nameValue = "";
            Optional value = EntitySearcher.getAnnotationObjects((OWLEntity)indv, (OWLOntology)this.getOWLOntology(), (OWLAnnotationProperty)this.df.getRDFSLabel()).findFirst();
            if (value.isPresent()) {
                nameValue = '\"' + ((OWLLiteral)((OWLAnnotation)value.get()).getValue().asLiteral().get()).getLiteral() + '\"';
            }
            c.addValue(nameValue);
            f.addClause(c);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void tr(OWLSubClassOfAxiom ax) {
        String fillerId;
        OWLClassExpression filler;
        void var2_4;
        Clause c;
        Set xs;
        OWLClassExpression oWLClassExpression = ax.getSubClass();
        OWLClassExpression sup = ax.getSuperClass();
        if (oWLClassExpression.isOWLNothing() || oWLClassExpression.isTopEntity() || sup.isTopEntity() || sup.isOWLNothing()) {
            this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
            return;
        }
        HashSet<QualifierValue> qvs = new HashSet<QualifierValue>();
        if (oWLClassExpression instanceof OWLObjectIntersectionOf && (xs = OWLAPIStreamUtils.asSet((Stream)((OWLObjectIntersectionOf)oWLClassExpression).operands(), OWLClassExpression.class)).size() == 2) {
            c = null;
            OWLObjectProperty p = null;
            OWLClass filler2 = null;
            for (OWLClassExpression x : xs) {
                OWLObjectSomeValuesFrom r;
                if (x instanceof OWLClass) {
                    c = (OWLClass)x;
                }
                if (!(x instanceof OWLObjectSomeValuesFrom) || !(r = (OWLObjectSomeValuesFrom)x).getProperty().isOWLObjectProperty() || !(r.getFiller() instanceof OWLClass)) continue;
                p = r.getProperty().asOWLObjectProperty();
                filler2 = (OWLClass)r.getFiller();
            }
            if (c != null && p != null && filler2 != null) {
                Clause clause = c;
                qvs.add(new QualifierValue("gci_relation", (String)OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)p))));
                qvs.add(new QualifierValue("gci_filler", (String)OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)filler2))));
            }
        }
        if (!(var2_4 instanceof OWLClass)) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        Frame f = this.getTermFrame((OWLClass)var2_4);
        if (sup instanceof OWLClass) {
            c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
            c.setValue(OWLAPIPreconditions.checkNotNull((Object)this.getIdentifier((OWLObject)sup)));
            c.setQualifierValues(qvs);
            f.addClause(c);
            OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
            return;
        }
        if (sup instanceof OWLObjectCardinalityRestriction) {
            OWLObjectCardinalityRestriction cardinality = (OWLObjectCardinalityRestriction)sup;
            filler = (OWLClassExpression)cardinality.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            f.addClause(this.createRelationshipClauseWithCardinality(cardinality, fillerId, qvs, ax));
            return;
        }
        if (sup instanceof OWLQuantifiedObjectRestriction) {
            OWLQuantifiedObjectRestriction r = (OWLQuantifiedObjectRestriction)sup;
            filler = (OWLClassExpression)r.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            if (r instanceof OWLObjectAllValuesFrom) {
                qvs.add(new QualifierValue("all_only", "true"));
            }
            f.addClause(this.createRelationshipClauseWithRestrictions(r, fillerId, qvs, ax));
            return;
        }
        if (!(sup instanceof OWLObjectIntersectionOf)) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        OWLObjectIntersectionOf i = (OWLObjectIntersectionOf)sup;
        List<Clause> clauses = new ArrayList<Clause>();
        List collect = OWLAPIStreamUtils.asList((Stream)i.operands());
        for (OWLClassExpression operand : collect) {
            String fillerId2;
            OWLClassExpression filler3;
            OWLObjectCardinalityRestriction restriction;
            if (operand instanceof OWLObjectCardinalityRestriction) {
                restriction = (OWLObjectCardinalityRestriction)operand;
                filler3 = (OWLClassExpression)restriction.getFiller();
                if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                    this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                    return;
                }
                fillerId2 = this.getIdentifier((OWLObject)filler3);
                if (fillerId2 == null) {
                    this.error((OWLAxiom)ax, true);
                    return;
                }
                clauses.add(this.createRelationshipClauseWithCardinality(restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
                continue;
            }
            if (!(operand instanceof OWLQuantifiedObjectRestriction)) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            restriction = (OWLQuantifiedObjectRestriction)operand;
            filler3 = (OWLClassExpression)restriction.getFiller();
            if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                this.error(TOP_BOTTOM_NONTRANSLATEABLE, (OWLAxiom)ax, false);
                return;
            }
            fillerId2 = this.getIdentifier((OWLObject)filler3);
            if (fillerId2 == null) {
                this.error((OWLAxiom)ax, true);
                return;
            }
            clauses.add(this.createRelationshipClauseWithRestrictions((OWLQuantifiedObjectRestriction)restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
        }
        if (clauses.isEmpty()) {
            this.error((OWLAxiom)ax, true);
            return;
        }
        clauses = OWLAPIOwl2Obo.normalizeRelationshipClauses(clauses);
        clauses.forEach(f::addClause);
    }

    protected Clause createRelationshipClauseWithRestrictions(OWLQuantifiedObjectRestriction r, String fillerId, Set<QualifierValue> qvs, OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)r.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
        return c;
    }

    protected Clause createRelationshipClauseWithCardinality(OWLObjectCardinalityRestriction restriction, String fillerId, Set<QualifierValue> qvs, OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)restriction.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        String q = "cardinality";
        if (restriction instanceof OWLObjectMinCardinality) {
            q = MIN_CARDINALITY;
        } else if (restriction instanceof OWLObjectMaxCardinality) {
            q = MAX_CARDINALITY;
        }
        c.addQualifierValue(new QualifierValue(q, Integer.toString(restriction.getCardinality())));
        OWLAPIOwl2Obo.addQualifiers(c, ax.annotations());
        return c;
    }

    protected void error(String message, OWLAxiom ax, boolean shouldLogComplaint) {
        this.untranslatableAxioms.add(ax);
        this.error(message + ax, shouldLogComplaint);
    }

    protected void error(OWLAxiom ax, boolean shouldLogComplaint) {
        this.untranslatableAxioms.add(ax);
        this.error("the axiom is not translated : " + ax, shouldLogComplaint);
    }

    protected void error(String message, boolean shouldLogComplaint) {
        if (this.strictConversion) {
            throw new OWLRuntimeException("The conversion is halted: " + message);
        }
        if (!this.muteUntranslatableAxioms && shouldLogComplaint) {
            LOG.error("MASKING ERROR \u00ab{}\u00bb", (Object)message, (Object)new Exception());
        }
    }

    protected void warn(String message) {
        if (this.strictConversion) {
            throw new OWLRuntimeException("The conversion is halted: " + message);
        }
        LOG.warn("MASKING ERROR \u00ab{}\u00bb", (Object)message);
    }

    class Translator
    implements OWLAxiomVisitor {
        Translator() {
        }

        public void visit(OWLDeclarationAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLSubClassOfAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLDisjointClassesAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLEquivalentClassesAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLClassAssertionAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLSubObjectPropertyOfAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLObjectPropertyRangeAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLSymmetricObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLObjectPropertyDomainAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLInverseObjectPropertiesAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLDisjointObjectPropertiesAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void visit(OWLSubPropertyChainOfAxiom ax) {
            OWLAPIOwl2Obo.this.tr(ax);
        }

        public void doDefault(Object o) {
            if (!(o instanceof OWLAnnotationAssertionAxiom)) {
                OWLAPIOwl2Obo.this.error((OWLAxiom)o, false);
            }
        }
    }

    public static class UntranslatableAxiomException
    extends Exception {
        public UntranslatableAxiomException(String message, Throwable cause) {
            super(message, cause);
        }

        public UntranslatableAxiomException(String message) {
            super(message);
        }
    }

    private static class OboAltIdCheckResult {
        final String replacedBy;
        final Set<OWLAnnotationAssertionAxiom> unrelated;

        OboAltIdCheckResult(String replacedBy, Set<OWLAnnotationAssertionAxiom> unrelated) {
            this.replacedBy = replacedBy;
            this.unrelated = unrelated;
        }
    }
}

