/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.sets.ObjectHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

class HPPCSet<S>
implements Collection<S> {
    private final ObjectHashSet<S> delegate;
    private final Class<S> witness;

    public HPPCSet(Class<S> c) {
        this.delegate = new ObjectHashSet();
        this.witness = c;
    }

    public HPPCSet(int initialCapacity, Class<S> c) {
        this.delegate = new ObjectHashSet(initialCapacity);
        this.witness = c;
    }

    public HPPCSet(int initialCapacity, double loadFactor, Class<S> c) {
        this.delegate = new ObjectHashSet(initialCapacity, loadFactor);
        this.witness = c;
    }

    public HPPCSet(Collection<S> container, Class<S> c) {
        this.delegate = new ObjectHashSet(container.size() + 1);
        this.witness = c;
        this.addAll((Collection<? extends S>)container);
    }

    public HPPCSet(Collection<S> container, S s, Class<S> c) {
        this.delegate = new ObjectHashSet(container.size() + 1);
        this.witness = c;
        this.addAll((Collection<? extends S>)container);
        this.add(s);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.witness.isInstance(o) && this.delegate.contains(this.witness.cast(o));
    }

    @Override
    public Iterator<S> iterator() {
        ArrayList l = new ArrayList();
        Consumer<ObjectCursor> c = q -> l.add(q.value);
        this.delegate.forEach(c);
        return l.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(@Nullable T[] a) {
        throw new UnsupportedOperationException("Not suppoerted for " + this.getClass());
    }

    @Override
    public boolean add(@Nullable S e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (this.witness.isInstance(o)) {
            return this.delegate.remove(this.witness.cast(o));
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (Object o : c) {
            if (this.witness.isInstance(o) && this.delegate.contains(this.witness.cast(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends S> c) {
        if (c == null) {
            return false;
        }
        boolean toReturn = false;
        for (S s : c) {
            if (!this.add(s)) continue;
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean toReturn = false;
        for (Object s : c) {
            if (!this.remove(s)) continue;
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public boolean retainAll(@Nullable Collection<?> c) {
        return this.delegate.retainAll(new HPPCSet<?>(OWLAPIPreconditions.verifyNotNull(c), this.witness).delegate) > 0;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

