/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.renderer.AbstractRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousClassExpression;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterOWLSyntaxObjectRenderer
extends AbstractRenderer
implements OWLObjectVisitor {
    private boolean wrapSave;
    private boolean tabSave;

    public ManchesterOWLSyntaxObjectRenderer(Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
    }

    protected void write(Stream<? extends OWLObject> objects, ManchesterOWLSyntax delimeter, boolean newline) {
        int tab = this.getIndent();
        this.pushTab(tab);
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            ((OWLObject)it.next()).accept(this);
            if (!it.hasNext()) continue;
            if (newline && this.isUseWrapping()) {
                this.writeNewLine();
            }
            this.write(delimeter);
        }
        this.popTab();
    }

    protected void writeCommaSeparatedList(List<? extends OWLObject> objects) {
        Iterator<? extends OWLObject> it = objects.iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
    }

    protected void writeCommaSeparatedList(Stream<? extends OWLObject> objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            ((OWLObject)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
    }

    private void writeRestriction(OWLQuantifiedDataRestriction restriction, ManchesterOWLSyntax keyword) {
        restriction.getProperty().accept(this);
        this.write(keyword);
        ((OWLDataRange)restriction.getFiller()).accept(this);
    }

    private void writeRestriction(OWLQuantifiedObjectRestriction restriction, ManchesterOWLSyntax keyword) {
        restriction.getProperty().accept(this);
        this.write(keyword);
        boolean conjunctionOrDisjunction = false;
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            if (restriction.getFiller() instanceof OWLObjectIntersectionOf || restriction.getFiller() instanceof OWLObjectUnionOf) {
                conjunctionOrDisjunction = true;
                this.incrementTab(4);
                this.writeNewLine();
            }
            this.write("(");
        }
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write(")");
            if (conjunctionOrDisjunction) {
                this.popTab();
            }
        }
    }

    private <V extends OWLObject> void writeRestriction(OWLHasValueRestriction<V> restriction, OWLPropertyExpression p) {
        p.accept(this);
        this.write(ManchesterOWLSyntax.VALUE);
        restriction.getFiller().accept(this);
    }

    private <F extends OWLPropertyRange> void writeRestriction(OWLCardinalityRestriction<F> restriction, ManchesterOWLSyntax keyword, OWLPropertyExpression p) {
        p.accept(this);
        this.write(keyword);
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write("(");
        }
        ((OWLPropertyRange)restriction.getFiller()).accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write(")");
        }
    }

    @Override
    public void visit(OWLClass ce) {
        this.write(this.getShortFormProvider().getShortForm(ce));
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        boolean first = true;
        Iterator it = ce.operands().iterator();
        while (it.hasNext()) {
            OWLObject desc = (OWLObject)it.next();
            if (!first) {
                if (this.isUseWrapping()) {
                    this.writeNewLine();
                }
                this.write(" ", ManchesterOWLSyntax.AND, " ");
            }
            first = false;
            if (desc instanceof OWLAnonymousClassExpression) {
                this.write("(");
            }
            desc.accept(this);
            if (!(desc instanceof OWLAnonymousClassExpression)) continue;
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        boolean first = true;
        Iterator it = ce.operands().iterator();
        while (it.hasNext()) {
            OWLClassExpression op = (OWLClassExpression)it.next();
            if (!first) {
                this.write(" ", ManchesterOWLSyntax.OR, " ");
            }
            first = false;
            if (op.isAnonymous()) {
                this.write("(");
            }
            op.accept(this);
            if (!op.isAnonymous()) continue;
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.write("", ManchesterOWLSyntax.NOT, ce.isAnonymous() ? " " : "");
        if (ce.isAnonymous()) {
            this.write("(");
        }
        ce.getOperand().accept(this);
        if (ce.isAnonymous()) {
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.writeRestriction(ce, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.MIN, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.EXACTLY, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.MAX, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        ce.getProperty().accept(this);
        this.write(ManchesterOWLSyntax.SELF);
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.write("{");
        this.write(ce.individuals(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.writeRestriction(ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.MIN, ce.getProperty());
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.EXACTLY, ce.getProperty());
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writeRestriction(ce, ManchesterOWLSyntax.MAX, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.write(this.getShortFormProvider().getShortForm(individual));
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLDatatype node) {
        this.write(this.getShortFormProvider().getShortForm(node));
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.toStringID());
    }

    @Override
    public void visit(IRI iri) {
        this.write(iri.toQuotedString());
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.writeAnnotations(node.annotations().iterator());
        node.getProperty().accept(this);
        this.writeSpace();
        node.getValue().accept(this);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(ManchesterOWLSyntax.NOT);
        if (node.getDataRange().isOWLDatatype()) {
            node.getDataRange().accept(this);
        } else {
            this.write("(");
            node.getDataRange().accept(this);
            this.write(")");
        }
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write("{");
        this.write(node.values(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.write("(");
        this.write(node.operands(), ManchesterOWLSyntax.AND, false);
        this.write(")");
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.write("(");
        this.write(node.operands(), ManchesterOWLSyntax.OR, false);
        this.write(")");
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        this.write("[");
        this.write(node.facetRestrictions(), ManchesterOWLSyntax.FACET_RESTRICTION_SEPARATOR, false);
        this.write("]");
    }

    @Override
    public void visit(OWLLiteral node) {
        if (XSDVocabulary.DECIMAL.getIRI().equals(node.getDatatype().getIRI())) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().isFloat()) {
            this.write(node.getLiteral());
            this.write("f");
        } else if (node.getDatatype().isInteger()) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().isBoolean()) {
            this.write(node.getLiteral());
        } else {
            this.pushTab(this.getIndent());
            this.writeLiteral(node.getLiteral());
            if (node.hasLang()) {
                this.write("@");
                this.write(node.getLang());
            } else if (!node.isRDFPlainLiteral() && !OWL2Datatype.XSD_STRING.matches(node.getDatatype())) {
                this.write("^^");
                node.getDatatype().accept(this);
            }
            this.popTab();
        }
    }

    private void writeLiteral(String literal) {
        this.write("\"");
        for (int i = 0; i < literal.length(); ++i) {
            char ch = literal.charAt(i);
            if (ch == '\"') {
                this.write('\\');
            } else if (ch == '\\') {
                this.write('\\');
            }
            this.write(ch);
        }
        this.write("\"");
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getSymbolicForm());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.write(ManchesterOWLSyntax.INVERSE);
        this.write("(");
        property.getInverse().accept(this);
        this.write(")");
    }

    private void setAxiomWriting() {
        this.wrapSave = this.isUseWrapping();
        this.tabSave = this.isUseTabbing();
        this.setUseWrapping(false);
        this.setUseTabbing(false);
    }

    private void restore() {
        this.setUseTabbing(this.tabSave);
        this.setUseWrapping(this.wrapSave);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubClass().accept(this);
        this.write(ManchesterOWLSyntax.SUBCLASS_OF);
        axiom.getSuperClass().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
        this.restore();
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.ASYMMETRIC);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.REFLEXIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    private void writeBinaryOrNaryList(ManchesterOWLSyntax binaryKeyword, Stream<? extends OWLObject> stream, ManchesterOWLSyntax naryKeyword) {
        List<? extends OWLObject> objects = OWLAPIStreamUtils.asList(stream);
        if (objects.size() == 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            it.next().accept(this);
            this.write(binaryKeyword);
            it.next().accept(this);
        } else {
            this.writeSectionKeyword(naryKeyword);
            this.writeCommaSeparatedList(objects);
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.classExpressions(), ManchesterOWLSyntax.DISJOINT_CLASSES);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.EQUIVALENT_TO, axiom.properties(), ManchesterOWLSyntax.EQUIVALENT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.write(")");
        this.restore();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DIFFERENT_FROM, axiom.individuals(), ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.properties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.properties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.FUNCTIONAL);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getOWLClass().accept(this);
        this.write(ManchesterOWLSyntax.DISJOINT_UNION_OF);
        this.writeCommaSeparatedList(axiom.classExpressions());
        this.restore();
    }

    private void writeFrameType(OWLObject object) {
        this.setAxiomWriting();
        if (object instanceof OWLOntology) {
            this.writeFrameKeyword(ManchesterOWLSyntax.ONTOLOGY);
            OWLOntology ont = (OWLOntology)object;
            if (!ont.isAnonymous()) {
                this.write("<");
                this.write(ont.getOntologyID().getOntologyIRI().get().toString());
                this.write(">");
            }
        } else if (object instanceof OWLClassExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.CLASS);
        } else if (object instanceof OWLObjectPropertyExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.OBJECT_PROPERTY);
        } else if (object instanceof OWLDataPropertyExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.DATA_PROPERTY);
        } else if (object instanceof OWLIndividual) {
            this.writeFrameKeyword(ManchesterOWLSyntax.INDIVIDUAL);
        } else if (object instanceof OWLAnnotationProperty) {
            this.writeFrameKeyword(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
        }
        object.accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.setAxiomWriting();
        this.writeFrameType(axiom.getEntity());
        this.restore();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.setAxiomWriting();
        ((OWLAnnotationSubject)axiom.getSubject()).accept(this);
        this.write(" ");
        axiom.getAnnotation().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        ((IRI)axiom.getDomain()).accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        ((IRI)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubProperty().accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.SYMMETRIC);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.RANGE);
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.FUNCTIONAL);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeFrameKeyword(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES);
        this.writeCommaSeparatedList(axiom.properties());
        this.restore();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getIndividual().accept(this);
        this.write(ManchesterOWLSyntax.TYPE);
        axiom.getClassExpression().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.EQUIVALENT_TO, axiom.classExpressions(), ManchesterOWLSyntax.EQUIVALENT_CLASSES);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.TRANSITIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.IRREFLEXIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.INVERSE_FUNCTIONAL);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.SAME_AS, axiom.individuals(), ManchesterOWLSyntax.SAME_INDIVIDUAL);
        this.restore();
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.setAxiomWriting();
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(" o ");
        }
        this.writeSectionKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        axiom.getSuperProperty().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        axiom.getFirstProperty().accept(this);
        this.write(ManchesterOWLSyntax.INVERSE_OF);
        axiom.getSecondProperty().accept(this);
        this.restore();
    }

    @Override
    public void visit(SWRLRule rule) {
        this.setAxiomWriting();
        Iterator it = rule.body().iterator();
        while (it.hasNext()) {
            ((SWRLAtom)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(" -> ");
        it = rule.head().iterator();
        while (it.hasNext()) {
            ((SWRLAtom)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.restore();
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.setAxiomWriting();
        axiom.getClassExpression().accept(this);
        this.write(ManchesterOWLSyntax.HAS_KEY);
        this.write(axiom.objectPropertyExpressions(), ManchesterOWLSyntax.COMMA, false);
        this.write(axiom.dataPropertyExpressions(), ManchesterOWLSyntax.COMMA, false);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        if (node.getPredicate().isAnonymous()) {
            this.write("(");
        }
        node.getPredicate().accept(this);
        if (node.getPredicate().isAnonymous()) {
            this.write(")");
        }
        this.write("(");
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        SWRLBuiltInsVocabulary voc = SWRLBuiltInsVocabulary.getBuiltIn(node.getPredicate());
        if (voc != null) {
            this.write(voc.getPrefixedName());
        } else {
            this.write(node.getPredicate().toQuotedString());
        }
        this.write("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            ((SWRLDArgument)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(")");
    }

    @Override
    public void visit(SWRLVariable node) {
        this.write("?");
        if ("urn:swrl:var#".equals(node.getIRI().getNamespace()) || "urn:swrl#".equals(node.getIRI().getNamespace())) {
            this.write(node.getIRI().prefixedBy(""));
        } else {
            this.write(node.getIRI().toQuotedString());
        }
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.write(ManchesterOWLSyntax.SAME_AS);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write(ManchesterOWLSyntax.DIFFERENT_FROM);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    protected void writeAnnotations(Iterator<OWLAnnotation> annoIt) {
        if (!annoIt.hasNext()) {
            return;
        }
        this.writeNewLine();
        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
        this.write(": ");
        this.pushTab(this.getIndent());
        while (annoIt.hasNext()) {
            OWLAnnotation anno = annoIt.next();
            anno.accept(this);
            if (!annoIt.hasNext()) continue;
            this.write(", ");
            this.writeNewLine();
        }
        this.writeNewLine();
        this.writeNewLine();
        this.popTab();
    }

    @Override
    public void visit(OWLOntology ontology) {
    }
}

