/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.Literal;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class RDFLiteral
extends RDFNode
implements Literal {
    private final String lexicalValue;
    private final String lang;
    private final IRI datatype;
    private int hashCode;

    public RDFLiteral(String literal, @Nullable String lang, @Nullable IRI datatype) {
        this.lexicalValue = OWLAPIPreconditions.checkNotNull(literal, "literal cannot be null");
        this.lang = lang == null ? "" : lang.toLowerCase(Locale.ROOT);
        OWL2Datatype defaultType = this.lang.isEmpty() ? OWL2Datatype.RDF_PLAIN_LITERAL : OWL2Datatype.RDF_LANG_STRING;
        this.datatype = datatype == null ? defaultType.getIRI() : datatype;
    }

    public RDFLiteral(OWLLiteral literal) {
        this(literal.getLiteral(), literal.getLang(), literal.getDatatype().getIRI());
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37;
            this.hashCode = this.hashCode * 37 + this.lexicalValue.hashCode();
            this.hashCode = this.hashCode * 37 + this.lang.hashCode();
            this.hashCode = this.hashCode * 37 + this.datatype.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RDFLiteral) {
            RDFLiteral other = (RDFLiteral)obj;
            if (!this.lexicalValue.equals(other.lexicalValue)) {
                return false;
            }
            if (!this.lang.equals(other.lang)) {
                return false;
            }
            return this.datatype.equals(other.datatype);
        }
        if (obj instanceof RDFLiteral) {
            RDFLiteral literal = (RDFLiteral)obj;
            if (!this.getLexicalForm().equals(literal.getLexicalForm())) {
                return false;
            }
            if (!this.getLanguageTag().equals(literal.getLanguageTag())) {
                return false;
            }
            return this.getDatatype().equals(literal.getDatatype());
        }
        if (obj instanceof Literal) {
            Literal literal = (Literal)obj;
            if (!this.getLexicalForm().equals(literal.getLexicalForm())) {
                return false;
            }
            if (!this.getLanguageTag().equals(literal.getLanguageTag().map(s -> s.toLowerCase(Locale.ROOT)))) {
                return false;
            }
            return this.getDatatype().equals(literal.getDatatype());
        }
        return false;
    }

    public String toString() {
        return this.lexicalValue;
    }

    @Override
    public IRI getIRI() {
        throw new UnsupportedOperationException("RDF Literals do not have IRIs");
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    public String getLexicalForm() {
        return this.getLexicalValue();
    }

    public String getLang() {
        return this.lang;
    }

    public Optional<String> getLanguageTag() {
        if (this.hasLang()) {
            return Optional.of(this.lang);
        }
        return Optional.empty();
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    public boolean hasLang() {
        return !this.lang.isEmpty();
    }

    public boolean isPlainLiteral() {
        return OWL2Datatype.RDF_PLAIN_LITERAL.getIRI().equals(this.datatype);
    }

    @Override
    public int compareTo(@Nullable RDFNode o) {
        OWLAPIPreconditions.checkNotNull(o);
        assert (o != null);
        if (!o.isLiteral()) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        RDFLiteral lit2 = (RDFLiteral)o;
        int diff = this.lexicalValue.compareTo(lit2.lexicalValue);
        if (diff == 0) {
            diff = this.getDatatype().compareTo(lit2.getDatatype());
        }
        if (diff == 0) {
            diff = this.getLang().compareTo(lit2.getLang());
        }
        return diff;
    }

    public String ntriplesString() {
        String escaped = '\"' + EscapeUtils.escapeString(this.getLexicalValue()).replace("\n", "\\n").replace("\r", "\\r") + '\"';
        if (this.datatype.equals(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI()) || this.datatype.equals(OWL2Datatype.XSD_STRING.getIRI())) {
            return escaped;
        }
        if (this.hasLang()) {
            return escaped + "@" + this.getLang();
        }
        return escaped + "^^" + this.getDatatype().ntriplesString();
    }
}

