/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.RootClassChecker;

public class SimpleRootClassChecker
implements RootClassChecker {
    private final Collection<OWLOntology> ontologies;
    private final RootClassCheckerHelper checker = new RootClassCheckerHelper();
    private final NamedSuperChecker superChecker = new NamedSuperChecker();

    public SimpleRootClassChecker(Collection<OWLOntology> ontologies) {
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    @Override
    public boolean isRootClass(OWLClass cls) {
        return !this.ontologies.stream().flatMap(o -> o.referencingAxioms(cls)).anyMatch(ax -> this.isRootClass(cls, (OWLAxiom)ax));
    }

    private boolean isRootClass(OWLClass cls, OWLAxiom ax) {
        return ax.accept(this.checker.setOWLClass(cls)) == false;
    }

    protected boolean check(OWLClassExpression e) {
        this.superChecker.reset();
        e.accept(this.superChecker);
        return !this.superChecker.namedSuper;
    }

    private class RootClassCheckerHelper
    implements OWLAxiomVisitorEx<Boolean> {
        private Boolean isRoot = Boolean.TRUE;
        @Nullable
        private OWLClass cls = null;

        public RootClassCheckerHelper setOWLClass(OWLClass cls) {
            this.isRoot = Boolean.TRUE;
            this.cls = cls;
            return this;
        }

        private OWLClass cls() {
            return OWLAPIPreconditions.verifyNotNull(this.cls, "cls cannot be null. Has the helper been initialised with a valid value?");
        }

        @Override
        public Boolean visit(OWLSubClassOfAxiom axiom) {
            if (axiom.getSubClass().equals(this.cls())) {
                this.isRoot = SimpleRootClassChecker.this.check(axiom.getSuperClass());
            }
            return this.isRoot;
        }

        @Override
        public Boolean visit(OWLEquivalentClassesAxiom axiom) {
            if (!OWLAPIStreamUtils.contains(axiom.classExpressions(), this.cls())) {
                return this.isRoot;
            }
            boolean check = false;
            Iterator it = axiom.classExpressions().iterator();
            while (it.hasNext()) {
                OWLClassExpression desc = (OWLClassExpression)it.next();
                if (desc.equals(this.cls) || !(check = SimpleRootClassChecker.this.check(desc))) continue;
                this.isRoot = Boolean.FALSE;
                return this.isRoot;
            }
            this.isRoot = check;
            return this.isRoot;
        }
    }

    private static class NamedSuperChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        protected boolean namedSuper;

        NamedSuperChecker() {
        }

        public void reset() {
            this.namedSuper = false;
        }

        @Override
        public Boolean visit(OWLClass ce) {
            this.namedSuper = true;
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return ce.operands().anyMatch(op -> op.accept(this));
        }
    }
}

