/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.axes.FilterExprWalker;
import net.sourceforge.htmlunit.xpath.axes.HasPositionalPredChecker;
import net.sourceforge.htmlunit.xpath.axes.LocPathIterator;
import net.sourceforge.htmlunit.xpath.axes.PathComponent;
import net.sourceforge.htmlunit.xpath.axes.UnionChildIterator;
import net.sourceforge.htmlunit.xpath.axes.WalkerFactory;
import net.sourceforge.htmlunit.xpath.axes.WalkingIterator;
import net.sourceforge.htmlunit.xpath.compiler.Compiler;
import net.sourceforge.htmlunit.xpath.compiler.OpMap;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTM;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMIterator;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
PathComponent {
    protected LocPathIterator[] m_exprs;
    protected DTMIterator[] m_iterators;

    @Override
    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        try {
            if (null != this.m_exprs) {
                int n = this.m_exprs.length;
                DTMIterator[] newIters = new DTMIterator[n];
                for (int i = 0; i < n; ++i) {
                    DTMIterator iter;
                    newIters[i] = iter = this.m_exprs[i].asIterator(this.m_execContext, context);
                    iter.nextNode();
                }
                this.m_iterators = newIters;
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    @Override
    public void detach() {
        if (this.m_allowDetach && null != this.m_iterators) {
            for (DTMIterator m_iterator : this.m_iterators) {
                m_iterator.detach();
            }
            this.m_iterators = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int opPos) throws TransformerException {
        UnionPathIterator upi = new UnionPathIterator(compiler, opPos);
        int nPaths = upi.m_exprs.length;
        boolean isAllChildIterators = true;
        for (int i = 0; i < nPaths; ++i) {
            LocPathIterator lpi = upi.m_exprs[i];
            if (lpi.getAxis() != 3) {
                isAllChildIterators = false;
                break;
            }
            if (!HasPositionalPredChecker.check(lpi)) continue;
            isAllChildIterators = false;
            break;
        }
        if (isAllChildIterators) {
            UnionChildIterator uci = new UnionChildIterator();
            for (int i = 0; i < nPaths; ++i) {
                LocPathIterator lpi = upi.m_exprs[i];
                uci.addNodeTest(lpi);
            }
            return uci;
        }
        return upi;
    }

    @Override
    public int getAnalysisBits() {
        int bits = 0;
        if (this.m_exprs != null) {
            for (LocPathIterator m_expr : this.m_exprs) {
                int bit = m_expr.getAnalysisBits();
                bits |= bit;
            }
        }
        return bits;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        if (this.m_iterators != null) {
            int n = this.m_iterators.length;
            clone.m_iterators = new DTMIterator[n];
            for (int i = 0; i < n; ++i) {
                clone.m_iterators[i] = (DTMIterator)this.m_iterators[i].clone();
            }
        }
        return clone;
    }

    protected LocPathIterator createDTMIterator(Compiler compiler, int opPos) throws TransformerException {
        return (LocPathIterator)WalkerFactory.newDTMIterator(compiler, opPos, compiler.getLocationPathDepth() <= 0);
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOp(opPos);
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.m_exprs[count] = this.createDTMIterator(compiler, opPos);
            this.m_exprs[count].exprSetParent(this);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    WalkingIterator iter = new WalkingIterator(compiler.getNamespaceContext());
                    iter.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.m_exprs[count] = iter;
                    break;
                }
                default: {
                    this.m_exprs = new LocPathIterator[count];
                }
            }
        }
    }

    @Override
    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int earliestNode = -1;
        if (null != this.m_iterators) {
            int n = this.m_iterators.length;
            int iteratorUsed = -1;
            for (int i = 0; i < n; ++i) {
                int node = this.m_iterators[i].getCurrentNode();
                if (-1 == node) continue;
                if (-1 == earliestNode) {
                    iteratorUsed = i;
                    earliestNode = node;
                    continue;
                }
                if (node == earliestNode) {
                    this.m_iterators[i].nextNode();
                    continue;
                }
                DTM dtm = this.getDTM(node);
                if (!dtm.isNodeAfter(node, earliestNode)) continue;
                iteratorUsed = i;
                earliestNode = node;
            }
            if (-1 != earliestNode) {
                this.m_iterators[iteratorUsed].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    @Override
    public int getAxis() {
        return -1;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        if (visitor.visitUnionPath() && null != this.m_exprs) {
            for (LocPathIterator m_expr : this.m_exprs) {
                m_expr.callVisitors(visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        UnionPathIterator upi = (UnionPathIterator)expr;
        if (null != this.m_exprs) {
            int n = this.m_exprs.length;
            if (null == upi.m_exprs || upi.m_exprs.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_exprs[i].deepEquals(upi.m_exprs[i])) continue;
                return false;
            }
        } else if (null != upi.m_exprs) {
            return false;
        }
        return true;
    }
}

