/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSParseException;
import com.gargoylesoftware.css.parser.CSSParser;
import com.gargoylesoftware.css.parser.CssCharStream;
import com.gargoylesoftware.css.parser.DocumentHandler;
import com.gargoylesoftware.css.parser.HandlerBase;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.LexicalUnit;
import com.gargoylesoftware.css.parser.LexicalUnitImpl;
import com.gargoylesoftware.css.parser.Locator;
import com.gargoylesoftware.css.parser.javacc.CharStream;
import com.gargoylesoftware.css.parser.javacc.ParseException;
import com.gargoylesoftware.css.parser.javacc.Token;
import com.gargoylesoftware.css.parser.javacc.TokenMgrError;
import com.gargoylesoftware.css.parser.media.MediaQueryList;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import org.w3c.dom.DOMException;

public abstract class AbstractCSSParser
implements CSSParser {
    private DocumentHandler documentHandler_;
    private CSSErrorHandler errorHandler_;
    private InputSource source_;
    private static final HashMap<String, String> parserMessages_ = new HashMap();
    private boolean ieStarHackAccepted_;
    private static final String NUM_CHARS = "0123456789.";

    protected DocumentHandler getDocumentHandler() {
        if (this.documentHandler_ == null) {
            this.setDocumentHandler(new HandlerBase());
        }
        return this.documentHandler_;
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler_ = handler;
    }

    protected CSSErrorHandler getErrorHandler() {
        if (this.errorHandler_ == null) {
            this.setErrorHandler(new HandlerBase());
        }
        return this.errorHandler_;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler eh) {
        this.errorHandler_ = eh;
    }

    protected InputSource getInputSource() {
        return this.source_;
    }

    @Override
    public void setIeStarHackAccepted(boolean accepted) {
        this.ieStarHackAccepted_ = accepted;
    }

    @Override
    public boolean isIeStarHackAccepted() {
        return this.ieStarHackAccepted_;
    }

    protected String getParserMessage(String key) {
        String msg = parserMessages_.get(key);
        if (msg == null) {
            return "[[" + key + "]]";
        }
        return msg;
    }

    protected Locator createLocator(Token t) {
        return new Locator(this.getInputSource().getURI(), t == null ? 0 : t.beginLine, t == null ? 0 : t.beginColumn);
    }

    protected String addEscapes(String str) {
        StringBuilder sb = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        sb.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected CSSParseException toCSSParseException(String key, ParseException e) {
        String messagePattern1 = this.getParserMessage("invalidExpectingOne");
        String messagePattern2 = this.getParserMessage("invalidExpectingMore");
        int maxSize = 0;
        StringBuilder expected = new StringBuilder();
        for (int i = 0; i < e.expectedTokenSequences.length; ++i) {
            if (maxSize < e.expectedTokenSequences[i].length) {
                maxSize = e.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < e.expectedTokenSequences[i].length; ++j) {
                expected.append(e.tokenImage[e.expectedTokenSequences[i][j]]);
            }
            if (i >= e.expectedTokenSequences.length - 1) continue;
            expected.append(", ");
        }
        StringBuilder invalid = new StringBuilder();
        Token tok = e.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                invalid.append(" ");
            }
            if (tok.kind == 0) {
                invalid.append(e.tokenImage[0]);
                break;
            }
            invalid.append(this.addEscapes(tok.image));
            tok = tok.next;
        }
        StringBuilder message = new StringBuilder(this.getParserMessage(key));
        message.append(" (");
        if (e.expectedTokenSequences.length == 1) {
            message.append(MessageFormat.format(messagePattern1, invalid, expected));
        } else {
            message.append(MessageFormat.format(messagePattern2, invalid, expected));
        }
        message.append(")");
        return new CSSParseException(message.toString(), this.getInputSource().getURI(), e.currentToken.next.beginLine, e.currentToken.next.beginColumn);
    }

    protected CSSParseException toCSSParseException(DOMException e) {
        String messagePattern = this.getParserMessage("domException");
        return new CSSParseException(MessageFormat.format(messagePattern, e.getMessage()), this.getInputSource().getURI(), 1, 1);
    }

    protected CSSParseException toCSSParseException(TokenMgrError e) {
        String messagePattern = this.getParserMessage("tokenMgrError");
        return new CSSParseException(messagePattern, this.getInputSource().getURI(), 1, 1);
    }

    protected CSSParseException toCSSParseException(String messageKey, Object[] msgParams, Locator locator) {
        String messagePattern = this.getParserMessage(messageKey);
        return new CSSParseException(MessageFormat.format(messagePattern, msgParams), locator);
    }

    protected CSSParseException createSkipWarning(String messageKey, CSSParseException e) {
        return new CSSParseException(this.getParserMessage(messageKey), e.getURI(), e.getLineNumber(), e.getColumnNumber());
    }

    @Override
    public void parseStyleSheet(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        try {
            this.styleSheet();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleSheet", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    @Override
    public void parseStyleDeclaration(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        try {
            this.styleDeclaration();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleDeclaration", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    @Override
    public void parseRule(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        try {
            this.styleSheetRuleSingle();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidRule", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    @Override
    public SelectorList parseSelectors(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        SelectorList sl = null;
        try {
            sl = this.parseSelectorsInternal();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidSelectorList", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return sl;
    }

    @Override
    public LexicalUnit parsePropertyValue(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        LexicalUnit lu = null;
        try {
            lu = this.expr();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidExpr", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return lu;
    }

    @Override
    public boolean parsePriority(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        boolean b = false;
        try {
            b = this.prio();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidPrio", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return b;
    }

    public MediaQueryList parseMedia(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(AbstractCSSParser.getCharStream(source));
        MediaQueryList ml = new MediaQueryList();
        try {
            this.mediaList(ml);
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidMediaList", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return ml;
    }

    private static CharStream getCharStream(InputSource source) throws IOException {
        if (source.getReader() != null) {
            return new CssCharStream(source.getReader(), 1, 1);
        }
        if (source.getURI() != null) {
            InputStreamReader reader = new InputStreamReader(new URL(source.getURI()).openStream());
            return new CssCharStream(reader, 1, 1);
        }
        return null;
    }

    @Override
    public abstract String getParserVersion();

    protected abstract void ReInit(CharStream var1);

    protected abstract void styleSheet() throws CSSParseException, ParseException;

    protected abstract void styleDeclaration() throws ParseException;

    protected abstract void styleSheetRuleSingle() throws ParseException;

    protected abstract SelectorList parseSelectorsInternal() throws ParseException;

    protected abstract LexicalUnit expr() throws ParseException;

    protected abstract boolean prio() throws ParseException;

    protected abstract void mediaList(MediaQueryList var1) throws ParseException;

    protected void handleStartDocument() {
        this.getDocumentHandler().startDocument(this.getInputSource());
    }

    protected void handleEndDocument() {
        this.getDocumentHandler().endDocument(this.getInputSource());
    }

    protected void handleIgnorableAtRule(String s, Locator locator) {
        this.getDocumentHandler().ignorableAtRule(s, locator);
    }

    protected void handleCharset(String characterEncoding, Locator locator) {
        this.getDocumentHandler().charset(characterEncoding, locator);
    }

    protected void handleImportStyle(String uri, MediaQueryList media, String defaultNamespaceURI, Locator locator) {
        this.getDocumentHandler().importStyle(uri, media, defaultNamespaceURI, locator);
    }

    protected void handleStartMedia(MediaQueryList media, Locator locator) {
        this.getDocumentHandler().startMedia(media, locator);
    }

    protected void handleMedium(String medium, Locator locator) {
    }

    protected void handleEndMedia(MediaQueryList media) {
        this.getDocumentHandler().endMedia(media);
    }

    protected void handleStartPage(String name, String pseudoPage, Locator locator) {
        this.getDocumentHandler().startPage(name, pseudoPage, locator);
    }

    protected void handleEndPage(String name, String pseudoPage) {
        this.getDocumentHandler().endPage(name, pseudoPage);
    }

    protected void handleStartFontFace(Locator locator) {
        this.getDocumentHandler().startFontFace(locator);
    }

    protected void handleEndFontFace() {
        this.getDocumentHandler().endFontFace();
    }

    protected void handleStartSelector(SelectorList selectors, Locator locator) {
        this.getDocumentHandler().startSelector(selectors, locator);
    }

    protected void handleEndSelector(SelectorList selectors) {
        this.getDocumentHandler().endSelector(selectors);
    }

    protected void handleProperty(String name, LexicalUnit value, boolean important, Locator locator) {
        this.getDocumentHandler().property(name, value, important, locator);
    }

    protected LexicalUnit functionInternal(LexicalUnit prev, String funct, LexicalUnit params) {
        if ("counter(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createCounter(prev, params);
        }
        if ("counters(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createCounters(prev, params);
        }
        if ("attr(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createAttr(prev, params.getStringValue());
        }
        if ("rect(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createRect(prev, params);
        }
        if ("rgb(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createRgbColor(prev, params);
        }
        return LexicalUnitImpl.createFunction(prev, funct.substring(0, funct.length() - 1), params);
    }

    protected LexicalUnit hexcolorInternal(LexicalUnit prev, Token t) {
        boolean i = true;
        int r = 0;
        int g = 0;
        int b = 0;
        int len = t.image.length() - 1;
        try {
            if (len == 3) {
                r = Integer.parseInt(t.image.substring(1, 2), 16);
                g = Integer.parseInt(t.image.substring(2, 3), 16);
                b = Integer.parseInt(t.image.substring(3, 4), 16);
                r = r << 4 | r;
                g = g << 4 | g;
                b = b << 4 | b;
            } else if (len == 6) {
                r = Integer.parseInt(t.image.substring(1, 3), 16);
                g = Integer.parseInt(t.image.substring(3, 5), 16);
                b = Integer.parseInt(t.image.substring(5, 7), 16);
            } else {
                String pattern = this.getParserMessage("invalidColor");
                throw new CSSParseException(MessageFormat.format(pattern, t), this.getInputSource().getURI(), t.beginLine, t.beginColumn);
            }
            LexicalUnit lr = LexicalUnitImpl.createNumber(null, r);
            LexicalUnit lc1 = LexicalUnitImpl.createComma(lr);
            LexicalUnit lg = LexicalUnitImpl.createNumber(lc1, g);
            LexicalUnit lc2 = LexicalUnitImpl.createComma(lg);
            LexicalUnitImpl.createNumber(lc2, b);
            return LexicalUnitImpl.createRgbColor(prev, lr);
        }
        catch (NumberFormatException ex) {
            String pattern = this.getParserMessage("invalidColor");
            throw new CSSParseException(MessageFormat.format(pattern, t), this.getInputSource().getURI(), t.beginLine, t.beginColumn, ex);
        }
    }

    protected int intValue(char op, String s) {
        int result = Integer.parseInt(s);
        if (op == '-') {
            return -1 * result;
        }
        return result;
    }

    protected double doubleValue(char op, String s) {
        double result = Double.parseDouble(s);
        if (op == '-') {
            return -1.0 * result;
        }
        return result;
    }

    protected int getLastNumPos(String s) {
        int i;
        for (i = 0; i < s.length() && NUM_CHARS.indexOf(s.charAt(i)) >= 0; ++i) {
        }
        return i - 1;
    }

    public String unescape(String s, boolean unescapeDoubleQuotes) {
        if (s == null) {
            return s;
        }
        StringBuilder buf = null;
        int index = -1;
        int len = s.length();
        --len;
        if (unescapeDoubleQuotes) {
            while (index < len) {
                char c;
                if ((c = s.charAt(++index)) != '\\' && c != '\"') continue;
                buf = new StringBuilder(len);
                buf.append(s.substring(0, index));
                --index;
                break;
            }
        } else {
            while (index < len) {
                if ('\\' != s.charAt(++index)) continue;
                buf = new StringBuilder(len);
                buf.append(s.substring(0, index));
                --index;
                break;
            }
        }
        if (null == buf) {
            return s;
        }
        int numValue = -1;
        int digitCount = 0;
        while (index < len) {
            char c = s.charAt(++index);
            if (numValue > -1) {
                int hexval = AbstractCSSParser.hexval(c);
                if (hexval != -1) {
                    numValue = numValue * 16 + hexval;
                    if (++digitCount < 6) continue;
                    if (numValue > 65535 || numValue == 0) {
                        numValue = 65533;
                    }
                    buf.append((char)numValue);
                    numValue = -1;
                    continue;
                }
                if (digitCount > 0) {
                    if (numValue > 65535 || numValue == 0) {
                        numValue = 65533;
                    }
                    buf.append((char)numValue);
                    if (c == ' ' || c == '\t') {
                        numValue = -1;
                        continue;
                    }
                }
                numValue = -1;
                if (digitCount == 0 && c == '\\') {
                    buf.append('\\');
                    continue;
                }
                if (c == '\n' || c == '\f') continue;
                if (c == '\r') {
                    if (index >= len || s.charAt(index + 1) != '\n') continue;
                    ++index;
                    continue;
                }
            }
            if (c == '\\') {
                numValue = 0;
                digitCount = 0;
                continue;
            }
            if (c == '\"' && !unescapeDoubleQuotes) {
                buf.append('\\');
            }
            buf.append(c);
        }
        if (numValue > -1) {
            if (digitCount == 0) {
                buf.append('\\');
            } else {
                if (numValue > 65535 || numValue == 0) {
                    numValue = 65533;
                }
                buf.append((char)numValue);
            }
        }
        return buf.toString();
    }

    private static int hexval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    static {
        parserMessages_.put("invalidExpectingOne", "Invalid token \"{0}\". Was expecting: {1}.");
        parserMessages_.put("invalidExpectingMore", "Invalid token \"{0}\". Was expecting one of: {1}.");
        parserMessages_.put("invalidColor", "Invalid color \"{0}\".");
        parserMessages_.put("invalidStyleSheet", "Error in style sheet.");
        parserMessages_.put("invalidRule", "Error in rule.");
        parserMessages_.put("invalidUnknownRule", "Error in unknown at-rule.");
        parserMessages_.put("invalidCharsetRule", "Error in @charset rule.");
        parserMessages_.put("misplacedCharsetRule", "The @charset must be the first element in the style sheet.");
        parserMessages_.put("invalidImportRule", "Error in @import rule.");
        parserMessages_.put("invalidImportRuleIgnored", "@import rule must occur before all other rules.");
        parserMessages_.put("invalidImportRuleIgnored2", "@import rule must occur before all other rules, except the @charset rule.");
        parserMessages_.put("invalidPageRule", "Error in @page rule.");
        parserMessages_.put("invalidFontFaceRule", "Error in @font-face rule.");
        parserMessages_.put("invalidMediaList", "Error in media list.");
        parserMessages_.put("invalidMediaRule", "Error in @media rule.");
        parserMessages_.put("invalidStyleRule", "Error in style rule.");
        parserMessages_.put("invalidStyleDeclaration", "Error in style declaration.");
        parserMessages_.put("invalidDeclaration", "Error in declaration.");
        parserMessages_.put("invalidDeclarationInvalidChar", "Error in declaration; invalid character \"{0}\" found.");
        parserMessages_.put("invalidDeclarationStarHack", "Error in declaration. ''*'' is not allowed as first char of a property.");
        parserMessages_.put("invalidSelectorList", "Error in selector list.");
        parserMessages_.put("invalidSelector", "Error in selector.");
        parserMessages_.put("invalidSimpleSelector", "Error in simple selector.");
        parserMessages_.put("invalidClassSelector", "Error in class selector.");
        parserMessages_.put("invalidElementName", "Error in element name.");
        parserMessages_.put("invalidAttrib", "Error in attribute selector.");
        parserMessages_.put("invalidPseudo", "Error in pseudo class or element.");
        parserMessages_.put("duplicatePseudo", "Duplicate pseudo class \":{0}\" or pseudo class \":{0}\" not at end.");
        parserMessages_.put("invalidHash", "Error in hash.");
        parserMessages_.put("invalidExpr", "Error in expression.");
        parserMessages_.put("invalidExprColon", "Error in expression; '':'' found after identifier \"{0}\".");
        parserMessages_.put("invalidPrio", "Error in priority.");
        parserMessages_.put("ignoringRule", "Ignoring the whole rule.");
        parserMessages_.put("ignoringFollowingDeclarations", "Ignoring the following declarations in this rule.");
        parserMessages_.put("tokenMgrError", "Lexical error.");
        parserMessages_.put("domException", "DOM exception: ''{0}''");
    }
}

