/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PartETag;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartResult;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.StorageInfo$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!\u0002\u0014(\u0001\u001d\u0002\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aq\r\u0001B\u0001B\u0003%q\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\u000fY\u0004\u0001\u0019!C\u0005o\"1Q\u0010\u0001Q!\nMDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!9\u0011q\u0001\u0001!B\u0013\u0019\u0007\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\t\u0019\u0002\u0001Q\u0001\n\u00055\u0001\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\r\u0011%\t9\u0003\u0001a\u0001\n\u0013\t9\u0002C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!A\u0011q\u0006\u0001!B\u0013\tI\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024!A\u0011q\t\u0001!\u0002\u0013\t)\u0004\u0003\u0005\u0002J\u0001\u0001\r\u0011\"\u0003\u0000\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005C\u0004\u0002R\u0001\u0001\u000b\u0015B2\t\u0013\u0005M\u0003A1A\u0005\n\u0005U\u0003bBA,\u0001\u0001\u0006Ia\u0018\u0005\n\u00033\u0002!\u0019!C\u0005\u00037B\u0001\"a\u001a\u0001A\u0003%\u0011Q\f\u0005\u000b\u0003S\u0002\u0001R1A\u0005\n\u0005-\u0004BCA:\u0001!\u0015\r\u0011\"\u0003\u0002v!A\u0011Q\u0010\u0001\u0005\u0002\u001d\ny\bC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBAM\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003[\u0003A\u0011IAL\u0005Q\u00196'\u00169m_\u0006$w*\u001e;qkR\u001cFO]3b[*\u0011\u0001&K\u0001\u0003S>T!AK\u0016\u0002\u0013Mtwn\u001e4mC.,'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tQcFC\u00010\u0003\rqW\r^\n\u0003\u0001E\u0002\"A\r\u001c\u000e\u0003MR!\u0001\u000b\u001b\u000b\u0003U\nAA[1wC&\u0011qg\r\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\tgN\u001aE.[3oi\u000e\u0001\u0001CA\u001eI\u001b\u0005a$BA\u001f?\u0003\t\u00198G\u0003\u0002@\u0001\u0006A1/\u001a:wS\u000e,7O\u0003\u0002B\u0005\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0003\u0007\u0012\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u001a\u000bAA\u001b3cG*\u0011q)L\u0001\u0007G2LWM\u001c;\n\u0005%c$AD!nCj|gnU\u001aDY&,g\u000e^\u0001\u0005[\u0016$\u0018\r\u0005\u0002M\u001f6\tQJ\u0003\u0002Oy\u0005)Qn\u001c3fY&\u0011\u0001+\u0014\u0002\u000f\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0003-\u0019Ho\u001c:bO\u0016LeNZ8\u0011\tMcvl\u0018\b\u0003)j\u0003\"!\u0016-\u000e\u0003YS!aV\u001d\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0004\u001b\u0006\u0004(BA.Y!\t\u0019\u0006-\u0003\u0002b=\n11\u000b\u001e:j]\u001e\f!BY;gM\u0016\u00148+\u001b>f!\t!W-D\u0001Y\u0013\t1\u0007LA\u0002J]R\fAAZ5mK\u00061A(\u001b8jiz\"bA\u001b7n]>\u0004\bCA6\u0001\u001b\u00059\u0003\"\u0002\u001d\u0007\u0001\u0004Q\u0004\"\u0002&\u0007\u0001\u0004Y\u0005\"B)\u0007\u0001\u0004\u0011\u0006\"\u00022\u0007\u0001\u0004\u0019\u0007\"B4\u0007\u0001\u0004y\u0016AF;tK6+H\u000e^5qY\u0016\u0014En\\2l+Bdw.\u00193\u0016\u0003M\u0004\"\u0001\u001a;\n\u0005UD&a\u0002\"p_2,\u0017M\\\u0001\u001bkN,W*\u001e7uSBdWM\u00117pG.,\u0006\u000f\\8bI~#S-\u001d\u000b\u0003qn\u0004\"\u0001Z=\n\u0005iD&\u0001B+oSRDq\u0001 \u0005\u0002\u0002\u0003\u00071/A\u0002yIE\nq#^:f\u001bVdG/\u001b9mK\ncwnY6Va2|\u0017\r\u001a\u0011\u0002!\u0011\fG/Y*ju\u0016LeNQ;gM\u0016\u0014X#A2\u0002)\u0011\fG/Y*ju\u0016LeNQ;gM\u0016\u0014x\fJ3r)\rA\u0018Q\u0001\u0005\by.\t\t\u00111\u0001d\u0003E!\u0017\r^1TSj,\u0017J\u001c\"vM\u001a,'\u000fI\u0001\u0016Ef$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n+\t\ti\u0001E\u00023\u0003\u001fI1!!\u00054\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\faCY=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW\u000eI\u0001\u000ei>$\u0018\r\u001c#bi\u0006\u001c\u0016N_3\u0016\u0005\u0005e\u0001c\u00013\u0002\u001c%\u0019\u0011Q\u0004-\u0003\t1{gnZ\u0001\u0012i>$\u0018\r\u001c#bi\u0006\u001c\u0016N_3`I\u0015\fHc\u0001=\u0002$!AA\u0010EA\u0001\u0002\u0004\tI\"\u0001\bu_R\fG\u000eR1uCNK'0\u001a\u0011\u0002\u001fQ|G/\u00197Va2|\u0017\r\u001a+j[\u0016\f1\u0003^8uC2,\u0006\u000f\\8bIRKW.Z0%KF$2\u0001_A\u0017\u0011!a8#!AA\u0002\u0005e\u0011\u0001\u0005;pi\u0006dW\u000b\u001d7pC\u0012$\u0016.\\3!\u0003%\u0001\u0018M\u001d;F)\u0006<7/\u0006\u0002\u00026A1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005mB'\u0001\u0003vi&d\u0017\u0002BA \u0003s\u0011\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u00071\u000b\u0019%C\u0002\u0002F5\u0013\u0001\u0002U1si\u0016#\u0016mZ\u0001\u000ba\u0006\u0014H/\u0012+bON\u0004\u0013A\u00029beRLE-\u0001\u0006qCJ$\u0018\nZ0%KF$2\u0001_A(\u0011\u001da\b$!AA\u0002\r\fq\u0001]1si&#\u0007%\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016,\u0012aX\u0001\fEV\u001c7.\u001a;OC6,\u0007%A\u0004lKft\u0015-\\3\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rD'\u0001\u0003mC:<\u0017bA1\u0002b\u0005A1.Z=OC6,\u0007%A\u0006j]&$(+Z9vKN$XCAA7!\ra\u0015qN\u0005\u0004\u0003cj%AH%oSRL\u0017\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e%\u0016\fX/Z:u\u00031Ig.\u001b;SKN\u0004xN\\:f+\t\t9\bE\u0002M\u0003sJ1!a\u001fN\u0005uIe.\u001b;jCR,W*\u001e7uSB\f'\u000f^+qY>\fGMU3tk2$\u0018AF4fi\u0012\u000bG/Y%o\u0005V4g-\u001a:G_J$Vm\u001d;\u0015\u0005\u0005\u0005\u0005#\u00023\u0002\u0004\u0006\u001d\u0015bAAC1\n)\u0011I\u001d:bsB\u0019A-!#\n\u0007\u0005-\u0005L\u0001\u0003CsR,\u0017aD;qY>\fG\rR1uC\u000eCWO\\6\u0015\u0007a\f\t\n\u0003\u0004\u0002\u0014\u0006\u0002\ra]\u0001\fSNd\u0015m\u001d;DQVt7.A\be_V\u0003Hn\\1e\u001f:,\u0007+\u0019:u)\u0005A\u0018!B<sSR,Gc\u0001=\u0002\u001e\"1\u0011qT\u0012A\u0002\r\f\u0011A\u0019\u000b\bq\u0006\r\u0016QUAU\u0011\u001d\ty\n\na\u0001\u0003\u0003Ca!a*%\u0001\u0004\u0019\u0017aA8gM\"1\u00111\u0016\u0013A\u0002\r\f1\u0001\\3o\u0003\u0015\u0019Gn\\:f\u0001")
public class S3UploadOutputStream
extends OutputStream {
    private InitiateMultipartUploadRequest initRequest;
    private InitiateMultipartUploadResult initResponse;
    private final AmazonS3Client s3Client;
    private final ObjectMetadata meta;
    private final int bufferSize;
    private final String file;
    private boolean useMultipleBlockUpload;
    private int dataSizeInBuffer;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private long totalDataSize;
    private long totalUploadTime;
    private final ArrayList<PartETag> partETags;
    private int partId;
    private final String bucketName;
    private final String keyName;
    private volatile byte bitmap$0;

    private boolean useMultipleBlockUpload() {
        return this.useMultipleBlockUpload;
    }

    private void useMultipleBlockUpload_$eq(boolean x$1) {
        this.useMultipleBlockUpload = x$1;
    }

    private int dataSizeInBuffer() {
        return this.dataSizeInBuffer;
    }

    private void dataSizeInBuffer_$eq(int x$1) {
        this.dataSizeInBuffer = x$1;
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    private long totalDataSize() {
        return this.totalDataSize;
    }

    private void totalDataSize_$eq(long x$1) {
        this.totalDataSize = x$1;
    }

    private long totalUploadTime() {
        return this.totalUploadTime;
    }

    private void totalUploadTime_$eq(long x$1) {
        this.totalUploadTime = x$1;
    }

    private ArrayList<PartETag> partETags() {
        return this.partETags;
    }

    private int partId() {
        return this.partId;
    }

    private void partId_$eq(int x$1) {
        this.partId = x$1;
    }

    private String bucketName() {
        return this.bucketName;
    }

    private String keyName() {
        return this.keyName;
    }

    private InitiateMultipartUploadRequest initRequest$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.initRequest = new InitiateMultipartUploadRequest(this.bucketName(), this.keyName(), this.meta);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.initRequest;
    }

    private InitiateMultipartUploadRequest initRequest() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.initRequest$lzycompute() : this.initRequest;
    }

    private InitiateMultipartUploadResult initResponse$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initResponse = this.s3Client.initiateMultipartUpload(this.initRequest());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.initResponse;
    }

    private InitiateMultipartUploadResult initResponse() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.initResponse$lzycompute() : this.initResponse;
    }

    public byte[] getDataInBufferForTest() {
        return this.byteArrayOutputStream().toByteArray();
    }

    private void uploadDataChunk(boolean isLastChunk) {
        block1: {
            block0: {
                if (!isLastChunk || this.useMultipleBlockUpload()) break block0;
                long start = System.currentTimeMillis();
                this.meta.setContentLength((long)this.dataSizeInBuffer());
                this.byteArrayOutputStream().close();
                byte[] buffer = this.byteArrayOutputStream().toByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
                this.s3Client.putObject(this.bucketName(), this.keyName(), (InputStream)inputStream, this.meta);
                long usedTime = System.currentTimeMillis() - start;
                this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
                CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append(SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX()).append(":\n           | Finish uploading file ").append(this.file).append(" without AWS multiple parts API\n           | because the data size is less than the buffer size:\n           | bufferSize=").append(Utils$.MODULE$.getSizeString(this.bufferSize)).append("\n           | compressedSize=").append(Utils$.MODULE$.getSizeString(this.dataSizeInBuffer())).append("\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)S3UploadOutputStream.$anonfun$uploadDataChunk$1(BoxesRunTime.unboxToChar((Object)x$41)))));
                break block1;
            }
            this.doUploadOnePart();
            if (!isLastChunk) break block1;
            this.byteArrayOutputStream().close();
            long start = System.currentTimeMillis();
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucketName(), this.keyName(), this.initResponse().getUploadId(), this.partETags());
            this.s3Client.completeMultipartUpload(compRequest);
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append(SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX()).append(":\n             | Finish uploading file ").append(this.file).append(" with AWS multiple parts API:\n             | bufferSize=").append(Utils$.MODULE$.getSizeString(this.bufferSize)).append(" chunkCount=").append(this.partId()).append("\n             | compressedSize=").append(Utils$.MODULE$.getSizeString(this.totalDataSize())).append("\n             |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)S3UploadOutputStream.$anonfun$uploadDataChunk$2(BoxesRunTime.unboxToChar((Object)x$42)))));
        }
    }

    private void doUploadOnePart() {
        block0: {
            long start = System.currentTimeMillis();
            this.useMultipleBlockUpload_$eq(true);
            byte[] buffer = this.byteArrayOutputStream().toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName()).withKey(this.keyName()).withUploadId(this.initResponse().getUploadId()).withPartNumber(this.partId()).withInputStream((InputStream)inputStream).withPartSize((long)this.dataSizeInBuffer());
            UploadPartResult uploadResult = this.s3Client.uploadPart(uploadRequest);
            this.partETags().add(uploadResult.getPartETag());
            this.totalDataSize_$eq(this.totalDataSize() + (long)this.dataSizeInBuffer());
            this.dataSizeInBuffer_$eq(0);
            this.partId_$eq(this.partId() + 1);
            this.byteArrayOutputStream().reset();
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            if (this.partId() != 3) break block0;
            TestHook$.MODULE$.raiseExceptionIfTestFlagEnabled(TestHookFlag$.MODULE$.TH_FAIL_UPLOAD_AWS_2ND_BLOCK(), "Negative test to raise error after upload 2nd parts");
        }
    }

    @Override
    public void write(int b) {
        if (this.dataSizeInBuffer() >= this.bufferSize) {
            this.uploadDataChunk(false);
        }
        this.byteArrayOutputStream().write(b);
        this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int inputSize = len - off;
        if (inputSize + this.dataSizeInBuffer() <= this.bufferSize) {
            this.byteArrayOutputStream().write(b, off, inputSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + inputSize);
        } else {
            int partSize;
            int firstPartSize = this.bufferSize - this.dataSizeInBuffer();
            if (firstPartSize > 0) {
                this.byteArrayOutputStream().write(b, off, firstPartSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + firstPartSize);
            }
            int leftLen = len - firstPartSize;
            int newOff = off + firstPartSize;
            do {
                this.uploadDataChunk(false);
                partSize = Math.min(this.bufferSize, leftLen);
                this.byteArrayOutputStream().write(b, newOff, partSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + partSize);
                newOff += partSize;
            } while ((leftLen -= partSize) > 0);
        }
    }

    @Override
    public void close() {
        block0: {
            if (this.dataSizeInBuffer() <= 0) break block0;
            this.uploadDataChunk(true);
        }
    }

    public static final /* synthetic */ boolean $anonfun$uploadDataChunk$1(char x$41) {
        return x$41 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$uploadDataChunk$2(char x$42) {
        return x$42 >= ' ';
    }

    public S3UploadOutputStream(AmazonS3Client s3Client, ObjectMetadata meta, Map<String, String> storageInfo, int bufferSize, String file) {
        this.s3Client = s3Client;
        this.meta = meta;
        this.bufferSize = bufferSize;
        this.file = file;
        this.useMultipleBlockUpload = false;
        this.dataSizeInBuffer = 0;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.totalDataSize = 0L;
        this.totalUploadTime = 0L;
        this.partETags = new ArrayList();
        this.partId = 1;
        this.bucketName = (String)storageInfo.apply((Object)StorageInfo$.MODULE$.BUCKET_NAME());
        this.keyName = ((String)storageInfo.apply((Object)StorageInfo$.MODULE$.PREFIX())).concat(file);
    }
}

