/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.FileUploadResult;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.WriteTableState;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class StageWriter$ {
    public static StageWriter$ MODULE$;
    private final Logger log;

    static {
        new StageWriter$();
    }

    public Logger log() {
        return this.log;
    }

    public void writeToStage(RDD<String> rdd, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, Enumeration.Value format) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Snowflake table name with the 'dbtable' parameter");
        }
        SnowflakeSQLStatement prologueSql = Utils$.MODULE$.genPrologueSql(params);
        this.log().debug(prologueSql.toString());
        Connection conn = DefaultJDBCWrapper$.MODULE$.getConnector(params);
        try {
            prologueSql.execute(params.bindVariableEnabled(), conn);
            Tuple2<CloudStorage, String> tuple2 = CloudStorageOperations$.MODULE$.createStorageClient(params, conn, true, (Option<String>)None$.MODULE$, "load");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CloudStorage storage = (CloudStorage)tuple2._1();
            String stage = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storage, (Object)stage);
            Tuple2 tuple23 = tuple22;
            CloudStorage storage2 = (CloudStorage)tuple23._1();
            String stage2 = (String)tuple23._2();
            long startTime = System.currentTimeMillis();
            List<FileUploadResult> fileUploadResults = storage2.upload(rdd, format, (Option<String>)None$.MODULE$, storage2.upload$default$4());
            long startCopyInto = System.currentTimeMillis();
            if (fileUploadResults.nonEmpty()) {
                String firstFileName = ((FileUploadResult)fileUploadResults.head()).fileName();
                this.writeToTable(conn, schema, saveMode, params, firstFileName.substring(0, firstFileName.indexOf("/")), stage2, format, fileUploadResults);
            } else {
                this.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append(SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX()).append(":\n             | Skip to execute COPY INTO TABLE command because\n             | no file is uploaded.\n             |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StageWriter$.$anonfun$writeToStage$1(BoxesRunTime.unboxToChar((Object)x$2)))));
            }
            long endTime = System.currentTimeMillis();
            this.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append(SnowflakeResultSetRDD$.MODULE$.MASTER_LOG_PREFIX()).append(":\n             | Total job time is ").append(Utils$.MODULE$.getTimeString(endTime - startTime)).append("\n             | including read & upload time:\n             | ").append(Utils$.MODULE$.getTimeString(startCopyInto - startTime)).append("\n             | and COPY time: ").append(Utils$.MODULE$.getTimeString(endTime - startCopyInto)).append(".\n             |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StageWriter$.$anonfun$writeToStage$2(BoxesRunTime.unboxToChar((Object)x$3)))));
        }
        finally {
            SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
            conn.close();
        }
    }

    private void writeToTable(Connection conn, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        if (params.useStagingTable() || !params.truncateTable()) {
            this.writeToTableWithStagingTable(conn, schema, saveMode, params, file, tempStage, format, fileUploadResults);
        } else {
            this.writeToTableWithoutStagingTable(conn, schema, saveMode, params, file, tempStage, format, fileUploadResults);
        }
    }

    private void writeToTableWithoutStagingTable(Connection conn, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        String tableName = ((TableName)params.table().get()).name();
        WriteTableState writeTableState = new WriteTableState(conn);
        try {
            SaveMode saveMode2 = saveMode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                if (DefaultJDBCWrapper$.MODULE$.tableExists(conn, tableName) && !params.truncateTable()) {
                    writeTableState.dropTable(tableName);
                }
            }
            if (!DefaultJDBCWrapper$.MODULE$.tableExists(conn, tableName)) {
                writeTableState.createTable(tableName, schema, params);
            } else if (params.truncateTable()) {
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Overwrite;
                if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null)) {
                    writeTableState.truncateTable(tableName);
                }
            }
            writeTableState.copyIntoTable(schema, saveMode, params, file, tempStage, format, fileUploadResults);
            writeTableState.commit();
        }
        catch (Exception e) {
            writeTableState.rollback();
            this.log().error(new StringBuilder(49).append("Error occurred while loading files to Snowflake: ").append(e).toString());
            throw e;
        }
    }

    private void writeToTableWithStagingTable(Connection conn, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        TableName table = (TableName)params.table().get();
        TableName tempTable = new TableName(new StringBuilder(9).append(table.name().replaceAll("\\W", "X")).append("_staging_").append(((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()).toString());
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Overwrite;
        TableName targetTable = !(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && params.useStagingTable() ? tempTable : table;
        try {
            Object object;
            SaveMode saveMode4 = saveMode;
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && DefaultJDBCWrapper$.MODULE$.tableExists(conn, table.toString())) {
                if (params.useStagingTable()) {
                    if (params.truncateTable()) {
                        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                        String x$1 = tempTable.name();
                        String x$2 = table.name();
                        boolean x$3 = qual$1.createTableLike$default$3();
                        qual$1.createTableLike(x$1, x$2, x$3);
                    }
                    object = BoxedUnit.UNIT;
                } else if (params.truncateTable()) {
                    DefaultJDBCWrapper.DataBaseOperations qual$2 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$4 = table.name();
                    boolean x$5 = qual$2.truncateTable$default$2();
                    qual$2.truncateTable(x$4, x$5);
                    object = BoxedUnit.UNIT;
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$3 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$6 = table.name();
                    boolean x$7 = qual$3.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$3.dropTable(x$6, x$7));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            SaveMode saveMode6 = saveMode;
            SaveMode saveMode7 = SaveMode.Overwrite;
            if (!(saveMode6 == null ? saveMode7 != null : !saveMode6.equals(saveMode7)) || !DefaultJDBCWrapper$.MODULE$.tableExists(conn, table.toString())) {
                DefaultJDBCWrapper.DataBaseOperations qual$4 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                String x$8 = targetTable.name();
                StructType x$9 = schema;
                Parameters.MergedParameters x$10 = params;
                boolean x$11 = false;
                boolean x$12 = false;
                boolean x$13 = qual$4.createTable$default$6();
                qual$4.createTable(x$8, x$9, x$10, x$11, x$12, x$13);
            }
            Utils$.MODULE$.executePreActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            this.executeCopyIntoTable(conn, schema, saveMode, params, targetTable, file, tempStage, format, fileUploadResults);
            Utils$.MODULE$.executePostActions(DefaultJDBCWrapper$.MODULE$, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SaveMode saveMode8 = saveMode;
            SaveMode saveMode9 = SaveMode.Overwrite;
            if (!(saveMode8 != null ? !saveMode8.equals(saveMode9) : saveMode9 != null) && params.useStagingTable()) {
                boolean x$15;
                String x$14;
                DefaultJDBCWrapper.DataBaseOperations qual$5 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                if (qual$5.tableExists(x$14 = table.toString(), x$15 = qual$5.tableExists$default$2())) {
                    DefaultJDBCWrapper.DataBaseOperations qual$6 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$16 = table.name();
                    String x$17 = tempTable.name();
                    boolean x$18 = qual$6.swapTable$default$3();
                    qual$6.swapTable(x$16, x$17, x$18);
                    DefaultJDBCWrapper.DataBaseOperations qual$7 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$19 = tempTable.name();
                    boolean x$20 = qual$7.dropTable$default$2();
                    qual$7.dropTable(x$19, x$20);
                } else {
                    DefaultJDBCWrapper.DataBaseOperations qual$8 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$21 = table.name();
                    String x$22 = tempTable.name();
                    boolean x$23 = qual$8.renameTable$default$3();
                    qual$8.renameTable(x$21, x$22, x$23);
                }
            } else {
                conn.commit();
            }
        }
        catch (Exception e) {
            Object object;
            SaveMode saveMode10 = saveMode;
            SaveMode saveMode11 = SaveMode.Overwrite;
            if (!(saveMode10 != null ? !saveMode10.equals(saveMode11) : saveMode11 != null) && params.useStagingTable()) {
                TableName tableName = targetTable;
                TableName tableName2 = tempTable;
                if (!(tableName != null ? !((Object)tableName).equals(tableName2) : tableName2 != null)) {
                    DefaultJDBCWrapper.DataBaseOperations qual$9 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
                    String x$24 = tempTable.name();
                    boolean x$25 = qual$9.dropTable$default$2();
                    object = BoxesRunTime.boxToBoolean((boolean)qual$9.dropTable(x$24, x$25));
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            this.log().error(new StringBuilder(49).append("Error occurred while loading files to Snowflake: ").append(e).toString());
            throw e;
        }
    }

    public void executeCopyIntoTable(Connection conn, StructType schema, SaveMode saveMode, Parameters.MergedParameters params, TableName targetTable, String file, String tempStage, Enumeration.Value format, List<FileUploadResult> fileUploadResults) {
        Some some;
        scala.collection.mutable.Set expectedFileSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fileUploadResults.foreach((Function1 & Serializable & scala.Serializable)fileUploadResult -> fileUploadResult.fileSize() > 0L ? expectedFileSet.$plus$eq((Object)fileUploadResult.fileName()) : BoxedUnit.UNIT);
        boolean useFilesClause = false;
        if (TestHook$.MODULE$.isTestFlagEnabled(TestHookFlag$.MODULE$.TH_COPY_INTO_TABLE_MISS_FILES_SUCCESS())) {
            useFilesClause = true;
            some = new Some(expectedFileSet.grouped(2).toList().head());
        } else {
            some = new Some((Object)expectedFileSet);
        }
        Some firstCopyFileSet = some;
        SnowflakeSQLStatement copyStatement = this.copySql(schema, saveMode, params, targetTable, file, tempStage, format, conn, useFilesClause, (Set<String>)((TraversableOnce)firstCopyFileSet.get()).toSet());
        this.log().debug(Utils$.MODULE$.sanitizeQueryText(copyStatement.toString()));
        ResultSet resultSet = copyStatement.execute(params.bindVariableEnabled(), conn);
        Utils$.MODULE$.setLastCopyLoad(copyStatement.toString());
        scala.collection.mutable.Set<String> missedFileSet = this.getCopyMissedFiles(params, resultSet, (scala.collection.mutable.Set<String>)expectedFileSet);
        if (missedFileSet.nonEmpty()) {
            Some secondCopyFileSet = TestHook$.MODULE$.isTestFlagEnabled(TestHookFlag$.MODULE$.TH_COPY_INTO_TABLE_MISS_FILES_FAIL()) ? new Some(missedFileSet.grouped(2).toList().head()) : new Some(missedFileSet);
            useFilesClause = true;
            SnowflakeSQLStatement copyWithFileClause = this.copySql(schema, saveMode, params, targetTable, file, tempStage, format, conn, useFilesClause, (Set<String>)((TraversableOnce)secondCopyFileSet.get()).toSet());
            this.log().warn(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("Some files are not loaded into the table, execute additional COPY\n           | to load them: ").append(StageWriter$.getMissedFileInfo$1(missedFileSet)).append("\n           | ").toString())).stripMargin());
            ResultSet resultSet2 = copyWithFileClause.execute(params.bindVariableEnabled(), conn);
            missedFileSet = this.getCopyMissedFiles(params, resultSet2, missedFileSet);
            if (missedFileSet.nonEmpty()) {
                throw new SnowflakeConnectorException((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(76).append("These files are missed when COPY INTO TABLE:\n             | ").append(StageWriter$.getMissedFileInfo$1(missedFileSet)).append("\n             | ").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StageWriter$.$anonfun$executeCopyIntoTable$3(BoxesRunTime.unboxToChar((Object)x$5)))));
            }
        }
    }

    private scala.collection.mutable.Set<String> getCopyMissedFiles(Parameters.MergedParameters params, ResultSet copyResultSet, scala.collection.mutable.Set<String> expectedFileSet) {
        scala.collection.mutable.Set missedFileSet;
        block4: {
            String COPY_INTO_TABLE_RESULT_COLUMN_FILE = "file";
            String COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED = "rows_parsed";
            String COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED = "rows_loaded";
            ResultSetMetaData metadata = copyResultSet.getMetaData();
            scala.collection.mutable.Set columnNameSet = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), metadata.getColumnCount()).foreach((Function1 & Serializable & scala.Serializable)i -> StageWriter$.$anonfun$getCopyMissedFiles$1(columnNameSet, metadata, BoxesRunTime.unboxToInt((Object)i)));
            if (!columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_FILE) || !columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED) && !columnNameSet.contains((Object)COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED)) {
                this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("Fail to check the COPY result because format is not supported.\n           | The column names are: ").append(columnNameSet.mkString(", ")).append("\n           | Expect to include ").append(COPY_INTO_TABLE_RESULT_COLUMN_FILE).append(" and\n           | ").append(COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED).append(" and\n           | ").append(COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED).append("\n           | ").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StageWriter$.$anonfun$getCopyMissedFiles$2(BoxesRunTime.unboxToChar((Object)x$6)))));
                return scala.collection.mutable.Set$.MODULE$.empty();
            }
            missedFileSet = expectedFileSet.clone();
            long rowSkipped = 0L;
            while (copyResultSet.next()) {
                SetLike setLike;
                String fileFullName;
                String fileNameWithoutStage;
                if (params.continueOnError()) {
                    rowSkipped += copyResultSet.getLong(COPY_INTO_TABLE_RESULT_COLUMN_ROW_PARSED) - copyResultSet.getLong(COPY_INTO_TABLE_RESULT_COLUMN_ROW_LOADED);
                }
                if (missedFileSet.contains((Object)(fileNameWithoutStage = (fileFullName = copyResultSet.getString(COPY_INTO_TABLE_RESULT_COLUMN_FILE)).replaceAll(".*/([^/]+/[^/]+)$", "$1")))) {
                    setLike = missedFileSet.$minus$eq((Object)fileNameWithoutStage);
                    continue;
                }
                this.log().warn(new StringBuilder(38).append("Load file which isn't uploaded by SC: ").append(fileFullName).toString());
                setLike = BoxedUnit.UNIT;
            }
            if (!params.continueOnError()) break block4;
            this.log().error(new StringBuilder(35).append("ON_ERROR: Continue -> Skipped ").append(rowSkipped).append(" rows").toString());
        }
        return missedFileSet;
    }

    public SnowflakeSQLStatement copySql(StructType schema, SaveMode saveMode, Parameters.MergedParameters params, TableName table, String prefix, String tempStage, Enumeration.Value format, Connection conn, boolean useFilesClause, Set<String> filesToCopy) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        SnowflakeSQLStatement onError;
        SnowflakeSQLStatement snowflakeSQLStatement2;
        None$ none$;
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Append;
        if ((saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) && params.columnMap().isDefined()) {
            throw new UnsupportedOperationException("The column mapping only works in append mode.");
        }
        SnowflakeSQLStatement fromString = new ConstantString(new StringBuilder(8).append("FROM @").append(tempStage).append("/").append(prefix).append("/").toString()).$bang();
        Option<Map<String, String>> option = params.columnMap();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            none$ = new Some(map.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    String value = (String)tuple22._2();
                    try {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(schema.fieldIndex(key) + 1)), (Object)value);
                    }
                    catch (Exception e) {
                        MODULE$.log().error(new StringBuilder(37).append("Error occurred while column mapping: ").append(e).toString());
                        throw e;
                    }
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple23 = tuple2;
                return tuple23;
            }, List$.MODULE$.canBuildFrom()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ mappingList = none$;
        SnowflakeSQLStatement mappingToString = StageWriter$.getMappingToString$1((Option)mappingList, format, conn, table, params);
        SnowflakeSQLStatement mappingFromString = StageWriter$.getMappingFromString$1((Option)mappingList, fromString, format, schema);
        Enumeration.Value value = format;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            snowflakeSQLStatement2 = new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n               |FILE_FORMAT = (\n               |    TYPE=CSV\n               |    FIELD_DELIMITER='|'\n               |    NULL_IF=()\n               |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n               |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF9'\n               |    DATE_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF9'\n               |    BINARY_FORMAT=BASE64\n               |  )\n           ")).stripMargin()).$bang();
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement2 = new ConstantString(new StringOps(Predef$.MODULE$.augmentString("\n               |FILE_FORMAT = (\n               |    TYPE = JSON\n               |)\n           ")).stripMargin()).$bang();
            } else {
                throw new MatchError((Object)value);
            }
        }
        SnowflakeSQLStatement formatString = snowflakeSQLStatement2;
        SnowflakeSQLStatement truncateCol = params.truncateColumns() ? new ConstantString("TRUNCATECOLUMNS = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        SnowflakeSQLStatement purge = params.purge() ? new ConstantString("PURGE = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        SnowflakeSQLStatement snowflakeSQLStatement3 = onError = params.continueOnError() ? new ConstantString("ON_ERROR = CONTINUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
        if (useFilesClause && filesToCopy.nonEmpty()) {
            Set filesWithoutPrefix = (Set)filesToCopy.map((Function1 & Serializable & scala.Serializable)x -> x.substring(x.lastIndexOf("/") + 1), Set$.MODULE$.canBuildFrom());
            snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(27).append("FILES = ( '").append(filesWithoutPrefix.mkString("' , '")).append("' )\n           |").toString())).stripMargin()).$bang();
        } else {
            snowflakeSQLStatement = EmptySnowflakeSQLStatement$.MODULE$.apply();
        }
        SnowflakeSQLStatement filesClause = snowflakeSQLStatement;
        return new ConstantString("copy into").$plus(table.name()).$plus(mappingToString).$plus(mappingFromString).$plus(filesClause).$plus(formatString).$plus(truncateCol).$plus(purge).$plus(onError);
    }

    public static final /* synthetic */ boolean $anonfun$writeToStage$1(char x$2) {
        return x$2 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$writeToStage$2(char x$3) {
        return x$3 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$executeCopyIntoTable$2(char x$4) {
        return x$4 >= ' ';
    }

    private static final String getMissedFileInfo$1(scala.collection.mutable.Set missedFileSet) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("missedFileCount=").append(missedFileSet.size()).append("\n           | Files: (").append(missedFileSet.mkString(", ")).append(")\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StageWriter$.$anonfun$executeCopyIntoTable$2(BoxesRunTime.unboxToChar((Object)x$4))));
    }

    public static final /* synthetic */ boolean $anonfun$executeCopyIntoTable$3(char x$5) {
        return x$5 >= ' ';
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$getCopyMissedFiles$1(scala.collection.mutable.Set columnNameSet$1, ResultSetMetaData metadata$1, int i) {
        return (scala.collection.mutable.Set)columnNameSet$1.$plus$eq((Object)metadata$1.getColumnName(i));
    }

    public static final /* synthetic */ boolean $anonfun$getCopyMissedFiles$2(char x$6) {
        return x$6 >= ' ';
    }

    private static final SnowflakeSQLStatement getMappingToString$1(Option list, Enumeration.Value format$1, Connection conn$1, TableName table$1, Parameters.MergedParameters params$1) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, table$1.name(), params$1);
            snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new ConstantString("(").$plus(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).$plus(")") : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> params$1.keepOriginalColumnNameCase() ? Utils$.MODULE$.quotedNameIgnoreCase((String)x._2()) : Utils$.MODULE$.ensureQuoted((String)x._2()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
            } else {
                throw new MatchError((Object)value);
            }
        }
        return snowflakeSQLStatement;
    }

    private static final SnowflakeSQLStatement getMappingFromString$1(Option list, SnowflakeSQLStatement from, Enumeration.Value format$1, StructType schema$1) {
        SnowflakeSQLStatement snowflakeSQLStatement;
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            SnowflakeSQLStatement snowflakeSQLStatement2;
            if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                String names = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema$1.fields())).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(x.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                snowflakeSQLStatement2 = new ConstantString("from (select").$plus(names).$plus(from).$plus("tmp)");
            } else {
                snowflakeSQLStatement2 = new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "parse_json($1):".concat(schema$1.apply(x._1$mcI$sp() - 1).name()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            }
            snowflakeSQLStatement = snowflakeSQLStatement2;
        } else {
            Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1 & Serializable & scala.Serializable)x -> "tmp.$".concat(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString()), List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            } else {
                throw new MatchError((Object)value);
            }
        }
        return snowflakeSQLStatement;
    }

    private StageWriter$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

