/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.test;

import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TestHook$ {
    public static final TestHook$ MODULE$;
    private final Logger log;
    private final HashSet<Enumeration.Value> ENABLED_TEST_FLAGS;
    private boolean IS_TEST_ENABLED;
    private final String TEST_MESSAGE_PREFIX;

    static {
        new TestHook$();
    }

    public Logger log() {
        return this.log;
    }

    private HashSet<Enumeration.Value> ENABLED_TEST_FLAGS() {
        return this.ENABLED_TEST_FLAGS;
    }

    private boolean IS_TEST_ENABLED() {
        return this.IS_TEST_ENABLED;
    }

    private void IS_TEST_ENABLED_$eq(boolean x$1) {
        this.IS_TEST_ENABLED = x$1;
    }

    private String TEST_MESSAGE_PREFIX() {
        return this.TEST_MESSAGE_PREFIX;
    }

    public void enableTestHook() {
        this.IS_TEST_ENABLED_$eq(true);
    }

    public void disableTestHook() {
        this.IS_TEST_ENABLED_$eq(false);
        this.ENABLED_TEST_FLAGS().clear();
    }

    public void enableTestFlag(Enumeration.Value testFlag) {
        this.enableTestHook();
        if (!this.ENABLED_TEST_FLAGS().contains((Object)testFlag)) {
            this.ENABLED_TEST_FLAGS().add((Object)testFlag);
        }
    }

    public void enableTestFlagOnly(Enumeration.Value testFlag) {
        this.disableTestHook();
        this.enableTestFlag(testFlag);
    }

    public void disableTestFlag(Enumeration.Value testFlag) {
        Object object = this.ENABLED_TEST_FLAGS().contains((Object)testFlag) ? BoxesRunTime.boxToBoolean((boolean)this.ENABLED_TEST_FLAGS().remove((Object)testFlag)) : BoxedUnit.UNIT;
        if (this.ENABLED_TEST_FLAGS().isEmpty()) {
            this.disableTestHook();
        }
    }

    public boolean isTestFlagEnabled(Enumeration.Value testFlag) {
        return this.IS_TEST_ENABLED() && this.ENABLED_TEST_FLAGS().contains((Object)testFlag);
    }

    public void raiseExceptionIfTestFlagEnabled(Enumeration.Value testFlag, String errorMessage) {
        if (this.isTestFlagEnabled(testFlag)) {
            throw new SnowflakeSQLException(ErrorCode.INTERNAL_ERROR, new Object[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.TEST_MESSAGE_PREFIX(), errorMessage}))});
        }
    }

    private TestHook$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.ENABLED_TEST_FLAGS = new HashSet();
        this.IS_TEST_ENABLED = false;
        this.TEST_MESSAGE_PREFIX = "Internal test error (should NOT be seen by user):";
    }
}

