/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.PartETag;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartResult;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.CloudStorageOperations$;
import net.snowflake.spark.snowflake.io.SnowflakeResultSetRDD$;
import net.snowflake.spark.snowflake.io.StorageInfo$;
import net.snowflake.spark.snowflake.test.TestHook$;
import net.snowflake.spark.snowflake.test.TestHookFlag$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\u0001\u0003\u0001\tY!\u0001F*4+Bdw.\u00193PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\t\u0011b\u001d8po\u001ad\u0017m[3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0003\n\u0015\u0005Q\u0011a\u00018fiN\u0011\u0001\u0001\u0004\t\u0003\u001bEi\u0011A\u0004\u0006\u0003\u0007=Q\u0011\u0001E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0013\u001d\taq*\u001e;qkR\u001cFO]3b[\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\u0005tg\rc\u0017.\u001a8u\u0007\u0001\u0001\"a\u0006\u0013\u000e\u0003aQ!!\u0007\u000e\u0002\u0005M\u001c$BA\u000e\u001d\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u000f\u001f\u0003%\tW.\u0019>p]\u0006<8O\u0003\u0002 A\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\"E\u0005!!\u000e\u001a2d\u0015\t\u0019\u0003\"\u0001\u0004dY&,g\u000e^\u0005\u0003Ka\u0011a\"Q7bu>t7kM\"mS\u0016tG\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003\u0011iW\r^1\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-B\u0012!B7pI\u0016d\u0017BA\u0017+\u00059y%M[3di6+G/\u00193bi\u0006D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\fgR|'/Y4f\u0013:4w\u000e\u0005\u00032oiRdB\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t\u0019Q*\u00199\u000b\u0005Y\u001a\u0004CA\u0019<\u0013\ta\u0014H\u0001\u0004TiJLgn\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0011\u0005I\u0002\u0015BA!4\u0005\rIe\u000e\u001e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005u\u0005!a-\u001b7f\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q1q)\u0013&L\u00196\u0003\"\u0001\u0013\u0001\u000e\u0003\tAQ\u0001\u0006#A\u0002YAQa\n#A\u0002!BQa\f#A\u0002ABQA\u0010#A\u0002}BQa\u0011#A\u0002iBqa\u0014\u0001A\u0002\u0013%\u0001+\u0001\fvg\u0016lU\u000f\u001c;ja2,'\t\\8dWV\u0003Hn\\1e+\u0005\t\u0006C\u0001\u001aS\u0013\t\u00196GA\u0004C_>dW-\u00198\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006QRo]3Nk2$\u0018\u000e\u001d7f\u00052|7m[+qY>\fGm\u0018\u0013fcR\u0011qK\u0017\t\u0003eaK!!W\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b7R\u000b\t\u00111\u0001R\u0003\rAH%\r\u0005\u0007;\u0002\u0001\u000b\u0015B)\u0002/U\u001cX-T;mi&\u0004H.\u001a\"m_\u000e\\W\u000b\u001d7pC\u0012\u0004\u0003bB0\u0001\u0001\u0004%I\u0001Y\u0001\u0011I\u0006$\u0018mU5{K&s')\u001e4gKJ,\u0012a\u0010\u0005\bE\u0002\u0001\r\u0011\"\u0003d\u0003Q!\u0017\r^1TSj,\u0017J\u001c\"vM\u001a,'o\u0018\u0013fcR\u0011q\u000b\u001a\u0005\b7\u0006\f\t\u00111\u0001@\u0011\u00191\u0007\u0001)Q\u0005\u007f\u0005\tB-\u0019;b'&TX-\u00138Ck\u001a4WM\u001d\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006)\"-\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006lW#\u00016\u0011\u00055Y\u0017B\u00017\u000f\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6DaA\u001c\u0001!\u0002\u0013Q\u0017A\u00062zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0011\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006iAo\u001c;bY\u0012\u000bG/Y*ju\u0016,\u0012A\u001d\t\u0003eML!\u0001^\u001a\u0003\t1{gn\u001a\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0003E!x\u000e^1m\t\u0006$\u0018mU5{K~#S-\u001d\u000b\u0003/bDqaW;\u0002\u0002\u0003\u0007!\u000f\u0003\u0004{\u0001\u0001\u0006KA]\u0001\u000fi>$\u0018\r\u001c#bi\u0006\u001c\u0016N_3!\u0011\u001da\b\u00011A\u0005\nE\fq\u0002^8uC2,\u0006\u000f\\8bIRKW.\u001a\u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u0003M!x\u000e^1m+Bdw.\u00193US6,w\fJ3r)\r9\u0016\u0011\u0001\u0005\b7v\f\t\u00111\u0001s\u0011\u001d\t)\u0001\u0001Q!\nI\f\u0001\u0003^8uC2,\u0006\u000f\\8bIRKW.\u001a\u0011\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0011!\u00039beR,E+Y4t+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005U\u0011\u0011D\u0007\u0003\u0003#Q1!a\u0005\u0010\u0003\u0011)H/\u001b7\n\t\u0005]\u0011\u0011\u0003\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u00042!KA\u000e\u0013\r\tiB\u000b\u0002\t!\u0006\u0014H/\u0012+bO\"A\u0011\u0011\u0005\u0001!\u0002\u0013\ti!\u0001\u0006qCJ$X\tV1hg\u0002B\u0001\"!\n\u0001\u0001\u0004%I\u0001Y\u0001\u0007a\u0006\u0014H/\u00133\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0012A\u00039beRLEm\u0018\u0013fcR\u0019q+!\f\t\u0011m\u000b9#!AA\u0002}Bq!!\r\u0001A\u0003&q(A\u0004qCJ$\u0018\n\u001a\u0011\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0012A\u00032vG.,GOT1nKV\t!\bC\u0004\u0002<\u0001\u0001\u000b\u0011\u0002\u001e\u0002\u0017\t,8m[3u\u001d\u0006lW\r\t\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003\nqa[3z\u001d\u0006lW-\u0006\u0002\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J=\tA\u0001\\1oO&\u0019A(a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0007\n\u0001b[3z\u001d\u0006lW\r\t\u0005\u000b\u0003'\u0002\u0001R1A\u0005\n\u0005U\u0013aC5oSR\u0014V-];fgR,\"!a\u0016\u0011\u0007%\nI&C\u0002\u0002\\)\u0012a$\u00138ji&\fG/Z'vYRL\u0007/\u0019:u+Bdw.\u00193SKF,Xm\u001d;\t\u0015\u0005}\u0003\u0001#A!B\u0013\t9&\u0001\u0007j]&$(+Z9vKN$\b\u0005\u0003\u0006\u0002d\u0001A)\u0019!C\u0005\u0003K\nA\"\u001b8jiJ+7\u000f]8og\u0016,\"!a\u001a\u0011\u0007%\nI'C\u0002\u0002l)\u0012Q$\u00138ji&\fG/Z'vYRL\u0007/\u0019:u+Bdw.\u00193SKN,H\u000e\u001e\u0005\u000b\u0003_\u0002\u0001\u0012!Q!\n\u0005\u001d\u0014!D5oSR\u0014Vm\u001d9p]N,\u0007\u0005\u0003\u0005\u0002t\u0001!\tAAA;\u0003Y9W\r\u001e#bi\u0006LeNQ;gM\u0016\u0014hi\u001c:UKN$HCAA<!\u0015\u0011\u0014\u0011PA?\u0013\r\tYh\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004e\u0005}\u0014bAAAg\t!!)\u001f;f\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000bq\"\u001e9m_\u0006$G)\u0019;b\u0007\",hn\u001b\u000b\u0004/\u0006%\u0005bBAF\u0003\u0007\u0003\r!U\u0001\fSNd\u0015m\u001d;DQVt7\u000eC\u0004\u0002\u0010\u0002!I!!%\u0002\u001f\u0011|W\u000b\u001d7pC\u0012|e.\u001a)beR$\u0012a\u0016\u0005\b\u0003+\u0003A\u0011IAL\u0003\u00159(/\u001b;f)\r9\u0016\u0011\u0014\u0005\b\u00037\u000b\u0019\n1\u0001@\u0003\u0005\u0011\u0007bBAK\u0001\u0011\u0005\u0013q\u0014\u000b\b/\u0006\u0005\u00161UAT\u0011!\tY*!(A\u0002\u0005]\u0004bBAS\u0003;\u0003\raP\u0001\u0004_\u001a4\u0007bBAU\u0003;\u0003\raP\u0001\u0004Y\u0016t\u0007bBAW\u0001\u0011\u0005\u0013\u0011S\u0001\u0006G2|7/\u001a")
public class S3UploadOutputStream
extends OutputStream {
    private final AmazonS3Client s3Client;
    private final ObjectMetadata meta;
    private final int bufferSize;
    private final String file;
    private boolean useMultipleBlockUpload;
    private int dataSizeInBuffer;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private long totalDataSize;
    private long totalUploadTime;
    private final ArrayList<PartETag> partETags;
    private int partId;
    private final String bucketName;
    private final String keyName;
    private InitiateMultipartUploadRequest initRequest;
    private InitiateMultipartUploadResult initResponse;
    private volatile byte bitmap$0;

    private InitiateMultipartUploadRequest initRequest$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.initRequest = new InitiateMultipartUploadRequest(this.bucketName(), this.keyName(), this.meta);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.initRequest;
        }
    }

    private InitiateMultipartUploadResult initResponse$lzycompute() {
        S3UploadOutputStream s3UploadOutputStream = this;
        synchronized (s3UploadOutputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.initResponse = this.s3Client.initiateMultipartUpload(this.initRequest());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.initResponse;
        }
    }

    private boolean useMultipleBlockUpload() {
        return this.useMultipleBlockUpload;
    }

    private void useMultipleBlockUpload_$eq(boolean x$1) {
        this.useMultipleBlockUpload = x$1;
    }

    private int dataSizeInBuffer() {
        return this.dataSizeInBuffer;
    }

    private void dataSizeInBuffer_$eq(int x$1) {
        this.dataSizeInBuffer = x$1;
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    private long totalDataSize() {
        return this.totalDataSize;
    }

    private void totalDataSize_$eq(long x$1) {
        this.totalDataSize = x$1;
    }

    private long totalUploadTime() {
        return this.totalUploadTime;
    }

    private void totalUploadTime_$eq(long x$1) {
        this.totalUploadTime = x$1;
    }

    private ArrayList<PartETag> partETags() {
        return this.partETags;
    }

    private int partId() {
        return this.partId;
    }

    private void partId_$eq(int x$1) {
        this.partId = x$1;
    }

    private String bucketName() {
        return this.bucketName;
    }

    private String keyName() {
        return this.keyName;
    }

    private InitiateMultipartUploadRequest initRequest() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.initRequest$lzycompute() : this.initRequest;
    }

    private InitiateMultipartUploadResult initResponse() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.initResponse$lzycompute() : this.initResponse;
    }

    public byte[] getDataInBufferForTest() {
        return this.byteArrayOutputStream().toByteArray();
    }

    private void uploadDataChunk(boolean isLastChunk) {
        if (isLastChunk && !this.useMultipleBlockUpload()) {
            long start = System.currentTimeMillis();
            this.meta.setContentLength((long)this.dataSizeInBuffer());
            this.byteArrayOutputStream().close();
            byte[] buffer = this.byteArrayOutputStream().toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
            this.s3Client.putObject(this.bucketName(), this.keyName(), (InputStream)inputStream, this.meta);
            long usedTime = System.currentTimeMillis() - start;
            this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
            CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n           | Finish uploading file ", " without AWS multiple parts API\n           | because the data size is less than the buffer size:\n           | bufferSize=", "\n           | compressedSize=", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), this.file, Utils$.MODULE$.getSizeString(this.bufferSize), Utils$.MODULE$.getSizeString(this.dataSizeInBuffer())})))).stripMargin())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$41) {
                    return x$41 >= ' ';
                }
            }));
        } else {
            this.doUploadOnePart();
            if (isLastChunk) {
                this.byteArrayOutputStream().close();
                long start = System.currentTimeMillis();
                CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucketName(), this.keyName(), this.initResponse().getUploadId(), this.partETags());
                this.s3Client.completeMultipartUpload(compRequest);
                long usedTime = System.currentTimeMillis() - start;
                this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
                CloudStorageOperations$.MODULE$.log().info((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":\n             | Finish uploading file ", " with AWS multiple parts API:\n             | bufferSize=", " chunkCount=", "\n             | compressedSize=", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SnowflakeResultSetRDD$.MODULE$.WORKER_LOG_PREFIX(), this.file, Utils$.MODULE$.getSizeString(this.bufferSize), BoxesRunTime.boxToInteger((int)this.partId()), Utils$.MODULE$.getSizeString(this.totalDataSize())})))).stripMargin())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$42) {
                        return x$42 >= ' ';
                    }
                }));
            }
        }
    }

    private void doUploadOnePart() {
        long start = System.currentTimeMillis();
        this.useMultipleBlockUpload_$eq(true);
        byte[] buffer = this.byteArrayOutputStream().toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, this.dataSizeInBuffer());
        UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.bucketName()).withKey(this.keyName()).withUploadId(this.initResponse().getUploadId()).withPartNumber(this.partId()).withInputStream((InputStream)inputStream).withPartSize((long)this.dataSizeInBuffer());
        UploadPartResult uploadResult = this.s3Client.uploadPart(uploadRequest);
        this.partETags().add(uploadResult.getPartETag());
        this.totalDataSize_$eq(this.totalDataSize() + (long)this.dataSizeInBuffer());
        this.dataSizeInBuffer_$eq(0);
        this.partId_$eq(this.partId() + 1);
        this.byteArrayOutputStream().reset();
        long usedTime = System.currentTimeMillis() - start;
        this.totalUploadTime_$eq(this.totalUploadTime() + usedTime);
        if (this.partId() == 3) {
            TestHook$.MODULE$.raiseExceptionIfTestFlagEnabled(TestHookFlag$.MODULE$.TH_FAIL_UPLOAD_AWS_2ND_BLOCK(), "Negative test to raise error after upload 2nd parts");
        }
    }

    @Override
    public void write(int b) {
        if (this.dataSizeInBuffer() >= this.bufferSize) {
            this.uploadDataChunk(false);
        }
        this.byteArrayOutputStream().write(b);
        this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int inputSize = len - off;
        if (inputSize + this.dataSizeInBuffer() <= this.bufferSize) {
            this.byteArrayOutputStream().write(b, off, inputSize);
            this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + inputSize);
        } else {
            int partSize;
            int firstPartSize = this.bufferSize - this.dataSizeInBuffer();
            if (firstPartSize > 0) {
                this.byteArrayOutputStream().write(b, off, firstPartSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + firstPartSize);
            }
            int leftLen = len - firstPartSize;
            int newOff = off + firstPartSize;
            do {
                this.uploadDataChunk(false);
                partSize = Math.min(this.bufferSize, leftLen);
                this.byteArrayOutputStream().write(b, newOff, partSize);
                this.dataSizeInBuffer_$eq(this.dataSizeInBuffer() + partSize);
                newOff += partSize;
            } while ((leftLen -= partSize) > 0);
        }
    }

    @Override
    public void close() {
        if (this.dataSizeInBuffer() > 0) {
            this.uploadDataChunk(true);
        }
    }

    public S3UploadOutputStream(AmazonS3Client s3Client, ObjectMetadata meta, Map<String, String> storageInfo, int bufferSize, String file) {
        this.s3Client = s3Client;
        this.meta = meta;
        this.bufferSize = bufferSize;
        this.file = file;
        this.useMultipleBlockUpload = false;
        this.dataSizeInBuffer = 0;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.totalDataSize = 0L;
        this.totalUploadTime = 0L;
        this.partETags = new ArrayList();
        this.partId = 1;
        this.bucketName = (String)storageInfo.apply((Object)StorageInfo$.MODULE$.BUCKET_NAME());
        this.keyName = ((String)storageInfo.apply((Object)StorageInfo$.MODULE$.PREFIX())).concat(file);
    }
}

