/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.nio.file.Paths;
import java.security.InvalidKeyException;
import net.snowflake.spark.snowflake.SnowflakeConnectorException;
import net.snowflake.spark.snowflake.pushdowns.SnowflakeStrategy;
import org.apache.spark.sql.ExperimentalMethods;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;

public final class SnowflakeConnectorUtils$ {
    public static final SnowflakeConnectorUtils$ MODULE$;
    private transient Logger log;
    private final String SUPPORT_SPARK_VERSION;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SnowflakeConnectorUtils$();
    }

    private Logger log$lzycompute() {
        SnowflakeConnectorUtils$ snowflakeConnectorUtils$ = this;
        synchronized (snowflakeConnectorUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    public String SUPPORT_SPARK_VERSION() {
        return this.SUPPORT_SPARK_VERSION;
    }

    public boolean checkVersionAndEnablePushdown(SparkSession session) {
        boolean bl;
        if (session.version().startsWith(this.SUPPORT_SPARK_VERSION())) {
            this.enablePushdownSession(session);
            bl = true;
        } else {
            this.log().warn(new StringBuilder().append((Object)"Query pushdown is not supported because you are using ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark ", " with a connector designed to support Spark "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{session.version()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Either use the version of Spark supported by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SUPPORT_SPARK_VERSION()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the connector or install a version of the connector that supports "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your version of Spark."})).s((Seq)Nil$.MODULE$)).toString());
            this.disablePushdownSession(session);
            bl = false;
        }
        return bl;
    }

    public void enablePushdownSession(SparkSession session) {
        if (!session.experimental().extraStrategies().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SparkStrategy s) {
                return s instanceof SnowflakeStrategy;
            }
        })) {
            ExperimentalMethods experimentalMethods = session.experimental();
            experimentalMethods.extraStrategies_$eq((Seq)experimentalMethods.extraStrategies().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SnowflakeStrategy[]{new SnowflakeStrategy()})), Seq$.MODULE$.canBuildFrom()));
        }
    }

    public void disablePushdownSession(SparkSession session) {
        session.experimental().extraStrategies_$eq((Seq)session.experimental().extraStrategies().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SparkStrategy strategy) {
                return strategy instanceof SnowflakeStrategy;
            }
        }));
    }

    public void setPushdownSession(SparkSession session, boolean enabled) {
        if (enabled) {
            this.enablePushdownSession(session);
        } else {
            this.disablePushdownSession(session);
        }
    }

    public void handleS3Exception(Exception ex) throws SnowflakeConnectorException {
        if (ex.getCause() instanceof InvalidKeyException) {
            String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support. This needs to be installed in the Java runtime for all Spark executor nodes.";
            this.log().error("JCE Unlimited Strength policy files missing: {}. {}.", (Object)ex.getMessage(), (Object)ex.getCause().getMessage());
            String bootLib = System.getProperty("sun.boot.library.path");
            if (bootLib != null) {
                msg = new StringBuilder().append((Object)msg).append((Object)new StringBuilder().append((Object)" The target directory on your system is: ").append((Object)((Object)Paths.get(bootLib, "security")).toString()).toString()).toString();
                this.log().error(msg);
            }
            throw new SnowflakeConnectorException(msg);
        }
        throw ex;
    }

    private SnowflakeConnectorUtils$() {
        MODULE$ = this;
        this.SUPPORT_SPARK_VERSION = "2.4";
    }
}

