/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.s3upload;

import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import net.snowflake.spark.snowflake.s3upload.ConvertibleOutputStream;
import net.snowflake.spark.snowflake.s3upload.StreamPart;
import net.snowflake.spark.snowflake.s3upload.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(MultiPartOutputStream.class);
    private ConvertibleOutputStream currentStream;
    private static final int MB = 0x100000;
    public static final int S3_MIN_PART_SIZE = 0x500000;
    private static final int STREAM_EXTRA_ROOM = 0x100000;
    private BlockingQueue<StreamPart> queue;
    private final int partNumberStart;
    private final int partNumberEnd;
    private final int partSize;
    private int currentPartNumber;

    public MultiPartOutputStream(int n, int n2, int n3, BlockingQueue<StreamPart> blockingQueue) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("The lowest allowed part number is 1. The value given was " + n);
        }
        if (n2 > 10001) {
            throw new IndexOutOfBoundsException("The highest allowed part number is 10 000, so partNumberEnd must be at most 10 001. The value given was " + n2);
        }
        if (n2 <= n) {
            throw new IndexOutOfBoundsException(String.format("The part number end (%d) must be greater than the part number start (%d).", n2, n));
        }
        if (n3 < 0x500000) {
            throw new IllegalArgumentException(String.format("The given part size (%d) is less than 5 MB.", n3));
        }
        this.partNumberStart = n;
        this.partNumberEnd = n2;
        this.queue = blockingQueue;
        this.partSize = n3;
        log.debug("Creating {}", (Object)this);
        this.currentPartNumber = n;
        this.currentStream = new ConvertibleOutputStream(this.getStreamAllocatedSize());
    }

    private int getStreamAllocatedSize() {
        return this.partSize + 0x500000 + 0x100000;
    }

    public void checkSize() throws InterruptedException {
        if (this.currentStream.size() > this.partSize + 0x500000) {
            ConvertibleOutputStream convertibleOutputStream = this.currentStream.split(this.currentStream.size() - 0x500000, this.getStreamAllocatedSize());
            this.putCurrentStream();
            this.currentStream = convertibleOutputStream;
        }
    }

    private void putCurrentStream() throws InterruptedException {
        if (this.currentStream.size() == 0) {
            return;
        }
        if (this.currentPartNumber >= this.partNumberEnd) {
            throw new IndexOutOfBoundsException(String.format("This stream was allocated the part numbers from %d (inclusive) to %d (exclusive)and it has gone beyond the end.", this.partNumberStart, this.partNumberEnd));
        }
        StreamPart streamPart = new StreamPart(this.currentStream, this.currentPartNumber++);
        log.debug("Putting {} on queue", (Object)streamPart);
        this.queue.put(streamPart);
    }

    @Override
    public void write(int n) {
        this.currentStream.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.currentStream.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void close() {
        log.info("Called close() on {}", (Object)this);
        if (this.currentStream == null) {
            log.warn("{} is already closed", (Object)this);
            return;
        }
        try {
            this.putCurrentStream();
            log.debug("Placing poison pill on queue for {}", (Object)this);
            this.queue.put(StreamPart.POISON);
        }
        catch (InterruptedException interruptedException) {
            log.error("Interrupted while closing {}", (Object)this);
            Utils.throwRuntimeInterruptedException(interruptedException);
        }
        this.currentStream = null;
    }

    public String toString() {
        return String.format("[MultipartOutputStream for parts %d - %d]", this.partNumberStart, this.partNumberEnd - 1);
    }
}

