/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobContainer;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlockBlob;
import net.snowflake.spark.snowflake.CloudCredentialsUtils$;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.SnowflakeConnectorUtils$;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.SFInternalStage;
import net.snowflake.spark.snowflake.io.SFInternalStage$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import net.snowflake.spark.snowflake.io.SupportedSource$;
import net.snowflake.spark.snowflake.s3upload.MultiPartOutputStream;
import net.snowflake.spark.snowflake.s3upload.StreamTransferManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class StageWriter$ {
    public static final StageWriter$ MODULE$;
    private final Logger net$snowflake$spark$snowflake$io$StageWriter$$log;

    static {
        new StageWriter$();
    }

    public Logger net$snowflake$spark$snowflake$io$StageWriter$$log() {
        return this.net$snowflake$spark$snowflake$io$StageWriter$$log;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToStage(RDD<String> rdd, StructType schema2, SQLContext sqlContext, SaveMode saveMode, Parameters.MergedParameters params, JDBCWrapper jdbcWrapper, Enumeration.Value format) {
        Enumeration.Value value;
        block13: {
            block12: {
                SnowflakeSQLStatement prologueSql;
                Enumeration.Value source2;
                block11: {
                    BoxedUnit boxedUnit;
                    Enumeration.Value value2 = source2 = params.usingExternalStage() ? SupportedSource$.MODULE$.EXTERNAL() : SupportedSource$.MODULE$.INTERNAL();
                    if (params.table().isEmpty()) {
                        throw new IllegalArgumentException("For save operations you must specify a Snowflake table name with the 'dbtable' parameter");
                    }
                    prologueSql = Utils$.MODULE$.genPrologueSql(params);
                    this.net$snowflake$spark$snowflake$io$StageWriter$$log().debug(prologueSql.toString());
                    value = source2;
                    Enumeration.Value value3 = SupportedSource$.MODULE$.EXTERNAL();
                    Enumeration.Value value4 = value;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block11;
                    Utils$.MODULE$.checkFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
                    if (params.checkBucketConfiguration()) {
                        AWSCredentials creds = CloudCredentialsUtils$.MODULE$.getAWSCreds(sqlContext, params);
                        Serializable s3ClientFactory = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final AmazonS3Client apply(AWSCredentials awsCredentials) {
                                return new AmazonS3Client(awsCredentials);
                            }
                        };
                        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), params.rootTempDirStorageType(), (AmazonS3Client)s3ClientFactory.apply((Object)creds));
                    }
                    Connection conn = jdbcWrapper.getConnector(params);
                    try {
                        prologueSql.execute(conn);
                        Tuple2<String, String> filesToCopy = this.unloadData(sqlContext, rdd, params, source2, (Option<SFInternalStage>)None$.MODULE$);
                        String tempStage = this.createTempStage((String)filesToCopy._1(), params, conn, jdbcWrapper);
                        this.net$snowflake$spark$snowflake$io$StageWriter$$writeToTable(sqlContext, conn, rdd, schema2, saveMode, params, jdbcWrapper, (String)filesToCopy._2(), tempStage, format);
                        if (params.purge()) {
                            FileSystem fs = FileSystem.get((URI)URI.create((String)filesToCopy._1()), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
                            fs.delete(new Path((String)filesToCopy._1()), true);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        SnowflakeTelemetry$.MODULE$.send(jdbcWrapper.getTelemetry(conn));
                    }
                    catch (Throwable throwable) {
                        void var15_14;
                        SnowflakeTelemetry$.MODULE$.send(jdbcWrapper.getTelemetry((Connection)var15_14));
                        var15_14.close();
                        throw throwable;
                    }
                    conn.close();
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block12;
                }
                Enumeration.Value value5 = SupportedSource$.MODULE$.INTERNAL();
                Enumeration.Value value6 = value;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block13;
                SFInternalStage stageManager = new SFInternalStage(true, jdbcWrapper, params);
                try {
                    stageManager.executeWithConnection((Function1<Connection, Object>)new Serializable(prologueSql){
                        public static final long serialVersionUID = 0L;
                        private final SnowflakeSQLStatement prologueSql$1;

                        public final ResultSet apply(Connection x$1) {
                            return this.prologueSql$1.execute(x$1);
                        }
                        {
                            this.prologueSql$1 = prologueSql$1;
                        }
                    });
                    String tempStage = stageManager.setupStageArea();
                    String file = (String)this.unloadData(sqlContext, rdd, params, source2, (Option<SFInternalStage>)new Some((Object)stageManager))._2();
                    stageManager.executeWithConnection((Function1<Connection, Object>)new Serializable(rdd, schema2, sqlContext, saveMode, params, jdbcWrapper, format, tempStage, file){
                        public static final long serialVersionUID = 0L;
                        private final RDD rdd$1;
                        private final StructType schema$1;
                        private final SQLContext sqlContext$1;
                        private final SaveMode saveMode$1;
                        private final Parameters.MergedParameters params$1;
                        private final JDBCWrapper jdbcWrapper$1;
                        private final Enumeration.Value format$1;
                        private final String tempStage$1;
                        private final String file$1;

                        public final void apply(Connection x$2) {
                            StageWriter$.MODULE$.net$snowflake$spark$snowflake$io$StageWriter$$writeToTable(this.sqlContext$1, x$2, (RDD<String>)this.rdd$1, this.schema$1, this.saveMode$1, this.params$1, this.jdbcWrapper$1, this.file$1, this.tempStage$1, this.format$1);
                        }
                        {
                            this.rdd$1 = rdd$1;
                            this.schema$1 = schema$1;
                            this.sqlContext$1 = sqlContext$1;
                            this.saveMode$1 = saveMode$1;
                            this.params$1 = params$1;
                            this.jdbcWrapper$1 = jdbcWrapper$1;
                            this.format$1 = format$1;
                            this.tempStage$1 = tempStage$1;
                            this.file$1 = file$1;
                        }
                    });
                    stageManager.closeConnection();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    void var21_21;
                    var21_21.closeConnection();
                    throw throwable;
                }
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    public void net$snowflake$spark$snowflake$io$StageWriter$$writeToTable(SQLContext sqlContext, Connection conn, RDD<String> data, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, JDBCWrapper jdbcWrapper, String file, String tempStage, Enumeration.Value format) {
        TableName table2 = (TableName)params.table().get();
        TableName tempTable = new TableName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_staging_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2.name(), ((Object)BoxesRunTime.boxToInteger((int)Math.abs(Random$.MODULE$.nextInt()))).toString()})));
        SaveMode saveMode2 = saveMode;
        SaveMode saveMode3 = SaveMode.Overwrite;
        TableName targetTable = !(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null) && params.useStagingTable() ? tempTable : table2;
        try {
            Object object;
            SaveMode saveMode4 = saveMode;
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null) && jdbcWrapper.tableExists(conn, table2.toString())) {
                if (params.useStagingTable()) {
                    if (params.truncateTable()) {
                        DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).createTableLike(tempTable.name(), table2.name());
                    }
                    object = BoxedUnit.UNIT;
                } else if (params.truncateTable()) {
                    DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).truncateTable(table2.name());
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToBoolean((boolean)DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).dropTable(table2.name()));
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
            String x$11 = targetTable.name();
            StructType x$12 = schema2;
            boolean x$13 = qual$1.createTable$default$3();
            boolean x$14 = qual$1.createTable$default$4();
            qual$1.createTable(x$11, x$12, x$13, x$14);
            Utils$.MODULE$.executePreActions(jdbcWrapper, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SnowflakeSQLStatement copyStatement = this.copySql(sqlContext, data, schema2, saveMode, params, targetTable, file, tempStage, format, conn);
            this.net$snowflake$spark$snowflake$io$StageWriter$$log().debug(Utils$.MODULE$.sanitizeQueryText(copyStatement.toString()));
            ResultSet resultSet = copyStatement.execute(conn);
            if (params.continueOnError()) {
                long rowSkipped = 0L;
                while (resultSet.next()) {
                    rowSkipped += resultSet.getLong("rows_parsed") - resultSet.getLong("rows_loaded");
                }
                this.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ON_ERROR: Continue -> Skipped ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowSkipped)})));
            }
            Utils$.MODULE$.setLastCopyLoad(copyStatement.toString());
            Utils$.MODULE$.executePostActions(jdbcWrapper, conn, params, (Option<TableName>)Option$.MODULE$.apply((Object)targetTable));
            SaveMode saveMode6 = saveMode;
            SaveMode saveMode7 = SaveMode.Overwrite;
            if (!(saveMode6 != null ? !saveMode6.equals(saveMode7) : saveMode7 != null) && params.useStagingTable()) {
                if (jdbcWrapper.tableExists(conn, table2.toString())) {
                    DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).swapTable(table2.name(), tempTable.name());
                } else {
                    DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).renameTable(table2.name(), tempTable.name());
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            TableName tableName = targetTable;
            TableName tableName2 = tempTable;
            Object object = !(tableName != null ? !((Object)tableName).equals(tableName2) : tableName2 != null) ? BoxesRunTime.boxToBoolean((boolean)DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).dropTable(tempTable.name())) : BoxedUnit.UNIT;
            this.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringBuilder().append((Object)"Error occurred while loading files to Snowflake: ").append((Object)sQLException).toString());
            throw sQLException;
        }
    }

    private SnowflakeSQLStatement copySql(SQLContext sqlContext, RDD<String> data, StructType schema2, SaveMode saveMode, Parameters.MergedParameters params, TableName table2, String file, String tempStage, Enumeration.Value format, Connection conn) {
        Option<Map<String, String>> option;
        block6: {
            Enumeration.Value value;
            block9: {
                SnowflakeSQLStatement snowflakeSQLStatement;
                SnowflakeSQLStatement mappingFromString;
                SnowflakeSQLStatement mappingToString;
                block8: {
                    block7: {
                        None$ none$;
                        SnowflakeSQLStatement fromString;
                        block5: {
                            block4: {
                                SaveMode saveMode2 = saveMode;
                                SaveMode saveMode3 = SaveMode.Append;
                                if ((saveMode2 == null ? saveMode3 != null : !saveMode2.equals(saveMode3)) && params.columnMap().isDefined()) {
                                    throw new UnsupportedOperationException("The column mapping only works in append mode.");
                                }
                                fromString = new ConstantString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM @", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempStage, file}))).$bang();
                                option = params.columnMap();
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                Map map = (Map)some.x();
                                none$ = new Some(map.toList().map((Function1)new Serializable(schema2){
                                    public static final long serialVersionUID = 0L;
                                    private final StructType schema$2;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Tuple2<Object, String> apply(Tuple2<String, String> x0$1) {
                                        Tuple2<String, String> tuple2 = x0$1;
                                        if (tuple2 == null) throw new MatchError(tuple2);
                                        String key = (String)tuple2._1();
                                        String value = (String)tuple2._2();
                                        try {
                                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.schema$2.fieldIndex(key) + 1)), (Object)value);
                                        }
                                        catch (Exception exception) {
                                            StageWriter$.MODULE$.net$snowflake$spark$snowflake$io$StageWriter$$log().error(new StringBuilder().append((Object)"Error occurred while column mapping: ").append((Object)exception).toString());
                                            throw exception;
                                        }
                                    }
                                    {
                                        this.schema$2 = schema$2;
                                    }
                                }, List$.MODULE$.canBuildFrom()));
                                break block5;
                            }
                            if (!None$.MODULE$.equals(option)) break block6;
                            none$ = None$.MODULE$;
                        }
                        None$ mappingList = none$;
                        mappingToString = this.getMappingToString$1((Option)mappingList, table2, format, conn);
                        mappingFromString = this.getMappingFromString$1((Option)mappingList, fromString, schema2, format);
                        value = format;
                        Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block7;
                        snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE=CSV\n               |    FIELD_DELIMITER='|'\n               |    NULL_IF=()\n               |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n               |    TIMESTAMP_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |    DATE_FORMAT='TZHTZM YYYY-MM-DD HH24:MI:SS.FF3'\n               |  )\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                        break block8;
                    }
                    Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block9;
                    snowflakeSQLStatement = new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |FILE_FORMAT = (\n               |    TYPE = JSON\n               |)\n           "})).s((Seq)Nil$.MODULE$))).stripMargin()).$bang();
                }
                SnowflakeSQLStatement formatString = snowflakeSQLStatement;
                SnowflakeSQLStatement truncateCol = params.truncateColumns() ? new ConstantString("TRUNCATECOLUMNS = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement purge2 = params.purge() ? new ConstantString("PURGE = TRUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                SnowflakeSQLStatement onError = params.continueOnError() ? new ConstantString("ON_ERROR = CONTINUE").$bang() : EmptySnowflakeSQLStatement$.MODULE$.apply();
                return new ConstantString("copy into").$plus(table2.name()).$plus(mappingToString).$plus(mappingFromString).$plus(formatString).$plus(truncateCol).$plus(purge2).$plus(onError);
            }
            throw new MatchError((Object)value);
        }
        throw new MatchError(option);
    }

    private Tuple2<String, String> unloadData(SQLContext sqlContext, RDD<String> data, Parameters.MergedParameters params, Enumeration.Value source2, Option<SFInternalStage> stageMngr) {
        Enumeration.Value value;
        block12: {
            Tuple2 tuple2;
            block11: {
                block5: {
                    Tuple3 tuple3;
                    block6: {
                        Tuple2<String, String> tuple22;
                        block7: {
                            SFInternalStage stageManager;
                            block10: {
                                Tuple2 tuple23;
                                block9: {
                                    StageInfo.StageType stageType;
                                    String path;
                                    String bucketName;
                                    String stageLocation;
                                    String masterKey;
                                    String smkId;
                                    String queryId;
                                    block8: {
                                        Tuple2 tuple24;
                                        Tuple2 tuple25;
                                        stageManager = (SFInternalStage)stageMngr.orNull(Predef$.MODULE$.$conforms());
                                        value = source2;
                                        Enumeration.Value value2 = SupportedSource$.MODULE$.INTERNAL();
                                        Enumeration.Value value3 = value;
                                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block5;
                                        Seq<Tuple3<String, String, String>> keyIds = stageManager.getKeyIds();
                                        Tuple3 tuple32 = tuple3 = keyIds.nonEmpty() ? (Tuple3)keyIds.head() : new Tuple3((Object)"", (Object)"", (Object)"");
                                        if (tuple3 == null) break block6;
                                        String queryId2 = (String)tuple3._2();
                                        String smkId2 = (String)tuple3._3();
                                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)queryId2, (Object)smkId2);
                                        queryId = (String)tuple26._1();
                                        smkId = (String)tuple26._2();
                                        masterKey = stageManager.masterKey();
                                        stageLocation = stageManager.stageLocation();
                                        tuple22 = SFInternalStage$.MODULE$.extractBucketNameAndPath(stageLocation);
                                        if (tuple22 == null) break block7;
                                        String bucketName2 = (String)tuple22._1();
                                        String path2 = (String)tuple22._2();
                                        Tuple2 tuple27 = tuple24 = new Tuple2((Object)bucketName2, (Object)path2);
                                        bucketName = (String)tuple27._1();
                                        path = (String)tuple27._2();
                                        boolean is256 = stageManager.is256Encryption();
                                        stageType = stageManager.stageType();
                                        if (!StageInfo.StageType.S3.equals(stageType)) break block8;
                                        Option<String> awsID = stageManager.awsId();
                                        Option<String> awsKey = stageManager.awsKey();
                                        Option<String> awsToken = stageManager.awsToken();
                                        data.foreachPartition((Function1)new Serializable(params, queryId, smkId, masterKey, bucketName, path, is256, awsID, awsKey, awsToken){
                                            public static final long serialVersionUID = 0L;
                                            private final Parameters.MergedParameters params$2;
                                            private final String queryId$1;
                                            private final String smkId$1;
                                            private final String masterKey$1;
                                            private final String bucketName$1;
                                            private final String path$1;
                                            private final boolean is256$1;
                                            private final Option awsID$1;
                                            private final Option awsKey$1;
                                            private final Option awsToken$1;

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final void apply(Iterator<String> rows) {
                                                Tuple2 tuple2;
                                                Serializable serializable;
                                                String randStr = Random$.MODULE$.alphanumeric().take(10).mkString("");
                                                String fileName = new StringBuilder().append((Object)this.path$1).append((Object)(this.path$1.endsWith("/") ? "" : "/")).append((Object)randStr).append((Object)".csv").toString();
                                                AmazonS3Client amazonClient = SFInternalStage$.MODULE$.createS3Client(this.is256$1, this.masterKey$1, this.queryId$1, this.smkId$1, (String)this.awsID$1.get(), (String)this.awsKey$1.get(), (String)this.awsToken$1.get(), SFInternalStage$.MODULE$.createS3Client$default$8());
                                                Serializable serializable2 = serializable = this.is256$1 ? new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Tuple2<Cipher, ObjectMetadata> apply(Cipher x$6) {
                                                        return new Tuple2((Object)x$6, (Object)new ObjectMetadata());
                                                    }
                                                } : SFInternalStage$.MODULE$.getCipherAndS3Metadata(this.masterKey$1, this.queryId$1, this.smkId$1);
                                                if (!(serializable instanceof Tuple2)) throw new MatchError(serializable);
                                                Serializable serializable3 = serializable;
                                                Object fileCipher = serializable3._1();
                                                Object meta = serializable3._2();
                                                if (!(fileCipher instanceof Cipher)) throw new MatchError(serializable);
                                                Cipher cipher = (Cipher)fileCipher;
                                                if (!(meta instanceof ObjectMetadata)) throw new MatchError(serializable);
                                                ObjectMetadata objectMetadata = (ObjectMetadata)meta;
                                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)cipher, (Object)objectMetadata);
                                                Cipher fileCipher2 = (Cipher)tuple22._1();
                                                ObjectMetadata meta2 = (ObjectMetadata)tuple22._2();
                                                if (this.params$2.sfCompress()) {
                                                    meta2.setContentEncoding("GZIP");
                                                }
                                                int parallelism2 = BoxesRunTime.unboxToInt((Object)this.params$2.parallelism().getOrElse((Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final int apply() {
                                                        return this.apply$mcI$sp();
                                                    }

                                                    public int apply$mcI$sp() {
                                                        return 1;
                                                    }
                                                }));
                                                StreamTransferManager streamManager = new StreamTransferManager(this.bucketName$1, fileName, (AmazonS3)amazonClient, meta2, 1, parallelism2, 5 * parallelism2, 50);
                                                try {
                                                    MultiPartOutputStream uploadOutStream = streamManager.getMultiPartOutputStreams().get(0);
                                                    OutputStream outStream = uploadOutStream;
                                                    if (!this.is256$1) {
                                                        outStream = new CipherOutputStream(outStream, fileCipher2);
                                                    }
                                                    if (this.params$2.sfCompress()) {
                                                        fileName = new StringBuilder().append((Object)fileName).append((Object)".gz").toString();
                                                        outStream = new GZIPOutputStream(outStream);
                                                    }
                                                    SnowflakeConnectorUtils$.MODULE$.log().debug("Begin upload.");
                                                    while (rows.hasNext()) {
                                                        outStream.write(((String)rows.next()).getBytes("UTF-8"));
                                                        outStream.write(10);
                                                        uploadOutStream.checkSize();
                                                    }
                                                    outStream.close();
                                                    SnowflakeConnectorUtils$.MODULE$.log().debug("Completed S3 upload for partition.");
                                                    streamManager.complete();
                                                    return;
                                                }
                                                catch (Exception exception) {
                                                    streamManager.abort();
                                                    SnowflakeConnectorUtils$.MODULE$.handleS3Exception(exception);
                                                }
                                            }
                                            {
                                                this.params$2 = params$2;
                                                this.queryId$1 = queryId$1;
                                                this.smkId$1 = smkId$1;
                                                this.masterKey$1 = masterKey$1;
                                                this.bucketName$1 = bucketName$1;
                                                this.path$1 = path$1;
                                                this.is256$1 = is256$1;
                                                this.awsID$1 = awsID$1;
                                                this.awsKey$1 = awsKey$1;
                                                this.awsToken$1 = awsToken$1;
                                            }
                                        });
                                        tuple23 = new Tuple2((Object)new StringBuilder().append((Object)"s3n://").append((Object)stageLocation).toString(), (Object)"");
                                        break block9;
                                    }
                                    if (!StageInfo.StageType.AZURE.equals(stageType)) break block10;
                                    Option<String> azureSAS = stageManager.azureSAS();
                                    Option<String> azureAccount = stageManager.azureAccountName();
                                    Option<String> azureEndpoint = stageManager.azureEndpoint();
                                    data.foreachPartition((Function1)new Serializable(params, queryId, smkId, masterKey, bucketName, path, azureSAS, azureAccount, azureEndpoint){
                                        public static final long serialVersionUID = 0L;
                                        private final Parameters.MergedParameters params$2;
                                        private final String queryId$1;
                                        private final String smkId$1;
                                        private final String masterKey$1;
                                        private final String bucketName$1;
                                        private final String path$1;
                                        private final Option azureSAS$1;
                                        private final Option azureAccount$1;
                                        private final Option azureEndpoint$1;

                                        public final void apply(Iterator<String> rows) {
                                            String randStr = Random$.MODULE$.alphanumeric().take(10).mkString("");
                                            String fileName = new StringBuilder().append((Object)this.path$1).append((Object)(this.path$1.endsWith("/") ? "" : "/")).append((Object)randStr).append((Object)".csv").toString();
                                            CloudBlobClient azureClient = SFInternalStage$.MODULE$.createAzureClient((String)this.azureAccount$1.get(), (String)this.azureEndpoint$1.get(), (Option<String>)this.azureSAS$1);
                                            Tuple2<Cipher, HashMap<String, String>> tuple2 = SFInternalStage$.MODULE$.getCipherAndAZMetaData(this.masterKey$1, this.queryId$1, this.smkId$1);
                                            if (tuple2 != null) {
                                                FilterOutputStream outputStream;
                                                Tuple2 tuple22;
                                                Cipher cipher = (Cipher)tuple2._1();
                                                HashMap meta = (HashMap)tuple2._2();
                                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)cipher, (Object)meta);
                                                Cipher cipher2 = (Cipher)tuple23._1();
                                                HashMap meta2 = (HashMap)tuple23._2();
                                                String outputFileName = this.params$2.sfCompress() ? fileName.concat(".gz") : fileName;
                                                CloudBlobContainer container = azureClient.getContainerReference(this.bucketName$1);
                                                CloudBlockBlob blob = container.getBlockBlobReference(outputFileName);
                                                blob.setMetadata(meta2);
                                                CipherOutputStream EncryptedStream = new CipherOutputStream((OutputStream)blob.openOutputStream(), cipher2);
                                                FilterOutputStream filterOutputStream = outputStream = this.params$2.sfCompress() ? new GZIPOutputStream(EncryptedStream) : EncryptedStream;
                                                while (rows.hasNext()) {
                                                    ((OutputStream)outputStream).write(((String)rows.next()).getBytes("UTF-8"));
                                                    ((OutputStream)outputStream).write(10);
                                                }
                                                ((OutputStream)outputStream).close();
                                                return;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.params$2 = params$2;
                                            this.queryId$1 = queryId$1;
                                            this.smkId$1 = smkId$1;
                                            this.masterKey$1 = masterKey$1;
                                            this.bucketName$1 = bucketName$1;
                                            this.path$1 = path$1;
                                            this.azureSAS$1 = azureSAS$1;
                                            this.azureAccount$1 = azureAccount$1;
                                            this.azureEndpoint$1 = azureEndpoint$1;
                                        }
                                    });
                                    tuple23 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wasb://", ".", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{azureAccount, azureEndpoint, stageLocation})), (Object)"");
                                }
                                tuple2 = tuple23;
                                break block11;
                            }
                            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support S3 or Azure stage, stage type: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stageManager.stageType()})));
                        }
                        throw new MatchError(tuple22);
                    }
                    throw new MatchError((Object)tuple3);
                }
                Enumeration.Value value4 = SupportedSource$.MODULE$.EXTERNAL();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block12;
                String tempDir = params.createPerQueryTempDir();
                if (params.sfCompress()) {
                    data.saveAsTextFile(tempDir, GzipCodec.class);
                } else {
                    data.saveAsTextFile(tempDir);
                }
                FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
                Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir))).iterator().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(FileStatus x$9) {
                        return x$9.getPath().getName();
                    }
                }).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$10) {
                        return x$10.startsWith("part");
                    }
                }).take(1).toSeq().headOption().getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new Exception("No part files were written!");
                    }
                });
                tuple2 = new Tuple2((Object)tempDir, (Object)"part");
            }
            return tuple2;
        }
        throw new MatchError((Object)value);
    }

    public String createTempStage(String path, Parameters.MergedParameters params, Connection conn, JDBCWrapper jdbcWrapper) {
        String stageName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tmp_spark_stage_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Random$.MODULE$.alphanumeric().take(10).mkString("")}));
        String urlString = this.convertURL$1(path);
        DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).createStage(stageName, (Option<String>)new Some((Object)urlString), params.awsAccessKey(), params.awsSecretKey(), params.azureSAS(), true, true);
        return stageName;
    }

    private final SnowflakeSQLStatement getMappingToString$1(Option list, TableName table$1, Enumeration.Value format$2, Connection conn$1) {
        Enumeration.Value value;
        block4: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block3: {
                block2: {
                    value = format$2;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    StructType tableSchema = DefaultJDBCWrapper$.MODULE$.resolveTable(conn$1, table$1.name());
                    snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? new ConstantString("(").$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StructField x$3) {
                            return x$3.name();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",")).$plus(")") : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, String> x) {
                            return Utils$.MODULE$.ensureQuoted((String)x._2());
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
                    break block3;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? EmptySnowflakeSQLStatement$.MODULE$.apply() : new ConstantString("(").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x) {
                        return Utils$.MODULE$.ensureQuoted((String)x._2());
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(")");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private final SnowflakeSQLStatement getMappingFromString$1(Option list, SnowflakeSQLStatement from, StructType schema$2, Enumeration.Value format$2) {
        Enumeration.Value value;
        block7: {
            SnowflakeSQLStatement snowflakeSQLStatement;
            block6: {
                block5: {
                    SnowflakeSQLStatement snowflakeSQLStatement2;
                    value = format$2;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.JSON();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block5;
                    if (list.isEmpty() || ((SeqLike)list.get()).isEmpty()) {
                        String names = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema$2.fields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(StructField x) {
                                return "parse_json($1):".concat(x.name());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(names).$plus(from).$plus("tmp)");
                    } else {
                        snowflakeSQLStatement2 = new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(schema$2){
                            public static final long serialVersionUID = 0L;
                            private final StructType schema$2;

                            public final String apply(Tuple2<Object, String> x) {
                                return "parse_json($1):".concat(this.schema$2.apply(x._1$mcI$sp() - 1).name());
                            }
                            {
                                this.schema$2 = schema$2;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
                    }
                    snowflakeSQLStatement = snowflakeSQLStatement2;
                    break block6;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.CSV();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                snowflakeSQLStatement = list.isEmpty() || ((SeqLike)list.get()).isEmpty() ? from : new ConstantString("from (select").$plus(((TraversableOnce)((List)list.get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, String> x) {
                        return "tmp.$".concat(((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())).toString());
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(", ")).$plus(from).$plus("tmp)");
            }
            return snowflakeSQLStatement;
        }
        throw new MatchError((Object)value);
    }

    private final String convertURL$1(String url) {
        block4: {
            String string;
            block3: {
                String string2;
                Regex s3_url;
                block2: {
                    Regex azure_url = new StringOps(Predef$.MODULE$.augmentString("wasbs?://([^@]+)@([^\\.]+)\\.([^/]+)/(.+)?")).r();
                    s3_url = new StringOps(Predef$.MODULE$.augmentString("s3[an]://(.+)")).r();
                    string2 = url;
                    Option option = azure_url.unapplySeq((CharSequence)string2);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block2;
                    String container = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String account = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String endpoint = (String)((LinearSeqOptimized)option.get()).apply(2);
                    String path = (String)((LinearSeqOptimized)option.get()).apply(3);
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"azure://", ".", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{account, endpoint, container, path}));
                    break block3;
                }
                Option option = s3_url.unapplySeq((CharSequence)string2);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                String path = (String)((LinearSeqOptimized)option.get()).apply(0);
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
    }

    private StageWriter$() {
        MODULE$ = this;
        this.net$snowflake$spark$snowflake$io$StageWriter$$log = LoggerFactory.getLogger(this.getClass());
    }
}

