/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.InputStream;
import java.net.URI;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3EncryptionClient;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoMode;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterials;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsAnonymous;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class SFInternalStage$ {
    public static final SFInternalStage$ MODULE$;
    private final String DUMMY_LOCATION;
    private final String AES;
    private final int DEFAULT_PARALLELISM;
    private final int S3_MAX_RETRIES;
    private final String CREATE_TEMP_STAGE_STMT;
    private final String AMZ_KEY;
    private final String AMZ_IV;
    private final String DATA_CIPHER;
    private final String KEY_CIPHER;
    private final String AMZ_MATDESC;
    private final String AZ_ENCRYPTIONDATA;
    private final String AZ_IV;
    private final String AZ_KEY_WRAP;
    private final String AZ_KEY;
    private final String AZ_MATDESC;

    static {
        new SFInternalStage$();
    }

    public final String DUMMY_LOCATION() {
        return "file:///tmp/dummy_location_spark_connector_tmp/";
    }

    public final String AES() {
        return "AES";
    }

    public final int DEFAULT_PARALLELISM() {
        return 10;
    }

    public final int S3_MAX_RETRIES() {
        return 3;
    }

    public final String CREATE_TEMP_STAGE_STMT() {
        return this.CREATE_TEMP_STAGE_STMT;
    }

    public final String AMZ_KEY() {
        return this.AMZ_KEY;
    }

    public final String AMZ_IV() {
        return this.AMZ_IV;
    }

    public final String DATA_CIPHER() {
        return this.DATA_CIPHER;
    }

    public final String KEY_CIPHER() {
        return this.KEY_CIPHER;
    }

    public final String AMZ_MATDESC() {
        return "x-amz-matdesc";
    }

    public final String AZ_ENCRYPTIONDATA() {
        return "encryptiondata";
    }

    public final String AZ_IV() {
        return "ContentEncryptionIV";
    }

    public final String AZ_KEY_WRAP() {
        return "WrappedContentKey";
    }

    public final String AZ_KEY() {
        return "EncryptedKey";
    }

    public final String AZ_MATDESC() {
        return "matdesc";
    }

    public final Tuple2<String, String> extractBucketNameAndPath(String stageLocation) {
        return stageLocation.contains("/") ? new Tuple2((Object)stageLocation.substring(0, stageLocation.indexOf("/")), (Object)stageLocation.substring(stageLocation.indexOf("/") + 1)) : new Tuple2((Object)stageLocation, (Object)"");
    }

    public final String TEMP_STAGE_LOCATION() {
        return new StringBuilder().append((Object)"spark_connector_unload_stage_").append((Object)Random$.MODULE$.alphanumeric().take(10).mkString("")).toString();
    }

    public final CloudBlobClient createAzureClient(String storageAccount, String endpoint, Option<String> sas) {
        URI storageEndpoint = new URI("https", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storageAccount, endpoint})), null, null);
        StorageCredentials azCreds = sas.isDefined() ? new StorageCredentialsSharedAccessSignature((String)sas.get()) : StorageCredentialsAnonymous.ANONYMOUS;
        return new CloudBlobClient(storageEndpoint, azCreds);
    }

    public final Option<String> createAzureClient$default$3() {
        return None$.MODULE$;
    }

    public final AmazonS3Client createS3Client(boolean is256, String masterKey, String queryId, String smkId, String awsId, String awsKey, String awsToken, Option<Object> parallel) {
        AmazonS3Client amazonS3Client;
        int parallelism2 = BoxesRunTime.unboxToInt((Object)parallel.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 10;
            }
        }));
        byte[] decodedKey = Base64.decode((String)masterKey);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        BasicAWSCredentials awsCredentials = awsToken == null ? new BasicAWSCredentials(awsId, awsKey) : new BasicSessionCredentials(awsId, awsKey, awsToken);
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallelism2);
        clientConfig.setMaxErrorRetry(3);
        if (is256) {
            CryptoConfiguration cryptoConfig = new CryptoConfiguration(CryptoMode.EncryptionOnly);
            EncryptionMaterials encryptionMaterials = new EncryptionMaterials((SecretKey)queryStageMasterKey);
            encryptionMaterials.addDescription("queryId", queryId);
            encryptionMaterials.addDescription("smkId", smkId);
            amazonS3Client = new AmazonS3EncryptionClient((AWSCredentials)awsCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
        } else {
            amazonS3Client = new AmazonS3Client((AWSCredentials)awsCredentials, clientConfig);
        }
        return amazonS3Client;
    }

    public final Option<Object> createS3Client$default$8() {
        return None$.MODULE$;
    }

    public final Tuple2<String, String> parseEncryptionData(String jsonEncryptionData) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode encryptionDataNode = mapper.readTree(jsonEncryptionData);
        String iv = encryptionDataNode.findValue("ContentEncryptionIV").asText();
        String key = encryptionDataNode.findValue("WrappedContentKey").findValue("EncryptedKey").asText();
        return new Tuple2((Object)key, (Object)iv);
    }

    public final InputStream getDecryptedStream(InputStream stream, String masterKey, Map<String, String> metaData, StageInfo.StageType stageType) {
        block7: {
            Tuple2 tuple2;
            byte[] decodedKey;
            block6: {
                StageInfo.StageType stageType2;
                block5: {
                    decodedKey = Base64.decode((String)masterKey);
                    stageType2 = stageType;
                    if (!StageInfo.StageType.S3.equals(stageType2)) break block5;
                    tuple2 = new Tuple2((Object)metaData.get(this.AMZ_KEY()), (Object)metaData.get(this.AMZ_IV()));
                    break block6;
                }
                if (!StageInfo.StageType.AZURE.equals(stageType2)) break block7;
                tuple2 = this.parseEncryptionData(metaData.get("encryptiondata"));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                String key = (String)tuple22._1();
                String iv = (String)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)key, (Object)iv);
                String key2 = (String)tuple24._1();
                String iv2 = (String)tuple24._2();
                if (key2 == null || iv2 == null) {
                    throw new SnowflakeSQLException("XX000", Predef$.MODULE$.Integer2int(ErrorCode.INTERNAL_ERROR.getMessageCode()), new Object[]{"File metadata incomplete"});
                }
                byte[] keyBytes = Base64.decode((String)key2);
                byte[] ivBytes = Base64.decode((String)iv2);
                SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
                Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
                keyCipher.init(2, queryStageMasterKey);
                byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
                SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, decodedKey.length, "AES");
                Cipher dataCipher = Cipher.getInstance(this.DATA_CIPHER());
                IvParameterSpec ivy = new IvParameterSpec(ivBytes);
                dataCipher.init(2, (Key)fileKey, ivy);
                return new CipherInputStream(stream, dataCipher);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support s3 or azure stage. Stage Type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stageType})));
    }

    public final Tuple2<Cipher, HashMap<String, String>> getCipherAndAZMetaData(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 != null) {
            Tuple4 tuple42;
            Cipher cipher = (Cipher)tuple4._1();
            String matDesc = (String)tuple4._2();
            String enKeK = (String)tuple4._3();
            String ivData = (String)tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)enKeK, (Object)ivData);
            Cipher cipher2 = (Cipher)tuple43._1();
            String matDesc2 = (String)tuple43._2();
            String enKeK2 = (String)tuple43._3();
            String ivData2 = (String)tuple43._4();
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("matdesc", matDesc2);
            meta.put("encryptiondata", this.buildEncryptionMetadataJSON$1(ivData2, enKeK2));
            return new Tuple2((Object)cipher2, meta);
        }
        throw new MatchError(tuple4);
    }

    public final Tuple2<Cipher, ObjectMetadata> getCipherAndS3Metadata(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 != null) {
            Tuple4 tuple42;
            Cipher cipher = (Cipher)tuple4._1();
            String matDesc = (String)tuple4._2();
            String encKeK = (String)tuple4._3();
            String ivData = (String)tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)encKeK, (Object)ivData);
            Cipher cipher2 = (Cipher)tuple43._1();
            String matDesc2 = (String)tuple43._2();
            String encKeK2 = (String)tuple43._3();
            String ivData2 = (String)tuple43._4();
            ObjectMetadata meta = new ObjectMetadata();
            meta.addUserMetadata("x-amz-matdesc", matDesc2);
            meta.addUserMetadata(this.AMZ_KEY(), encKeK2);
            meta.addUserMetadata(this.AMZ_IV(), ivData2);
            return new Tuple2((Object)cipher2, (Object)meta);
        }
        throw new MatchError(tuple4);
    }

    private final Tuple4<Cipher, String, String, String> getCipherAndMetadata(String masterKey, String queryId, String smkId) {
        byte[] decodedKey = Base64.decode((String)masterKey);
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(this.DATA_CIPHER());
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SecureRandom secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
        secRnd.nextBytes(new byte[10]);
        secRnd.nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        secRnd.nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, "AES");
        fileCipher.init(1, (Key)fileKey, iv);
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, "AES");
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(new StringOps(Predef$.MODULE$.augmentString(smkId)).toLong(), queryId, keySize * 8);
        return new Tuple4((Object)fileCipher, (Object)matDesc.toString(), (Object)Base64.encodeAsString((byte[])encKeK), (Object)Base64.encodeAsString((byte[])ivData));
    }

    private final String buildEncryptionMetadataJSON$1(String iv64, String key64) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | {\"EncryptionMode\":\"FullBlob\",\n         | \"WrappedContentKey\":\n         | {\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"", "\",\"Algorithm\":\"AES_CBC_256\"},\n         | \"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\n         | \"ContentEncryptionIV\":\"", "\",\n         | \"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key64, iv64})))).stripMargin();
    }

    private SFInternalStage$() {
        MODULE$ = this;
        this.CREATE_TEMP_STAGE_STMT = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE OR REPLACE TEMP STAGE "})).s((Seq)Nil$.MODULE$);
        this.AMZ_KEY = "x-amz-key";
        this.AMZ_IV = "x-amz-iv";
        this.DATA_CIPHER = "AES/CBC/PKCS5Padding";
        this.KEY_CIPHER = "AES/ECB/PKCS5Padding";
    }
}

