/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.EmptySnowflakeSQLStatement$;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.Utils$;
import net.snowflake.spark.snowflake.io.DataUnloader;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;

public abstract class DataUnloader$class {
    public static long setup(DataUnloader $this, Seq preStatements, SnowflakeSQLStatement statement, Connection conn, boolean keepOpen) {
        try {
            SnowflakeSQLStatement prologueSql = Utils$.MODULE$.genPrologueSql($this.params());
            $this.log().debug(Utils$.MODULE$.sanitizeQueryText(prologueSql.toString()));
            prologueSql.execute(conn);
            Utils$.MODULE$.executePreActions($this.jdbcWrapper(), conn, $this.params(), $this.params().table());
            $this.log().debug(Utils$.MODULE$.sanitizeQueryText(statement.statementString()));
            preStatements.foreach((Function1)new Serializable($this, conn){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataUnloader $outer;
                private final Connection conn$1;

                public final boolean apply(String stmt) {
                    return this.$outer.jdbcWrapper().executeInterruptibly(this.conn$1, stmt);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.conn$1 = conn$1;
                }
            });
            ResultSet res = statement.execute(conn);
            ResultSetMetaData sch = res.getMetaData();
            Predef$.MODULE$.assert(sch.getColumnCount() == 3);
            String string = sch.getColumnName(1);
            String string2 = "rows_unloaded";
            Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
            String string3 = sch.getColumnTypeName(1);
            String string4 = "NUMBER";
            Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
            boolean first = res.next();
            Predef$.MODULE$.assert(first);
            long numRows = res.getLong(1);
            boolean second = res.next();
            Predef$.MODULE$.assert(!second);
            Utils$.MODULE$.executePostActions($this.jdbcWrapper(), conn, $this.params(), $this.params().table());
            return numRows;
        }
        catch (Exception exception) {
            Predef$.MODULE$.println((Object)exception);
            throw exception;
        }
        finally {
            SnowflakeTelemetry$.MODULE$.send(DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn).getTelemetry());
            if (!keepOpen) {
                conn.close();
            }
        }
    }

    public static Seq setup$default$1(DataUnloader $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static boolean setup$default$4(DataUnloader $this) {
        return false;
    }

    public static SnowflakeSQLStatement buildUnloadStatement(DataUnloader $this, SnowflakeSQLStatement statement, String location, String compression, Option credentialsString, Enumeration.Value format) {
        Enumeration.Value value;
        block6: {
            Tuple2 tuple2;
            SnowflakeSQLStatement credentials;
            block5: {
                block4: {
                    credentials = (SnowflakeSQLStatement)credentialsString.getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final SnowflakeSQLStatement apply() {
                            return EmptySnowflakeSQLStatement$.MODULE$.apply();
                        }
                    });
                    Utils$.MODULE$.setLastCopyUnload(statement.toString());
                    value = format;
                    Enumeration.Value value2 = SupportedFormat$.MODULE$.CSV();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                    tuple2 = new Tuple2((Object)new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |FILE_FORMAT = (\n                 |    TYPE=CSV\n                 |    COMPRESSION='", "'\n                 |    FIELD_DELIMITER='|'\n                 |    FIELD_OPTIONALLY_ENCLOSED_BY='\"'\n                 |    NULL_IF= ()\n                 |  )\n                 |  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compression})))).stripMargin()).$bang(), (Object)new ConstantString("FROM (").$plus(statement).$plus(")"));
                    break block5;
                }
                Enumeration.Value value4 = SupportedFormat$.MODULE$.JSON();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                tuple2 = new Tuple2((Object)new ConstantString(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |FILE_FORMAT = (\n                 |    TYPE=JSON\n                 |    COMPRESSION='", "'\n                 |)\n                 |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compression})))).stripMargin()).$bang(), (Object)new ConstantString("FROM (SELECT object_construct(*) FROM (").$plus(statement).$plus("))"));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                SnowflakeSQLStatement formatStmt = (SnowflakeSQLStatement)tuple22._1();
                SnowflakeSQLStatement queryStmt = (SnowflakeSQLStatement)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)formatStmt, (Object)queryStmt);
                SnowflakeSQLStatement formatStmt2 = (SnowflakeSQLStatement)tuple24._1();
                SnowflakeSQLStatement queryStmt2 = (SnowflakeSQLStatement)tuple24._2();
                return new ConstantString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY INTO '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{location}))).$plus(queryStmt2).$plus(credentials).$plus(formatStmt2).$plus("MAX_FILE_SIZE = ").$plus($this.params().s3maxfilesize());
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)value);
    }

    public static Enumeration.Value buildUnloadStatement$default$5(DataUnloader $this) {
        return SupportedFormat$.MODULE$.CSV();
    }

    public static void $init$(DataUnloader $this) {
    }
}

