/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import net.snowflake.spark.snowflake.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Parameters$ {
    public static final Parameters$ MODULE$;
    private final Logger log;
    private final HashSet<String> KNOWN_PARAMETERS;
    private final String PARAM_S3_MAX_FILE_SIZE;
    private final String PARAM_SF_ACCOUNT;
    private final String PARAM_SF_URL;
    private final String PARAM_SF_USER;
    private final String PARAM_SF_PASSWORD;
    private final String PARAM_SF_DATABASE;
    private final String PARAM_SF_SCHEMA;
    private final String PARAM_SF_ROLE;
    private final String PARAM_SF_COMPRESS;
    private final String PARAM_SF_SSL;
    private final String PARAM_TEMPDIR;
    private final String PARAM_SF_DBTABLE;
    private final String PARAM_SF_QUERY;
    private final String PARAM_SF_TIMEZONE;
    private final String PARAM_SF_WAREHOUSE;
    private final String PARAM_TEMP_KEY_ID;
    private final String PARAM_TEMP_KEY_SECRET;
    private final String PARAM_TEMP_SESSION_TOKEN;
    private final String PARAM_CHECK_BUCKET_CONFIGURATION;
    private final String PARAM_TEMP_SAS_TOKEN;
    private final String PARAM_PARALLELISM;
    private final String PARAM_PREACTIONS;
    private final String PARAM_POSTACTIONS;
    private final String PARAM_AWS_SECRET_KEY;
    private final String PARAM_AWS_ACCESS_KEY;
    private final String PARAM_USE_STAGING_TABLE;
    private final String PARAM_EXTRA_COPY_OPTIONS;
    private final String PARAM_AUTO_PUSHDOWN;
    private final String PARAM_COLUMN_MAP;
    private final String PARAM_TRUNCATE_COLUMNS;
    private final String PARAM_PURGE;
    private final String PARAM_TRUNCATE_TABLE;
    private final String PARAM_CONTINUE_ON_ERROR;
    private final String DEFAULT_S3_MAX_FILE_SIZE;
    private final int MIN_S3_MAX_FILE_SIZE;
    private final String TZ_SPARK1;
    private final String TZ_SPARK2;
    private final String TZ_SF1;
    private final String TZ_SF2;
    private final String TZ_SF_DEFAULT;
    private final Set<String> BOOLEAN_VALUES_TRUE;
    private final Set<String> BOOLEAN_VALUES_FALSE;
    private final Map<String, String> DEFAULT_PARAMETERS;

    static {
        new Parameters$();
    }

    public Logger log() {
        return this.log;
    }

    public HashSet<String> KNOWN_PARAMETERS() {
        return this.KNOWN_PARAMETERS;
    }

    private String knownParam(String param) {
        this.KNOWN_PARAMETERS().$plus$eq((Object)param);
        return param;
    }

    public String PARAM_S3_MAX_FILE_SIZE() {
        return this.PARAM_S3_MAX_FILE_SIZE;
    }

    public String PARAM_SF_ACCOUNT() {
        return this.PARAM_SF_ACCOUNT;
    }

    public String PARAM_SF_URL() {
        return this.PARAM_SF_URL;
    }

    public String PARAM_SF_USER() {
        return this.PARAM_SF_USER;
    }

    public String PARAM_SF_PASSWORD() {
        return this.PARAM_SF_PASSWORD;
    }

    public String PARAM_SF_DATABASE() {
        return this.PARAM_SF_DATABASE;
    }

    public String PARAM_SF_SCHEMA() {
        return this.PARAM_SF_SCHEMA;
    }

    public String PARAM_SF_ROLE() {
        return this.PARAM_SF_ROLE;
    }

    public String PARAM_SF_COMPRESS() {
        return this.PARAM_SF_COMPRESS;
    }

    public String PARAM_SF_SSL() {
        return this.PARAM_SF_SSL;
    }

    public String PARAM_TEMPDIR() {
        return this.PARAM_TEMPDIR;
    }

    public String PARAM_SF_DBTABLE() {
        return this.PARAM_SF_DBTABLE;
    }

    public String PARAM_SF_QUERY() {
        return this.PARAM_SF_QUERY;
    }

    public String PARAM_SF_TIMEZONE() {
        return this.PARAM_SF_TIMEZONE;
    }

    public String PARAM_SF_WAREHOUSE() {
        return this.PARAM_SF_WAREHOUSE;
    }

    public String PARAM_TEMP_KEY_ID() {
        return this.PARAM_TEMP_KEY_ID;
    }

    public String PARAM_TEMP_KEY_SECRET() {
        return this.PARAM_TEMP_KEY_SECRET;
    }

    public String PARAM_TEMP_SESSION_TOKEN() {
        return this.PARAM_TEMP_SESSION_TOKEN;
    }

    public String PARAM_CHECK_BUCKET_CONFIGURATION() {
        return this.PARAM_CHECK_BUCKET_CONFIGURATION;
    }

    public String PARAM_TEMP_SAS_TOKEN() {
        return this.PARAM_TEMP_SAS_TOKEN;
    }

    public String PARAM_PARALLELISM() {
        return this.PARAM_PARALLELISM;
    }

    public String PARAM_PREACTIONS() {
        return this.PARAM_PREACTIONS;
    }

    public String PARAM_POSTACTIONS() {
        return this.PARAM_POSTACTIONS;
    }

    public String PARAM_AWS_SECRET_KEY() {
        return this.PARAM_AWS_SECRET_KEY;
    }

    public String PARAM_AWS_ACCESS_KEY() {
        return this.PARAM_AWS_ACCESS_KEY;
    }

    public String PARAM_USE_STAGING_TABLE() {
        return this.PARAM_USE_STAGING_TABLE;
    }

    public String PARAM_EXTRA_COPY_OPTIONS() {
        return this.PARAM_EXTRA_COPY_OPTIONS;
    }

    public String PARAM_AUTO_PUSHDOWN() {
        return this.PARAM_AUTO_PUSHDOWN;
    }

    public String PARAM_COLUMN_MAP() {
        return this.PARAM_COLUMN_MAP;
    }

    public String PARAM_TRUNCATE_COLUMNS() {
        return this.PARAM_TRUNCATE_COLUMNS;
    }

    public String PARAM_PURGE() {
        return this.PARAM_PURGE;
    }

    public String PARAM_TRUNCATE_TABLE() {
        return this.PARAM_TRUNCATE_TABLE;
    }

    public String PARAM_CONTINUE_ON_ERROR() {
        return this.PARAM_CONTINUE_ON_ERROR;
    }

    public String DEFAULT_S3_MAX_FILE_SIZE() {
        return this.DEFAULT_S3_MAX_FILE_SIZE;
    }

    public int MIN_S3_MAX_FILE_SIZE() {
        return this.MIN_S3_MAX_FILE_SIZE;
    }

    public String TZ_SPARK1() {
        return this.TZ_SPARK1;
    }

    public String TZ_SPARK2() {
        return this.TZ_SPARK2;
    }

    public String TZ_SF1() {
        return this.TZ_SF1;
    }

    public String TZ_SF2() {
        return this.TZ_SF2;
    }

    public String TZ_SF_DEFAULT() {
        return this.TZ_SF_DEFAULT;
    }

    public Set<String> BOOLEAN_VALUES_TRUE() {
        return this.BOOLEAN_VALUES_TRUE;
    }

    public Set<String> BOOLEAN_VALUES_FALSE() {
        return this.BOOLEAN_VALUES_FALSE;
    }

    public boolean isTrue(String string) {
        return this.BOOLEAN_VALUES_TRUE().contains((Object)string.toLowerCase());
    }

    public Map<String, String> DEFAULT_PARAMETERS() {
        return this.DEFAULT_PARAMETERS;
    }

    public Parameters.MergedParameters mergeParameters(Map<String, String> params) {
        Map userParameters = (Map)params.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)key.toLowerCase(), (Object)value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        if (userParameters.contains((Object)this.PARAM_TEMPDIR())) {
            this.log().warn("Use of an external S3/Azure storage for staging is deprecated and will be removed in a future version. Unset your 'tempDir' parameter to use the Snowflake internal stage instead.");
        }
        if (userParameters.contains((Object)this.PARAM_SF_URL())) {
            if (userParameters.contains((Object)this.PARAM_SF_USER())) {
                if (userParameters.contains((Object)this.PARAM_SF_PASSWORD())) {
                    if (userParameters.contains((Object)this.PARAM_SF_DBTABLE()) || userParameters.contains((Object)this.PARAM_SF_QUERY())) {
                        if (userParameters.contains((Object)this.PARAM_SF_DBTABLE()) && userParameters.contains((Object)this.PARAM_SF_QUERY())) {
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"You cannot specify both the '").append((Object)this.PARAM_SF_DBTABLE()).append((Object)"' and '").append((Object)this.PARAM_SF_QUERY()).append((Object)"' parameters at the same time.").toString());
                        }
                        int tempParams = 0;
                        if (userParameters.contains((Object)this.PARAM_TEMP_KEY_ID())) {
                            ++tempParams;
                        }
                        if (userParameters.contains((Object)this.PARAM_TEMP_KEY_SECRET())) {
                            ++tempParams;
                        }
                        if (userParameters.contains((Object)this.PARAM_TEMP_SESSION_TOKEN())) {
                            ++tempParams;
                        }
                        if (tempParams != 0 && tempParams != 3) {
                            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"If you specify one of\n           |", ", ", " and\n           |", ",\n           |you must specify all 3 of them."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PARAM_TEMP_KEY_ID(), this.PARAM_TEMP_KEY_SECRET(), this.PARAM_TEMP_SESSION_TOKEN()})))).stripMargin().replace("\n", " "));
                        }
                        Option s3maxfilesizeStr = userParameters.get((Object)this.PARAM_S3_MAX_FILE_SIZE());
                        if (s3maxfilesizeStr.isDefined()) {
                            Option s3maxfilesize2 = this.toInt$1((String)s3maxfilesizeStr.get());
                            if (s3maxfilesize2.isEmpty()) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse ", "=", " as a number"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PARAM_S3_MAX_FILE_SIZE(), s3maxfilesizeStr.get()})));
                            }
                            if (BoxesRunTime.unboxToInt((Object)s3maxfilesize2.get()) < this.MIN_S3_MAX_FILE_SIZE()) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified ", "=", " too small"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PARAM_S3_MAX_FILE_SIZE(), s3maxfilesizeStr.get()})));
                            }
                        }
                        return new Parameters.MergedParameters((Map<String, String>)this.DEFAULT_PARAMETERS().$plus$plus((GenTraversableOnce)userParameters));
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"You must specify a Snowflake table name with the '").append((Object)this.PARAM_SF_DBTABLE()).append((Object)"' parameter or a query").append((Object)" with the ").append((Object)"'").append((Object)this.PARAM_SF_QUERY()).append((Object)"' parameter.").toString());
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"A snowflake passsword must be provided with '").append((Object)this.PARAM_SF_PASSWORD()).append((Object)"' parameter, e.g. 'password'").toString());
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"A snowflake user must be provided with '").append((Object)this.PARAM_SF_USER()).append((Object)"' parameter, e.g. 'user1'").toString());
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"A snowflake URL must be provided with '").append((Object)this.PARAM_SF_URL()).append((Object)"' parameter, e.g. 'accountname.snowflakecomputing.com:443'").toString());
    }

    private final Option toInt$1(String s) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt()));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    private Parameters$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.KNOWN_PARAMETERS = new HashSet();
        this.PARAM_S3_MAX_FILE_SIZE = this.knownParam("s3maxfilesize");
        this.PARAM_SF_ACCOUNT = this.knownParam("sfaccount");
        this.PARAM_SF_URL = this.knownParam("sfurl");
        this.PARAM_SF_USER = this.knownParam("sfuser");
        this.PARAM_SF_PASSWORD = this.knownParam("sfpassword");
        this.PARAM_SF_DATABASE = this.knownParam("sfdatabase");
        this.PARAM_SF_SCHEMA = this.knownParam("sfschema");
        this.PARAM_SF_ROLE = this.knownParam("sfrole");
        this.PARAM_SF_COMPRESS = this.knownParam("sfcompress");
        this.PARAM_SF_SSL = this.knownParam("sfssl");
        this.PARAM_TEMPDIR = this.knownParam("tempdir");
        this.PARAM_SF_DBTABLE = this.knownParam("dbtable");
        this.PARAM_SF_QUERY = this.knownParam("query");
        this.PARAM_SF_TIMEZONE = this.knownParam("sftimezone");
        this.PARAM_SF_WAREHOUSE = this.knownParam("sfwarehouse");
        this.PARAM_TEMP_KEY_ID = this.knownParam("temporary_aws_access_key_id");
        this.PARAM_TEMP_KEY_SECRET = this.knownParam("temporary_aws_secret_access_key");
        this.PARAM_TEMP_SESSION_TOKEN = this.knownParam("temporary_aws_session_token");
        this.PARAM_CHECK_BUCKET_CONFIGURATION = this.knownParam("check_bucket_configuration");
        this.PARAM_TEMP_SAS_TOKEN = this.knownParam("temporary_azure_sas_token");
        this.PARAM_PARALLELISM = this.knownParam("parallelism");
        this.PARAM_PREACTIONS = this.knownParam("preactions");
        this.PARAM_POSTACTIONS = this.knownParam("postactions");
        this.PARAM_AWS_SECRET_KEY = this.knownParam("awssecretkey");
        this.PARAM_AWS_ACCESS_KEY = this.knownParam("awsaccesskey");
        this.PARAM_USE_STAGING_TABLE = this.knownParam("usestagingtable");
        this.PARAM_EXTRA_COPY_OPTIONS = this.knownParam("extracopyoptions");
        this.PARAM_AUTO_PUSHDOWN = this.knownParam("autopushdown");
        this.PARAM_COLUMN_MAP = this.knownParam("columnmap");
        this.PARAM_TRUNCATE_COLUMNS = this.knownParam("truncate_columns");
        this.PARAM_PURGE = this.knownParam("purge");
        this.PARAM_TRUNCATE_TABLE = this.knownParam("truncate_table");
        this.PARAM_CONTINUE_ON_ERROR = this.knownParam("continue_on_error");
        this.DEFAULT_S3_MAX_FILE_SIZE = ((Object)BoxesRunTime.boxToInteger((int)10000000)).toString();
        this.MIN_S3_MAX_FILE_SIZE = 1000000;
        this.TZ_SPARK1 = "";
        this.TZ_SPARK2 = "spark";
        this.TZ_SF1 = "snowflake";
        this.TZ_SF2 = "sf_current";
        this.TZ_SF_DEFAULT = "sf_default";
        this.BOOLEAN_VALUES_TRUE = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on", "yes", "true", "1", "enabled"}));
        this.BOOLEAN_VALUES_FALSE = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"off", "no", "false", "0", "disabled"}));
        this.DEFAULT_PARAMETERS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diststyle"), (Object)"EVEN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_USE_STAGING_TABLE()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_CONTINUE_ON_ERROR()), (Object)"off"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_TRUNCATE_TABLE()), (Object)"off"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_PREACTIONS()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_POSTACTIONS()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PARAM_AUTO_PUSHDOWN()), (Object)"on")}));
    }
}

