/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.spark.snowflake.FailedFileList;
import net.snowflake.spark.snowflake.FailedFileList$;
import net.snowflake.spark.snowflake.IngestedFileList;
import net.snowflake.spark.snowflake.IngestedFileList$;
import net.snowflake.spark.snowflake.io.CloudStorage;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class IngestContextManager$ {
    public static final IngestContextManager$ MODULE$;
    private final String CONTEXT_DIR;
    private final String INGEST_FILE_LIST_NAME;
    private final String FAILED_FILE_INDEX;
    private final String LIST;
    private final String NAME;
    private final String TIME;
    private final ObjectMapper mapper;
    private final Log logger;

    static {
        new IngestContextManager$();
    }

    public String CONTEXT_DIR() {
        return this.CONTEXT_DIR;
    }

    public String INGEST_FILE_LIST_NAME() {
        return this.INGEST_FILE_LIST_NAME;
    }

    public String FAILED_FILE_INDEX() {
        return this.FAILED_FILE_INDEX;
    }

    public String LIST() {
        return this.LIST;
    }

    public String NAME() {
        return this.NAME;
    }

    public String TIME() {
        return this.TIME;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public Log logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IngestedFileList readIngestList(CloudStorage storage, Connection conn) {
        IngestedFileList ingestedFileList;
        String fileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.CONTEXT_DIR(), this.INGEST_FILE_LIST_NAME()}));
        if (!storage.fileExists(fileName)) {
            ingestedFileList = new IngestedFileList(storage, conn, IngestedFileList$.MODULE$.apply$default$3(), IngestedFileList$.MODULE$.apply$default$4());
            return ingestedFileList;
        }
        InputStream inputStream = storage.download(fileName, false);
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int c = inputStream.read();
        while (c != -1) {
            buffer.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)c}));
            c = inputStream.read();
        }
        try {
            JsonNode node = this.mapper().readTree(new String((byte[])buffer.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8")));
            int failedIndex = node.get(this.FAILED_FILE_INDEX()).asInt();
            FailedFileList failedList = this.readFailedFileList(failedIndex, storage, conn);
            ArrayNode arrNode = (ArrayNode)node.get(this.LIST());
            ObjectRef list = ObjectRef.create((Object)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arrNode.size()).foreach$mVc$sp((Function1)new Serializable(arrNode, list){
                public static final long serialVersionUID = 0L;
                private final ArrayNode arrNode$1;
                private final ObjectRef list$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.arrNode$1.get(i).get(IngestContextManager$.MODULE$.NAME()).asText()), (Object)BoxesRunTime.boxToLong((long)this.arrNode$1.get(i).get(IngestContextManager$.MODULE$.TIME()).asLong()));
                    this.list$1.elem = ((List)this.list$1.elem).$colon$colon((Object)tuple2);
                }
                {
                    this.arrNode$1 = arrNode$1;
                    this.list$1 = list$1;
                }
            });
            ingestedFileList = new IngestedFileList(storage, conn, (Option<FailedFileList>)new Some((Object)failedList), (Option<List<Tuple2<String, Object>>>)new Some((Object)((List)list.elem)));
            return ingestedFileList;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context file: ", " is broken: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, exception})));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FailedFileList readFailedFileList(int index, CloudStorage storage, Connection conn) {
        FailedFileList failedFileList;
        String fileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/failed_file_list_", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.CONTEXT_DIR(), BoxesRunTime.boxToInteger((int)index)}));
        if (!storage.fileExists(fileName)) {
            failedFileList = new FailedFileList(storage, conn, index, FailedFileList$.MODULE$.apply$default$4());
            return failedFileList;
        }
        InputStream inputStream = storage.download(fileName, false);
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int c = inputStream.read();
        while (c != -1) {
            buffer.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)c}));
            c = inputStream.read();
        }
        try {
            ArrayNode list = (ArrayNode)this.mapper().readTree(new String((byte[])buffer.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8")));
            ObjectRef set = ObjectRef.create((Object)HashSet$.MODULE$.empty());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), list.size()).foreach((Function1)new Serializable(list, set){
                public static final long serialVersionUID = 0L;
                private final ArrayNode list$2;
                private final ObjectRef set$1;

                public final HashSet<String> apply(int i) {
                    return ((HashSet)this.set$1.elem).$plus$eq((Object)this.list$2.get(i).asText());
                }
                {
                    this.list$2 = list$2;
                    this.set$1 = set$1;
                }
            });
            failedFileList = new FailedFileList(storage, conn, index, (Option<HashSet<String>>)new Some((Object)((HashSet)set.elem)));
            return failedFileList;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"context file: ", " is broken: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, exception})));
        }
    }

    private IngestContextManager$() {
        MODULE$ = this;
        this.CONTEXT_DIR = "context";
        this.INGEST_FILE_LIST_NAME = "ingested_file_list.json";
        this.FAILED_FILE_INDEX = "failed_file_index";
        this.LIST = "list";
        this.NAME = "name";
        this.TIME = "time";
        this.mapper = new ObjectMapper();
        this.logger = LogFactory.getLog(this.getClass());
    }
}

