/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryV2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;

public class TelemetryEvent
extends JSONObject {

    private static class Builder<T> {
        protected final Class<T> builderClass;
        protected TelemetryEvent body = new TelemetryEvent();
        protected HashMap<String, String> tags;
        private static final String version = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.version").getLocalizedMessage("version");
        private static final String driver = "JDBC";

        public Builder(Class<T> builderClass) {
            this.builderClass = builderClass;
            this.tags = new HashMap();
            this.tags.put("driver", driver);
            Package pkg = Package.getPackage("net.snowflake.client.jdbc");
            this.tags.put("version", version);
        }

        private String getUTCNow() {
            SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormatGmt.format(new Date());
        }

        public T withName(String name) {
            this.body.put("Name", name);
            return this.builderClass.cast(this);
        }

        public T withTag(String name, String value) {
            this.tags.put(name, value);
            return this.builderClass.cast(this);
        }

        protected TelemetryEvent build() {
            this.body.put("Created_On", this.getUTCNow());
            this.putMap("Tags", this.tags);
            return this.body;
        }

        private void putMap(String name, HashMap<String, String> map) {
            JSONArray array = new JSONArray();
            for (Map.Entry<String, String> pairs : map.entrySet()) {
                JSONObject obj = new JSONObject();
                obj.put("Name", pairs.getKey());
                obj.put("Value", pairs.getValue());
                array.appendElement(obj);
            }
            this.body.put(name, array);
        }
    }

    public static class LogBuilder
    extends Builder<LogBuilder> {
        public LogBuilder() {
            super(LogBuilder.class);
        }

        public LogBuilder withException(Exception ex) {
            this.withName("Exception:" + ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stackTrace = sw.toString();
            this.withValue(stackTrace);
            return this;
        }

        public LogBuilder withException(SFException ex) {
            this.withName("Exception:" + ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String stackTrace = sw.toString();
            this.withValue(stackTrace);
            return this;
        }

        public LogBuilder withValue(String value) {
            this.body.put("Value", value);
            return this;
        }

        @Override
        public TelemetryEvent build() {
            TelemetryEvent event = super.build();
            event.put("Type", Type.Log);
            return event;
        }
    }

    public static class MetricBuilder
    extends Builder<MetricBuilder> {
        public MetricBuilder withException(Exception ex) {
            this.withName("Exception:" + ex.getMessage());
            this.withValue(1);
            return this;
        }

        public MetricBuilder() {
            super(MetricBuilder.class);
        }

        public MetricBuilder withValue(int value) {
            this.body.put("Value", value);
            return this;
        }

        public MetricBuilder withValue(float value) {
            this.body.put("Value", Float.valueOf(value));
            return this;
        }

        @Override
        public TelemetryEvent build() {
            TelemetryEvent event = super.build();
            event.put("Type", Type.Metric);
            return event;
        }
    }

    public static enum Type {
        Metric,
        Log;

    }
}

