/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SLF4JLogger;

public class SFLoggerFactory {
    public static LoggerImpl loggerImplementation;
    private static final String STATIC_LOGGER_BINDER_PATH = "net/snowflake/client/jdbc/internal/org/slf4j/impl/StaticLoggerBinder.class";

    public static SFLogger getLogger(Class<?> clazz) {
        String logger;
        if (loggerImplementation == null && (loggerImplementation = LoggerImpl.fromString(logger = System.getProperty("net.snowflake.jdbc.loggerImpl"))) == null) {
            loggerImplementation = SFLoggerFactory.slf4jImplExist() ? LoggerImpl.SLF4JLOGGER : LoggerImpl.JDK14LOGGER;
        }
        switch (loggerImplementation) {
            case SLF4JLOGGER: {
                return new SLF4JLogger(clazz);
            }
        }
        return new JDK14Logger(clazz.getName());
    }

    private static boolean slf4jImplExist() {
        try {
            ClassLoader loggerFactoryClassLoader = SFLoggerFactory.class.getClassLoader();
            Enumeration<URL> paths = loggerFactoryClassLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : loggerFactoryClassLoader.getResources(STATIC_LOGGER_BINDER_PATH);
            return paths.hasMoreElements();
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    static enum LoggerImpl {
        SLF4JLOGGER("net.snowflake.client.log.SLF4JLogger"),
        JDK14LOGGER("net.snowflake.client.log.JDK14Logger");

        private String loggerImplClassName;

        private LoggerImpl(String loggerClass) {
            this.loggerImplClassName = loggerClass;
        }

        public String getLoggerImplClassName() {
            return this.loggerImplClassName;
        }

        public static LoggerImpl fromString(String loggerImplClassName) {
            if (loggerImplClassName != null) {
                for (LoggerImpl imp : LoggerImpl.values()) {
                    if (!loggerImplClassName.equalsIgnoreCase(imp.getLoggerImplClassName())) continue;
                    return imp;
                }
            }
            return null;
        }
    }
}

