/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.snowflake.client.jdbc.internal.apache.arrow.util.AutoCloseables;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compare.VectorEqualsVisitor;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compression.CompressionCodec;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compression.CompressionUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.WriteChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.IpcOption;

public class ArrowStreamWriter
extends ArrowWriter {
    private final Map<Long, FieldVector> previousDictionaries = new HashMap<Long, FieldVector>();

    public ArrowStreamWriter(VectorSchemaRoot root, DictionaryProvider provider, OutputStream out) {
        this(root, provider, Channels.newChannel(out));
    }

    public ArrowStreamWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out) {
        this(root, provider, out, IpcOption.DEFAULT);
    }

    public ArrowStreamWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option) {
        super(root, provider, out, option);
    }

    public ArrowStreamWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType) {
        this(root, provider, out, option, compressionFactory, codecType, Optional.empty());
    }

    public ArrowStreamWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType, Optional<Integer> compressionLevel) {
        super(root, provider, out, option, compressionFactory, codecType, compressionLevel);
    }

    public static void writeEndOfStream(WriteChannel out, IpcOption option) throws IOException {
        if (!option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
        }
        out.writeIntLittleEndian(0);
    }

    @Override
    protected void endInternal(WriteChannel out) throws IOException {
        ArrowStreamWriter.writeEndOfStream(out, this.option);
    }

    @Override
    protected void ensureDictionariesWritten(DictionaryProvider provider, Set<Long> dictionaryIdsUsed) throws IOException {
        for (long id : dictionaryIdsUsed) {
            Dictionary dictionary = provider.lookup(id);
            FieldVector vector = dictionary.getVector();
            if (this.previousDictionaries.containsKey(id) && VectorEqualsVisitor.vectorEquals(vector, this.previousDictionaries.get(id))) continue;
            this.writeDictionaryBatch(dictionary);
            if (this.previousDictionaries.containsKey(id)) {
                this.previousDictionaries.get(id).close();
            }
            this.previousDictionaries.put(id, ArrowStreamWriter.copyVector(vector));
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            AutoCloseables.close(this.previousDictionaries.values());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static FieldVector copyVector(FieldVector source) {
        FieldVector copy = source.getField().createVector(source.getAllocator());
        copy.allocateNew();
        for (int i = 0; i < source.getValueCount(); ++i) {
            copy.copyFromSafe(i, i, source);
        }
        copy.setValueCount(source.getValueCount());
        return copy;
    }
}

