/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class FileUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(FileUtil.class);
    private static final Collection<PosixFilePermission> WRITE_BY_OTHERS = Arrays.asList(PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
    private static final Collection<PosixFilePermission> READ_BY_OTHERS = Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ);

    public static void logFileUsage(Path filePath, String context, boolean logReadAccess) {
        logger.info("{}Accessing file: {}", FileUtil.getContextStr(context), filePath);
        FileUtil.logWarnWhenAccessibleByOthers(filePath, context, logReadAccess);
    }

    public static void logFileUsage(File file, String context, boolean logReadAccess) {
        FileUtil.logFileUsage(file.toPath(), context, logReadAccess);
    }

    public static void logFileUsage(String stringPath, String context, boolean logReadAccess) {
        Path path = Paths.get(stringPath, new String[0]);
        FileUtil.logFileUsage(path, context, logReadAccess);
    }

    private static void logWarnWhenAccessibleByOthers(Path filePath, String context, boolean logReadAccess) {
        if (Constants.getOS() == Constants.OS.WINDOWS) {
            return;
        }
        try {
            Set<PosixFilePermission> filePermissions = Files.getPosixFilePermissions(filePath, new LinkOption[0]);
            logger.debug("{}File {} access rights: {}", FileUtil.getContextStr(context), filePath, filePermissions);
            boolean isWritableByOthers = FileUtil.isPermPresent(filePermissions, WRITE_BY_OTHERS);
            boolean isReadableByOthers = FileUtil.isPermPresent(filePermissions, READ_BY_OTHERS);
            if (isWritableByOthers || isReadableByOthers && logReadAccess) {
                logger.warn("{}File {} is accessible by others to:{}{}", FileUtil.getContextStr(context), filePath, isReadableByOthers && logReadAccess ? " read" : "", isWritableByOthers ? " write" : "");
            }
        }
        catch (IOException e) {
            logger.warn("{}Unable to access the file to check the permissions: {}. Error: {}", FileUtil.getContextStr(context), filePath, e);
        }
    }

    private static boolean isPermPresent(Collection<PosixFilePermission> filePerms, Collection<PosixFilePermission> permsToCheck) throws IOException {
        return filePerms.stream().anyMatch(permsToCheck::contains);
    }

    private static String getContextStr(String context) {
        return Strings.isNullOrEmpty(context) ? "" : context + ": ";
    }
}

