/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.internal;

import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ClientStreamTracer;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientStreamListener;
import net.snowflake.client.jdbc.internal.grpc.internal.InsightBuilder;
import net.snowflake.client.jdbc.internal.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;
    private final ClientStreamTracer[] tracers;

    public FailingClientStream(Status error, ClientStreamTracer[] tracers) {
        this(error, ClientStreamListener.RpcProgress.PROCESSED, tracers);
    }

    public FailingClientStream(Status error, ClientStreamListener.RpcProgress rpcProgress, ClientStreamTracer[] tracers) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
        this.tracers = tracers;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(!this.started, "already started");
        this.started = true;
        for (ClientStreamTracer tracer : this.tracers) {
            tracer.streamClosed(this.error);
        }
        listener.closed(this.error, this.rpcProgress, new Metadata());
    }

    @VisibleForTesting
    Status getError() {
        return this.error;
    }

    @Override
    public void appendTimeoutInsight(InsightBuilder insight) {
        insight.appendKeyValue("error", this.error).appendKeyValue("progress", (Object)this.rpcProgress);
    }
}

