/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.snowflake.client.config.ConnectionParameters;
import net.snowflake.client.config.SFConnectionConfigParser;
import net.snowflake.client.core.SecurityUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeDriver
implements Driver {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDriver.class);
    public static final String AUTO_CONNECTION_STRING_PREFIX = "jdbc:snowflake:auto";
    static SnowflakeDriver INSTANCE;
    public static final Properties EMPTY_PROPERTIES;
    public static String implementVersion;
    static int majorVersion;
    static int minorVersion;
    static long patchVersion;
    protected static boolean disableIncidents;
    private static boolean disableArrowResultFormat;
    private static String disableArrowResultFormatMessage;
    private static final ResourceBundleManager versionResourceBundleManager;

    private static void initializeArrowSupport() {
        try {
            System.setProperty("net.snowflake.client.jdbc.internal.io.netty.tryReflectionSetAccessible", "true");
        }
        catch (Throwable t2) {
            disableArrowResultFormat = true;
            disableArrowResultFormatMessage = t2.getLocalizedMessage();
        }
        if ("true".equals(SnowflakeUtil.systemGetProperty("snowflake.jdbc.enable.illegalAccessWarning"))) {
            return;
        }
        SnowflakeDriver.disableIllegalReflectiveAccessWarning();
    }

    static void disableIllegalReflectiveAccessWarning() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Method staticFieldBase = unsafeClass.getDeclaredMethod("staticFieldBase", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long loggerOffset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            Object loggerBase = staticFieldBase.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerBase, loggerOffset, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initializeClientVersionFromManifest() {
        try {
            String[] versionBreakdown;
            if (implementVersion != null) {
                versionBreakdown = implementVersion.split("\\.");
                if (versionBreakdown.length != 3) {
                    throw new SnowflakeSQLLoggedException(null, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Invalid Snowflake JDBC Version: " + implementVersion);
                }
            } else {
                throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), null, "Snowflake JDBC Version is not set. Ensure static version string was initialized.");
            }
            majorVersion = Integer.parseInt(versionBreakdown[0]);
            minorVersion = Integer.parseInt(versionBreakdown[1]);
            patchVersion = Long.parseLong(versionBreakdown[2]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String getClientVersionStringFromManifest() {
        return versionResourceBundleManager.getLocalizedMessage("version");
    }

    public static boolean isDisableArrowResultFormat() {
        return disableArrowResultFormat;
    }

    public static String getDisableArrowResultFormatMessage() {
        return disableArrowResultFormatMessage;
    }

    public static String getImplementationTitle() {
        Package pkg = Package.getPackage("net.snowflake.client.jdbc");
        return pkg.getImplementationTitle();
    }

    public static String getJdbcJarname() {
        return String.format("%s-%s", SnowflakeDriver.getImplementationTitle(), implementVersion);
    }

    @Override
    public boolean acceptsURL(String url) {
        return SnowflakeConnectString.parse(url, EMPTY_PROPERTIES).isValid();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionParameters connectionParameters = SnowflakeDriver.overrideByFileConnectionParametersIfAutoConfiguration(url, info);
        if (connectionParameters.getUrl() == null) {
            throw new SnowflakeSQLException("Unable to connect to url of 'null'.");
        }
        if (!SnowflakeConnectString.hasSupportedPrefix(connectionParameters.getUrl())) {
            return null;
        }
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(connectionParameters.getUrl(), connectionParameters.getParams());
        if (!conStr.isValid()) {
            throw new SnowflakeSQLException("Connection string is invalid. Unable to parse.");
        }
        return new SnowflakeConnectionV1(connectionParameters.getUrl(), connectionParameters.getParams());
    }

    private static ConnectionParameters overrideByFileConnectionParametersIfAutoConfiguration(String url, Properties info) throws SnowflakeSQLException {
        if (url != null && url.contains(AUTO_CONNECTION_STRING_PREFIX)) {
            ConnectionParameters connectionParameters = SFConnectionConfigParser.buildConnectionParameters();
            if (connectionParameters == null) {
                throw new SnowflakeSQLException("Unavailable connection configuration parameters expected for auto configuration using file");
            }
            return connectionParameters;
        }
        return new ConnectionParameters(url, info);
    }

    @SnowflakeJdbcInternalApi
    public Connection connect() throws SQLException {
        logger.debug("Execute internal method connect() without parameters", new Object[0]);
        return this.connect(AUTO_CONNECTION_STRING_PREFIX, null);
    }

    @Override
    public int getMajorVersion() {
        return majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (url == null || url.isEmpty()) {
            DriverPropertyInfo[] retVal = new DriverPropertyInfo[]{new DriverPropertyInfo("serverURL", null)};
            retVal[0].description = "server URL in form of <protocol>://<host or domain>:<port number>/<path of resource>";
            return retVal;
        }
        SnowflakeConnectionV1 con = new SnowflakeConnectionV1(url, info, true);
        List<DriverPropertyInfo> missingProperties = con.returnMissingProperties();
        con.close();
        DriverPropertyInfo[] retVal = new DriverPropertyInfo[missingProperties.size()];
        retVal = missingProperties.toArray(retVal);
        return retVal;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static boolean isDisableIncidents() {
        return disableIncidents;
    }

    public static void setDisableIncidents(boolean throttleIncidents) {
        disableIncidents = throttleIncidents;
    }

    public static final void main(String[] args) {
        Package pkg;
        if (args.length > 0 && "--version".equals(args[0]) && (pkg = Package.getPackage("net.snowflake.client.jdbc")) != null) {
            System.out.println(pkg.getImplementationVersion());
        }
    }

    static {
        EMPTY_PROPERTIES = new Properties();
        implementVersion = "3.17.0";
        majorVersion = 0;
        minorVersion = 0;
        patchVersion = 0L;
        disableIncidents = false;
        disableArrowResultFormat = false;
        versionResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.version");
        try {
            INSTANCE = new SnowflakeDriver();
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to register " + SnowflakeDriver.class.getName(), ex);
        }
        SnowflakeDriver.initializeArrowSupport();
        SnowflakeDriver.initializeClientVersionFromManifest();
        SecurityUtil.addBouncyCastleProvider();
    }
}

