/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;

public class VarCharConverter
extends AbstractArrowVectorConverter {
    private VarCharVector varCharVector;

    public VarCharConverter(ValueVector valueVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TEXT.name(), valueVector, columnIndex, context);
        this.varCharVector = (VarCharVector)valueVector;
    }

    @Override
    public String toString(int index) {
        byte[] bytes = this.toBytes(index);
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes(int index) {
        return this.isNull(index) ? null : this.varCharVector.get(index);
    }

    @Override
    public Object toObject(int index) {
        return this.toString(index);
    }

    @Override
    public short toShort(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return 0;
            }
            return Short.parseShort(str);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", str);
        }
    }

    @Override
    public int toInt(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int", str);
        }
    }

    @Override
    public long toLong(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "long", str);
        }
    }

    @Override
    public float toFloat(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "float", str);
        }
    }

    @Override
    public double toDouble(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "double", str);
        }
    }

    @Override
    public BigDecimal toBigDecimal(int index) throws SFException {
        String str = this.toString(index);
        try {
            if (str == null) {
                return null;
            }
            return new BigDecimal(str);
        }
        catch (Exception ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "big decimal", str);
        }
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        String str = this.toString(index);
        if (str == null) {
            return false;
        }
        if ("0".equals(str) || Boolean.FALSE.toString().equalsIgnoreCase(str)) {
            return false;
        }
        if ("1".equals(str) || Boolean.TRUE.toString().equalsIgnoreCase(str)) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", str);
    }

    @Override
    public Date toDate(int index, TimeZone jvmTz, boolean useDateFormat) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date(dateFormat.parse(this.toString(index)).getTime());
            return date;
        }
        catch (ParseException e) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "date", "");
        }
    }
}

