/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.transform;

import javax.xml.stream.events.XMLEvent;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.Stats;
import net.snowflake.client.jdbc.internal.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import net.snowflake.client.jdbc.internal.amazonaws.transform.StaxUnmarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;

class StatsStaxUnmarshaller
implements Unmarshaller<Stats, StaxUnmarshallerContext> {
    private static final StatsStaxUnmarshaller instance = new StatsStaxUnmarshaller();

    public static StatsStaxUnmarshaller getInstance() {
        return instance;
    }

    private StatsStaxUnmarshaller() {
    }

    @Override
    public Stats unmarshall(StaxUnmarshallerContext context) throws Exception {
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        Stats result = new Stats();
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return result;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BytesScanned", targetDepth)) {
                    result.setBytesScanned(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BytesReturned", targetDepth)) {
                    result.setBytesReturned(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                }
                if (!context.testExpression("BytesProcessed", targetDepth)) continue;
                result.setBytesProcessed(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return result;
    }
}

