/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Properties;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpProtocol;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.Protocol;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;

@SnowflakeJdbcInternalApi
public class S3HttpUtil {
    public static void setProxyForS3(HttpClientSettingsKey key, ClientConfiguration clientConfig) {
        if (key != null && key.usesProxy()) {
            clientConfig.setProxyProtocol(key.getProxyHttpProtocol() == HttpProtocol.HTTPS ? Protocol.HTTPS : Protocol.HTTP);
            clientConfig.setProxyHost(key.getProxyHost());
            clientConfig.setProxyPort(key.getProxyPort());
            clientConfig.setNonProxyHosts(key.getNonProxyHosts());
            if (!Strings.isNullOrEmpty(key.getProxyUser()) && !Strings.isNullOrEmpty(key.getProxyPassword())) {
                clientConfig.setProxyUsername(key.getProxyUser());
                clientConfig.setProxyPassword(key.getProxyPassword());
            }
        }
    }

    public static void setSessionlessProxyForS3(Properties proxyProperties, ClientConfiguration clientConfig) throws SnowflakeSQLException {
        Boolean useProxy;
        if (proxyProperties != null && proxyProperties.size() > 0 && proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = proxyProperties.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(proxyProperties.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            String proxyUser = proxyProperties.getProperty(SFSessionProperty.PROXY_USER.getPropertyKey());
            String proxyPassword = proxyProperties.getProperty(SFSessionProperty.PROXY_PASSWORD.getPropertyKey());
            String nonProxyHosts = proxyProperties.getProperty(SFSessionProperty.NON_PROXY_HOSTS.getPropertyKey());
            String proxyProtocol = proxyProperties.getProperty(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey());
            Protocol protocolEnum = !Strings.isNullOrEmpty(proxyProtocol) && proxyProtocol.equalsIgnoreCase("https") ? Protocol.HTTPS : Protocol.HTTP;
            clientConfig.setProxyHost(proxyHost);
            clientConfig.setProxyPort(proxyPort);
            clientConfig.setNonProxyHosts(nonProxyHosts);
            clientConfig.setProxyProtocol(protocolEnum);
            if (!Strings.isNullOrEmpty(proxyUser) && !Strings.isNullOrEmpty(proxyPassword)) {
                clientConfig.setProxyUsername(proxyUser);
                clientConfig.setProxyPassword(proxyPassword);
            }
        }
    }
}

