/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.file;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageUri;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.BaseResponse;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.PathUtility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.CopyState;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.CopyStatus;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileAttributes;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileDirectoryAttributes;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileDirectoryProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileShareAttributes;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileShareProperties;

final class FileResponse
extends BaseResponse {
    public static CopyState getCopyState(HttpURLConnection request) throws URISyntaxException, ParseException {
        String copyStatusString = request.getHeaderField("x-ms-copy-status");
        if (!Utility.isNullOrEmpty(copyStatusString)) {
            String copyCompletionTimeString;
            String copySourceString;
            CopyState copyState = new CopyState();
            copyState.setStatus(CopyStatus.parse(copyStatusString));
            copyState.setCopyId(request.getHeaderField("x-ms-copy-id"));
            copyState.setStatusDescription(request.getHeaderField("x-ms-copy-status-description"));
            String copyProgressString = request.getHeaderField("x-ms-copy-progress");
            if (!Utility.isNullOrEmpty(copyProgressString)) {
                String[] progressSequence = copyProgressString.split("/");
                copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            }
            if (!Utility.isNullOrEmpty(copySourceString = request.getHeaderField("x-ms-copy-source"))) {
                copyState.setSource(new URI(copySourceString));
            }
            if (!Utility.isNullOrEmpty(copyCompletionTimeString = request.getHeaderField("x-ms-copy-completion-time"))) {
                copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(copyCompletionTimeString));
            }
            return copyState;
        }
        return null;
    }

    public static FileShareAttributes getFileShareAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        FileShareAttributes shareAttributes = new FileShareAttributes();
        FileShareProperties shareProperties = shareAttributes.getProperties();
        shareProperties.setEtag(BaseResponse.getEtag(request));
        shareProperties.setShareQuota(FileResponse.parseShareQuota(request));
        shareProperties.setLastModified(new Date(request.getLastModified()));
        shareAttributes.setMetadata(FileResponse.getMetadata(request));
        return shareAttributes;
    }

    public static FileDirectoryAttributes getFileDirectoryAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        URI tempURI;
        FileDirectoryAttributes directoryAttributes = new FileDirectoryAttributes();
        try {
            tempURI = PathUtility.stripSingleURIQueryAndFragment(request.getURL().toURI());
        }
        catch (URISyntaxException e) {
            StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
            throw wrappedUnexpectedException;
        }
        directoryAttributes.setName(PathUtility.getDirectoryNameFromURI(tempURI, usePathStyleUris));
        FileDirectoryProperties directoryProperties = directoryAttributes.getProperties();
        directoryProperties.setEtag(BaseResponse.getEtag(request));
        directoryProperties.setLastModified(new Date(request.getLastModified()));
        directoryAttributes.setMetadata(FileResponse.getMetadata(request));
        return directoryAttributes;
    }

    public static FileAttributes getFileAttributes(HttpURLConnection request, StorageUri resourceURI) throws URISyntaxException, ParseException {
        FileAttributes fileAttributes = new FileAttributes();
        FileProperties properties = fileAttributes.getProperties();
        properties.setCacheControl(request.getHeaderField("Cache-Control"));
        properties.setContentDisposition(request.getHeaderField("Content-Disposition"));
        properties.setContentEncoding(request.getHeaderField("Content-Encoding"));
        properties.setContentLanguage(request.getHeaderField("Content-Language"));
        if (!Utility.isNullOrEmpty(request.getHeaderField("Content-Range"))) {
            properties.setContentMD5(request.getHeaderField("x-ms-content-md5"));
        } else {
            properties.setContentMD5(request.getHeaderField("Content-MD5"));
        }
        properties.setContentType(request.getHeaderField("Content-Type"));
        properties.setEtag(BaseResponse.getEtag(request));
        properties.setCopyState(FileResponse.getCopyState(request));
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        lastModifiedCalendar.setTime(new Date(request.getLastModified()));
        properties.setLastModified(lastModifiedCalendar.getTime());
        String rangeHeader = request.getHeaderField("Content-Range");
        String xContentLengthHeader = request.getHeaderField("x-ms-content-length");
        if (!Utility.isNullOrEmpty(rangeHeader)) {
            properties.setLength(Long.parseLong(rangeHeader.split("/")[1]));
        } else if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            properties.setLength(Long.parseLong(xContentLengthHeader));
        } else {
            String contentLength = request.getHeaderField("Content-Length");
            if (!Utility.isNullOrEmpty(contentLength)) {
                properties.setLength(Long.parseLong(contentLength));
            }
        }
        fileAttributes.setStorageUri(resourceURI);
        fileAttributes.setMetadata(BaseResponse.getMetadata(request));
        return fileAttributes;
    }

    static Integer parseShareQuota(HttpURLConnection request) {
        Integer shareQuota = request.getHeaderFieldInt("x-ms-share-quota", -1);
        return shareQuota == -1 ? null : shareQuota;
    }

    private FileResponse() {
    }
}

