/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

public final class Constants {
    public static final String PREFIX_FOR_STORAGE_HEADER = "x-ms-";
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final String ACCESS_POLICY = "AccessPolicy";
    public static final int BUFFER_COPY_LENGTH = 8192;
    public static final String COPY_COMPLETION_TIME_ELEMENT = "CopyCompletionTime";
    public static final String COPY_ID_ELEMENT = "CopyId";
    public static final String COPY_PROGRESS_ELEMENT = "CopyProgress";
    public static final String COPY_SOURCE_ELEMENT = "CopySource";
    public static final String COPY_STATUS_DESCRIPTION_ELEMENT = "CopyStatusDescription";
    public static final String COPY_STATUS_ELEMENT = "CopyStatus";
    public static final String INCREMENTAL_COPY_ELEMENT = "IncrementalCopy";
    public static final String COPY_DESTINATION_SNAPSHOT_ID_ELEMENT = "CopyDestinationSnapshot";
    public static final int DEFAULT_READ_TIMEOUT = 300000;
    public static final String DELIMITER_ELEMENT = "Delimiter";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_DELETE = "DELETE";
    public static final String HTTP_HEAD = "HEAD";
    public static final String HTTP_POST = "POST";
    public static final String EMPTY_STRING = "";
    public static final String END_ELEMENT = "End";
    public static final String ERROR_CODE = "Code";
    public static final String ERROR_EXCEPTION = "ExceptionDetails";
    public static final String ERROR_EXCEPTION_MESSAGE = "ExceptionMessage";
    public static final String ERROR_EXCEPTION_STACK_TRACE = "StackTrace";
    public static final String ERROR_MESSAGE = "Message";
    public static final String ERROR_ROOT_ELEMENT = "Error";
    public static final String ETAG_ELEMENT = "Etag";
    public static final String EXPIRY = "Expiry";
    public static final String FALSE = "false";
    public static final String GEO_BOOTSTRAP_VALUE = "bootstrap";
    public static final String GEO_LIVE_VALUE = "live";
    public static final String GEO_UNAVAILABLE_VALUE = "unavailable";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String HTTPS_HTTP = "https,http";
    public static final String ID = "Id";
    public static final String INVALID_METADATA_NAME = "x-ms-invalid-name";
    public static final String LAST_MODIFIED_ELEMENT = "Last-Modified";
    public static final int LEASE_BREAK_PERIOD_MAX = 60;
    public static final int LEASE_BREAK_PERIOD_MIN = 0;
    public static final String LEASE_DURATION_ELEMENT = "LeaseDuration";
    public static final int LEASE_DURATION_MAX = 60;
    public static final int LEASE_DURATION_MIN = 15;
    public static final String LEASE_STATE_ELEMENT = "LeaseState";
    public static final String LEASE_STATUS_ELEMENT = "LeaseStatus";
    public static final String LOCKED_VALUE = "Locked";
    public static final String MARKER_ELEMENT = "Marker";
    public static int MAX_RANGE_CONTENT_MD5 = 0x400000;
    public static int MAX_BLOCK_SIZE = 0x6400000;
    public static int MAX_APPEND_BLOCK_SIZE = 0x400000;
    public static int MAX_PAGE_WRITE_SIZE = 0x400000;
    public static int MAX_FILE_WRITE_SIZE = 0x400000;
    public static int MIN_PERMITTED_FILE_WRITE_SIZE = 512;
    public static final long MAX_BLOCK_NUMBER = 50000L;
    public static final long MAX_BLOB_SIZE = 50000L * (long)MAX_BLOCK_SIZE;
    public static final int MIN_PERMITTED_BLOCK_SIZE = 16384;
    public static int MIN_LARGE_BLOCK_SIZE = 0x400001;
    public static final int SUBSTREAM_BUFFER_SIZE = 0x400000;
    public static final int DEFAULT_STREAM_WRITE_IN_BYTES = 0x400000;
    public static final int DEFAULT_MINIMUM_READ_SIZE_IN_BYTES = 0x400000;
    public static final int MAX_MARK_LENGTH = 0x10000000;
    public static final String MAX_RESULTS_ELEMENT = "MaxResults";
    public static final int MAX_SHARED_ACCESS_POLICY_IDENTIFIERS = 5;
    public static final int MAXIMUM_SEGMENTED_RESULTS = 5000;
    public static final String METADATA_ELEMENT = "Metadata";
    public static final String NAME_ELEMENT = "Name";
    public static final String NEXT_MARKER_ELEMENT = "NextMarker";
    public static final int PAGE_SIZE = 512;
    public static final String PERMISSION = "Permission";
    public static final String PREFIX_ELEMENT = "Prefix";
    public static final String PROPERTIES = "Properties";
    public static final String PUBLIC_ACCESS_ELEMENT = "PublicAccess";
    public static final String SERVER_ENCRYPTION_STATUS_ELEMENT = "ServerEncrypted";
    public static final String SIGNED_IDENTIFIER_ELEMENT = "SignedIdentifier";
    public static final String SIGNED_IDENTIFIERS_ELEMENT = "SignedIdentifiers";
    public static final String START = "Start";
    public static final String TRUE = "true";
    public static final String UNLOCKED_VALUE = "Unlocked";
    public static final String UNSPECIFIED_VALUE = "Unspecified";
    public static final String URL_ELEMENT = "Url";
    public static final String UTF8_CHARSET = "UTF-8";

    private Constants() {
    }

    public static class QueryConstants {
        public static final String API_VERSION = "api-version";
        public static final String CACHE_CONTROL = "rscc";
        public static final String CONTENT_TYPE = "rsct";
        public static final String CONTENT_ENCODING = "rsce";
        public static final String CONTENT_LANGUAGE = "rscl";
        public static final String CONTENT_DISPOSITION = "rscd";
        public static final String COMPONENT = "comp";
        public static final String COPY = "copy";
        public static final String COPY_ID = "copyid";
        public static final String END_PARTITION_KEY = "epk";
        public static final String END_ROW_KEY = "erk";
        public static final String LIST = "list";
        public static final String PROPERTIES = "properties";
        public static final String RESOURCETYPE = "restype";
        public static final String SAS_TABLE_NAME = "tn";
        public static final String SIGNATURE = "sig";
        public static final String SIGNED_EXPIRY = "se";
        public static final String SIGNED_IDENTIFIER = "si";
        public static final String SIGNED_IP = "sip";
        public static final String SIGNED_KEY = "sk";
        public static final String SIGNED_PERMISSIONS = "sp";
        public static final String SIGNED_PROTOCOLS = "spr";
        public static final String SIGNED_RESOURCE = "sr";
        public static final String SIGNED_RESOURCE_TYPE = "srt";
        public static final String SIGNED_SERVICE = "ss";
        public static final String SIGNED_START = "st";
        public static final String SIGNED_VERSION = "sv";
        public static final String SNAPSHOT = "snapshot";
        public static final String START_PARTITION_KEY = "spk";
        public static final String START_ROW_KEY = "srk";
        public static final String STATS = "stats";
        public static final String DELIMITER = "delimiter";
        public static final String INCLUDE = "include";
        public static final String MARKER = "marker";
        public static final String MAX_RESULTS = "maxresults";
        public static final String METADATA = "metadata";
        public static final String PREFIX = "prefix";
        public static final String ACL = "acl";
    }

    public static class HeaderConstants {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String AUTHORIZATION = "Authorization";
        public static final String BEGIN_RANGE_HEADER_FORMAT = "bytes=%d-";
        public static final String BLOB_APPEND_OFFSET = "x-ms-blob-append-offset";
        public static final String BLOB_COMMITTED_BLOCK_COUNT = "x-ms-blob-committed-block-count";
        public static final String BLOB_SEQUENCE_NUMBER = "x-ms-blob-sequence-number";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CACHE_CONTROL_HEADER = "x-ms-blob-cache-control";
        public static final String CLIENT_REQUEST_ID_HEADER = "x-ms-client-request-id";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COPY_ACTION_ABORT = "abort";
        public static final String COPY_ACTION_HEADER = "x-ms-copy-action";
        public static final String COPY_COMPLETION_TIME = "x-ms-copy-completion-time";
        public static final String COPY_ID = "x-ms-copy-id";
        public static final String COPY_PROGRESS = "x-ms-copy-progress";
        public static final String COPY_SOURCE = "x-ms-copy-source";
        public static final String COPY_SOURCE_HEADER = "x-ms-copy-source";
        public static final String COPY_STATUS = "x-ms-copy-status";
        public static final String COPY_STATUS_DESCRIPTION = "x-ms-copy-status-description";
        public static final String INCREMENTAL_COPY = "x-ms-incremental-copy";
        public static final String COPY_DESTINATION_SNAPSHOT_ID = "x-ms-copy-destination-snapshot";
        public static final String DATE = "x-ms-date";
        public static final String DELETE_SNAPSHOT_HEADER = "x-ms-delete-snapshots";
        public static final String ETAG = "ETag";
        public static final int HTTP_UNUSED_306 = 306;
        public static final String IF_APPEND_POSITION_EQUAL_HEADER = "x-ms-blob-condition-appendpos";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MAX_SIZE_LESS_THAN_OR_EQUAL = "x-ms-blob-condition-maxsize";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String IF_SEQUENCE_NUMBER_LESS_THAN_OR_EQUAL = "x-ms-if-sequence-number-le";
        public static final String IF_SEQUENCE_NUMBER_LESS_THAN = "x-ms-if-sequence-number-lt";
        public static final String IF_SEQUENCE_NUMBER_EQUAL = "x-ms-if-sequence-number-eq";
        public static final String LEASE_ACTION_HEADER = "x-ms-lease-action";
        public static final String LEASE_BREAK_PERIOD_HEADER = "x-ms-lease-break-period";
        public static final String LEASE_DURATION = "x-ms-lease-duration";
        public static final String LEASE_ID_HEADER = "x-ms-lease-id";
        public static final String LEASE_STATE = "x-ms-lease-state";
        public static final String LEASE_STATUS = "x-ms-lease-status";
        public static final String LEASE_TIME_HEADER = "x-ms-lease-time";
        public static final String POP_RECEIPT_HEADER = "x-ms-popreceipt";
        public static final String PREFIX_FOR_STORAGE_METADATA = "x-ms-meta-";
        public static final String PREFIX_FOR_STORAGE_PROPERTIES = "x-ms-prop-";
        public static final String PROPOSED_LEASE_ID_HEADER = "x-ms-proposed-lease-id";
        public static final String RANGE = "Range";
        public static final String RANGE_GET_CONTENT_MD5 = "x-ms-range-get-content-md5";
        public static final String RANGE_HEADER_FORMAT = "bytes=%d-%d";
        public static final String REQUEST_ID_HEADER = "x-ms-request-id";
        public static final String SERVER = "Server";
        public static final String SERVER_ENCRYPTED = "x-ms-server-encrypted";
        public static final String SERVER_REQUEST_ENCRYPTED = "x-ms-request-server-encrypted";
        public static final String SNAPSHOT_ID_HEADER = "x-ms-snapshot";
        public static final String SOURCE_IF_MATCH_HEADER = "x-ms-source-if-match";
        public static final String SOURCE_IF_MODIFIED_SINCE_HEADER = "x-ms-source-if-modified-since";
        public static final String SOURCE_IF_NONE_MATCH_HEADER = "x-ms-source-if-none-match";
        public static final String SOURCE_IF_UNMODIFIED_SINCE_HEADER = "x-ms-source-if-unmodified-since";
        public static final String SOURCE_LEASE_ID_HEADER = "x-ms-source-lease-id";
        public static final String STORAGE_RANGE_HEADER = "x-ms-range";
        public static final String STORAGE_VERSION_HEADER = "x-ms-version";
        public static final String TARGET_STORAGE_VERSION = "2016-05-31";
        public static final String TIME_NEXT_VISIBLE_HEADER = "x-ms-time-next-visible";
        public static final String USER_AGENT = "User-Agent";
        public static final String USER_AGENT_PREFIX = "Azure-Storage";
        public static final String USER_AGENT_VERSION = "5.0.0";
        public static final String XML_TYPE = "application/xml";
    }

    public static class EncryptionConstants {
        public static final String BLOB_ENCRYPTION_DATA = "encryptiondata";
        public static final String ENCRYPTION_PROTOCOL_V1 = "1.0";
        public static final String KEY_WRAPPING_IV = "KeyWrappingIV";
        public static final String TABLE_ENCRYPTION_KEY_DETAILS = "_ClientEncryptionMetadata1";
        public static final String TABLE_ENCRYPTION_PROPERTY_DETAILS = "_ClientEncryptionMetadata2";
        public static final String ENCRYPTION_MODE = "EncryptionMode";
        public static final String FULL_BLOB = "FullBlob";
        public static final String WRAPPED_CONTENT_KEY = "WrappedContentKey";
        public static final String ENCRYPTION_AGENT = "EncryptionAgent";
        public static final String CONTENT_ENCRYPTION_IV = "ContentEncryptionIV";
        public static final String KEY_WRAPPING_METADATA = "KeyWrappingMetadata";
        public static final String ENCRYPTION_LIBRARY = "EncryptionLibrary";
    }

    public static class AnalyticsConstants {
        public static final String ALLOWED_HEADERS_ELEMENT = "AllowedHeaders";
        public static final String ALLOWED_METHODS_ELEMENT = "AllowedMethods";
        public static final String ALLOWED_ORIGINS_ELEMENT = "AllowedOrigins";
        public static final String CORS_ELEMENT = "Cors";
        public static final String CORS_RULE_ELEMENT = "CorsRule";
        public static final String DAYS_ELEMENT = "Days";
        public static final String DEFAULT_SERVICE_VERSION = "DefaultServiceVersion";
        public static final String DELETE_ELEMENT = "Delete";
        public static final String ENABLED_ELEMENT = "Enabled";
        public static final String EXPOSED_HEADERS_ELEMENT = "ExposedHeaders";
        public static final String HOUR_METRICS_ELEMENT = "HourMetrics";
        public static final String INCLUDE_APIS_ELEMENT = "IncludeAPIs";
        public static final String LOGS_CONTAINER = "$logs";
        public static final String LOGGING_ELEMENT = "Logging";
        public static final String MAX_AGE_IN_SECONDS_ELEMENT = "MaxAgeInSeconds";
        public static final String METRICS_CAPACITY_BLOB = "$MetricsCapacityBlob";
        public static final String METRICS_HOUR_PRIMARY_TRANSACTIONS_BLOB = "$MetricsHourPrimaryTransactionsBlob";
        public static final String METRICS_HOUR_PRIMARY_TRANSACTIONS_FILE = "$MetricsHourPrimaryTransactionsFile";
        public static final String METRICS_HOUR_PRIMARY_TRANSACTIONS_TABLE = "$MetricsHourPrimaryTransactionsTable";
        public static final String METRICS_HOUR_PRIMARY_TRANSACTIONS_QUEUE = "$MetricsHourPrimaryTransactionsQueue";
        public static final String METRICS_MINUTE_PRIMARY_TRANSACTIONS_BLOB = "$MetricsMinutePrimaryTransactionsBlob";
        public static final String METRICS_MINUTE_PRIMARY_TRANSACTIONS_FILE = "$MetricsMinutePrimaryTransactionsFile";
        public static final String METRICS_MINUTE_PRIMARY_TRANSACTIONS_TABLE = "$MetricsMinutePrimaryTransactionsTable";
        public static final String METRICS_MINUTE_PRIMARY_TRANSACTIONS_QUEUE = "$MetricsMinutePrimaryTransactionsQueue";
        public static final String METRICS_HOUR_SECONDARY_TRANSACTIONS_BLOB = "$MetricsHourSecondaryTransactionsBlob";
        public static final String METRICS_HOUR_SECONDARY_TRANSACTIONS_FILE = "$MetricsHourSecondaryTransactionsFile";
        public static final String METRICS_HOUR_SECONDARY_TRANSACTIONS_TABLE = "$MetricsHourSecondaryTransactionsTable";
        public static final String METRICS_HOUR_SECONDARY_TRANSACTIONS_QUEUE = "$MetricsHourSecondaryTransactionsQueue";
        public static final String METRICS_MINUTE_SECONDARY_TRANSACTIONS_BLOB = "$MetricsMinuteSecondaryTransactionsBlob";
        public static final String METRICS_MINUTE_SECONDARY_TRANSACTIONS_FILE = "$MetricsMinuteSecondaryTransactionsFile";
        public static final String METRICS_MINUTE_SECONDARY_TRANSACTIONS_TABLE = "$MetricsMinuteSecondaryTransactionsTable";
        public static final String METRICS_MINUTE_SECONDARY_TRANSACTIONS_QUEUE = "$MetricsMinuteSecondaryTransactionsQueue";
        public static final String MINUTE_METRICS_ELEMENT = "MinuteMetrics";
        public static final String READ_ELEMENT = "Read";
        public static final String RETENTION_POLICY_ELEMENT = "RetentionPolicy";
        public static final String STORAGE_SERVICE_PROPERTIES_ELEMENT = "StorageServiceProperties";
        public static final String STORAGE_SERVICE_STATS = "StorageServiceStats";
        public static final String VERSION_ELEMENT = "Version";
        public static final String WRITE_ELEMENT = "Write";
    }
}

