/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;

public class EncryptionProvider {
    private static final String AES = "AES";
    private static final String FILE_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_CIPHER = "AES/ECB/PKCS5Padding";
    private static final int BUFFER_SIZE = 0x200000;
    private static SecureRandom secRnd;

    public static InputStream decryptStream(InputStream inputStream, String keyBase64, String ivBase64, RemoteStoreFileEncryptionMaterial encMat) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        byte[] decodedKey = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
        byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
        byte[] ivBytes = Base64.getDecoder().decode(ivBase64);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, AES);
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, decodedKey.length, AES);
        Cipher dataCipher = Cipher.getInstance(FILE_CIPHER);
        IvParameterSpec ivy = new IvParameterSpec(ivBytes);
        dataCipher.init(2, (Key)fileKey, ivy);
        return new CipherInputStream(inputStream, dataCipher);
    }

    public static void decrypt(File file, String keyBase64, String ivBase64, RemoteStoreFileEncryptionMaterial encMat) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
        byte[] ivBytes = Base64.getDecoder().decode(ivBase64);
        byte[] qsmkBytes = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(qsmkBytes, 0, qsmkBytes.length, AES);
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, AES);
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        byte[] buffer = new byte[0x200000];
        fileCipher.init(2, (Key)fileKey, iv);
        long totalBytesRead = 0L;
        try (InputStream is = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
             CipherInputStream cis = new CipherInputStream(is, fileCipher);
             OutputStream os = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE);){
            int bytesRead;
            while ((bytesRead = ((InputStream)cis).read(buffer)) > -1) {
                os.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
        }
        try (FileChannel fc = new FileOutputStream(file, true).getChannel();){
            fc.truncate(totalBytesRead);
        }
    }

    public static CipherInputStream encrypt(StorageObjectMetadata meta, long originalContentLength, InputStream src, RemoteStoreFileEncryptionMaterial encMat, SnowflakeStorageClient client) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, FileNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] decodedKey = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(FILE_CIPHER);
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        EncryptionProvider.getSecRnd().nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        EncryptionProvider.getSecRnd().nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, AES);
        fileCipher.init(1, (Key)fileKey, iv);
        CipherInputStream cis = new CipherInputStream(src, fileCipher);
        Cipher keyCipher = Cipher.getInstance(KEY_CIPHER);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, AES);
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(encMat.getSmkId(), encMat.getQueryId(), keySize * 8);
        long contentLength = (originalContentLength + (long)blockSz) / (long)blockSz * (long)blockSz;
        client.addEncryptionMetadata(meta, matDesc, ivData, encKeK, contentLength);
        return cis;
    }

    private static synchronized SecureRandom getSecRnd() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (secRnd == null) {
            secRnd = SecureRandom.getInstance("SHA1PRNG");
            byte[] bytes = new byte[10];
            secRnd.nextBytes(bytes);
        }
        return secRnd;
    }
}

