/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.loader.BufferStage;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class LoadingError {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(LoadingError.class);
    private String _stage;
    private String _prefix;
    private String _file;
    private final String _target;
    private final Map<ErrorProperty, String> _properties = new HashMap<ErrorProperty, String>();
    public static String UNKNOWN = "unknown";

    public LoadingError(ResultSet rs, BufferStage bs, StreamLoader loader) {
        this._stage = bs.getRemoteLocation();
        try {
            String ffile = rs.getString("FILE");
            this._file = ffile.substring(ffile.lastIndexOf("/"));
            this._prefix = ffile.substring(0, ffile.lastIndexOf("/"));
        }
        catch (SQLException ex) {
            this._file = UNKNOWN;
        }
        this._target = loader.getTable();
        for (ErrorProperty p : ErrorProperty.values()) {
            try {
                this._properties.put(p, rs.getString(p.name()));
            }
            catch (SQLException ex) {
                LOGGER.error("Exception", ex);
            }
        }
    }

    public String getStage() {
        return this._stage;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getFile() {
        return this._file;
    }

    public String getTarget() {
        return this._target;
    }

    public String getProperty(ErrorProperty p) {
        return this._properties.get((Object)p);
    }

    public void setProperty(ErrorProperty p, String value) {
        this._properties.put(p, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String prefix = "";
        for (ErrorProperty p : ErrorProperty.values()) {
            sb.append(prefix);
            sb.append("\"").append(p.name()).append("\": ");
            sb.append("\"");
            String value = String.valueOf(this._properties.get((Object)p));
            sb.append(value.replaceAll("[\\s]+", " ").replace("\"", "\\\""));
            sb.append("\"");
            prefix = ",";
        }
        sb.append("}");
        return sb.toString();
    }

    public Loader.DataError getException() {
        return new Loader.DataError(this.toString());
    }

    public static enum ErrorProperty {
        ERROR,
        LINE,
        CHARACTER,
        BYTE_OFFSET,
        CATEGORY,
        CODE,
        SQL_STATE,
        COLUMN_NAME,
        ROW_NUMBER,
        ROW_START_LINE,
        REJECTED_RECORD;

    }
}

