/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.json.GoogleJsonError;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.cloud.BaseServiceException;
import net.snowflake.client.jdbc.internal.google.cloud.RetryHelper;
import net.snowflake.client.jdbc.internal.google.cloud.http.BaseHttpServiceException;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;

@InternalApi
public final class StorageException
extends BaseHttpServiceException {
    private static final String INTERNAL_ERROR = "internalError";
    private static final String CONNECTION_CLOSED_PREMATURELY = "connectionClosedPrematurely";
    static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of(new BaseServiceException.Error(504, null), new BaseServiceException.Error(503, null), new BaseServiceException.Error(502, null), new BaseServiceException.Error(500, null), new BaseServiceException.Error(429, null), new BaseServiceException.Error(408, null), new BaseServiceException.Error[]{new BaseServiceException.Error(null, "internalError"), new BaseServiceException.Error(null, "connectionClosedPrematurely")});
    private static final long serialVersionUID = -4168430271327813063L;

    public StorageException(int code, String message) {
        this(code, message, null);
    }

    public StorageException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
    }

    public StorageException(GoogleJsonError error) {
        super(error, true, RETRYABLE_ERRORS);
    }

    public static StorageException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate(ex);
        throw StorageException.getStorageException(ex);
    }

    private static StorageException getStorageException(Throwable t2) {
        return new StorageException(0, t2.getMessage(), t2.getCause());
    }

    static BaseServiceException coalesce(Throwable t2) {
        if (t2 instanceof BaseServiceException) {
            return (BaseServiceException)t2;
        }
        if (t2.getCause() instanceof BaseServiceException) {
            return (BaseServiceException)t2.getCause();
        }
        return StorageException.getStorageException(t2);
    }

    public static StorageException translate(IOException exception) {
        if (exception.getMessage().contains("Connection closed prematurely")) {
            return new StorageException(0, exception.getMessage(), CONNECTION_CLOSED_PREMATURELY, exception);
        }
        return new StorageException(exception);
    }
}

