/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.ComplexCopier;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BaseWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.UnionHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;

public class UnionListReader
extends AbstractFieldReader {
    private ListVector vector;
    private ValueVector data;
    private static final int OFFSET_WIDTH = 4;
    private int currentOffset;
    private int maxOffset;

    public UnionListReader(ListVector vector) {
        this.vector = vector;
        this.data = vector.getDataVector();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.isNull(this.idx());
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        if (this.vector.getOffsetBuffer().capacity() == 0L) {
            this.currentOffset = 0;
            this.maxOffset = 0;
        } else {
            this.currentOffset = this.vector.getOffsetBuffer().getInt(index * 4) - 1;
            this.maxOffset = this.vector.getOffsetBuffer().getInt((index + 1) * 4);
        }
    }

    @Override
    public FieldReader reader() {
        return this.data.getReader();
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LIST;
    }

    @Override
    public void read(int index, UnionHolder holder) {
        this.setPosition(this.idx());
        for (int i = -1; i < index; ++i) {
            this.next();
        }
        holder.reader = this.data.getReader();
        holder.isSet = this.data.getReader().isSet() ? 1 : 0;
    }

    @Override
    public int size() {
        int size = this.maxOffset - this.currentOffset - 1;
        return size < 0 ? 0 : size;
    }

    @Override
    public boolean next() {
        if (this.currentOffset + 1 < this.maxOffset) {
            this.data.getReader().setPosition(++this.currentOffset);
            return true;
        }
        return false;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        ComplexCopier.copy(this, (FieldWriter)writer);
    }
}

