/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;

public enum SFBinaryFormat {
    HEX{

        @Override
        public String format(SFBinary binary) {
            return binary.toHex();
        }

        @Override
        public SFBinary parse(String string) {
            return SFBinary.fromHex(string);
        }
    }
    ,
    BASE64{

        @Override
        public String format(SFBinary binary) {
            return binary.toBase64();
        }

        @Override
        public SFBinary parse(String string) {
            return SFBinary.fromBase64(string);
        }
    }
    ,
    UTF8{

        @Override
        public String format(SFBinary binary) {
            CharBuffer buf;
            try {
                buf = UTF8_DECODER.decode(ByteBuffer.wrap(binary.getBytes()));
            }
            catch (CharacterCodingException ex) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            return buf.toString();
        }

        @Override
        public SFBinary parse(String string) {
            return new SFBinary(string.getBytes(StandardCharsets.UTF_8));
        }
    };

    public static final SFBinaryFormat DEFAULT;
    private static final CharsetDecoder UTF8_DECODER;

    public abstract String format(SFBinary var1);

    public abstract SFBinary parse(String var1);

    public static SFBinaryFormat getFormat(String name) {
        try {
            return SFBinaryFormat.lookup(name);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Must be 'HEX', 'BASE64', or 'UTF-8'");
        }
    }

    public static SFBinaryFormat getSafeOutputFormat(String name) {
        try {
            SFBinaryFormat fmt = SFBinaryFormat.lookup(name);
            if (fmt == UTF8) {
                throw new IllegalArgumentException();
            }
            return fmt;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Must be 'HEX' or 'BASE64'");
        }
    }

    private static SFBinaryFormat lookup(String name) {
        if ((name = name.toUpperCase()).equals("UTF-8")) {
            return UTF8;
        }
        return SFBinaryFormat.valueOf(name);
    }

    static {
        DEFAULT = HEX;
        UTF8_DECODER = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }
}

