/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFResultSetMetaData {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFResultSetMetaData.class);
    private int columnCount = 0;
    private List<String> columnNames;
    private List<String> columnTypeNames;
    private List<Integer> columnTypes;
    private List<Integer> precisions;
    private List<Integer> scales;
    private List<Integer> nullables;
    private List<String> columnSrcTables;
    private List<String> columnSrcSchemas;
    private List<String> columnSrcDatabases;
    private List<Integer> columnDisplaySizes;
    private String queryId;
    private Map<String, Integer> columnNamePositionMap = new HashMap<String, Integer>();
    private Map<String, Integer> columnNameUpperCasePositionMap = new HashMap<String, Integer>();
    private SFBaseSession session;
    private SnowflakeDateTimeFormat timestampNTZFormatter;
    private SnowflakeDateTimeFormat timestampLTZFormatter;
    private SnowflakeDateTimeFormat timestampTZFormatter;
    private SnowflakeDateTimeFormat timeFormatter;
    private SnowflakeDateTimeFormat dateFormatter;
    private int timestampNTZStringLength = 30;
    private int timestampLTZStringLength = 30;
    private int timestampTZStringLength = 30;
    private int timeStringLength = 18;
    private int dateStringLength = 10;
    private boolean isResultColumnCaseInsensitive = false;

    public SFResultSetMetaData(int columnCount, List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, SFBaseSession session) {
        this.columnCount = columnCount;
        this.columnNames = columnNames;
        this.columnTypeNames = columnTypeNames;
        this.columnTypes = columnTypes;
        this.session = session;
    }

    public SFResultSetMetaData(List<SnowflakeColumnMetadata> columnMetadata, SFBaseSession session, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SnowflakeDateTimeFormat dateFormatter, SnowflakeDateTimeFormat timeFormatter) {
        this(columnMetadata, "none", session, session != null && session.isResultColumnCaseInsensitive(), timestampNTZFormatter, timestampLTZFormatter, timestampTZFormatter, dateFormatter, timeFormatter);
    }

    public SFResultSetMetaData(List<SnowflakeColumnMetadata> columnMetadata, String queryId, SFBaseSession session, boolean isResultColumnCaseInsensitive, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SnowflakeDateTimeFormat dateFormatter, SnowflakeDateTimeFormat timeFormatter) {
        this.columnCount = columnMetadata.size();
        this.queryId = queryId;
        this.timestampNTZFormatter = timestampNTZFormatter;
        this.timestampLTZFormatter = timestampLTZFormatter;
        this.timestampTZFormatter = timestampTZFormatter;
        this.dateFormatter = dateFormatter;
        this.timeFormatter = timeFormatter;
        this.calculateDateTimeStringLength();
        this.columnNames = new ArrayList<String>(this.columnCount);
        this.columnTypeNames = new ArrayList<String>(this.columnCount);
        this.columnTypes = new ArrayList<Integer>(this.columnCount);
        this.precisions = new ArrayList<Integer>(this.columnCount);
        this.scales = new ArrayList<Integer>(this.columnCount);
        this.nullables = new ArrayList<Integer>(this.columnCount);
        this.columnSrcDatabases = new ArrayList<String>(this.columnCount);
        this.columnSrcSchemas = new ArrayList<String>(this.columnCount);
        this.columnSrcTables = new ArrayList<String>(this.columnCount);
        this.columnDisplaySizes = new ArrayList<Integer>(this.columnCount);
        this.isResultColumnCaseInsensitive = isResultColumnCaseInsensitive;
        for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
            this.columnNames.add(columnMetadata.get(colIdx).getName());
            this.columnTypeNames.add(columnMetadata.get(colIdx).getTypeName());
            this.precisions.add(this.calculatePrecision(columnMetadata.get(colIdx)));
            this.columnTypes.add(columnMetadata.get(colIdx).getType());
            this.scales.add(columnMetadata.get(colIdx).getScale());
            this.nullables.add(columnMetadata.get(colIdx).isNullable() ? 1 : 0);
            this.columnSrcDatabases.add(columnMetadata.get(colIdx).getColumnSrcDatabase());
            this.columnSrcSchemas.add(columnMetadata.get(colIdx).getColumnSrcSchema());
            this.columnSrcTables.add(columnMetadata.get(colIdx).getColumnSrcTable());
            this.columnDisplaySizes.add(this.calculateDisplaySize(columnMetadata.get(colIdx)));
        }
        this.session = session;
    }

    private Integer calculatePrecision(SnowflakeColumnMetadata columnMetadata) {
        int columnType = columnMetadata.getType();
        switch (columnType) {
            case -2: 
            case 1: 
            case 12: {
                return columnMetadata.getLength();
            }
            case -5: 
            case 3: 
            case 4: {
                return columnMetadata.getPrecision();
            }
            case 91: {
                return this.dateStringLength;
            }
            case 92: {
                return this.timeStringLength;
            }
            case 50000: {
                return this.timestampLTZStringLength;
            }
            case 50001: {
                return this.timestampTZStringLength;
            }
            case 93: {
                return this.timestampNTZStringLength;
            }
        }
        return 0;
    }

    private Integer calculateDisplaySize(SnowflakeColumnMetadata columnMetadata) {
        int columnType = columnMetadata.getType();
        switch (columnType) {
            case -2: 
            case 1: 
            case 12: {
                return columnMetadata.getLength();
            }
            case -5: 
            case 4: {
                return columnMetadata.getPrecision() + 1;
            }
            case 3: {
                return columnMetadata.getPrecision() + 1 + 1;
            }
            case 8: {
                return 24;
            }
            case 91: {
                return this.dateStringLength;
            }
            case 92: {
                return this.timeStringLength;
            }
            case 50000: {
                return this.timestampLTZStringLength;
            }
            case 50001: {
                return this.timestampTZStringLength;
            }
            case 93: {
                return this.timestampNTZStringLength;
            }
            case 16: {
                return 5;
            }
        }
        return 25;
    }

    private void calculateDateTimeStringLength() {
        SFTimestamp ts = SFTimestamp.fromMilliseconds(System.currentTimeMillis(), TimeZone.getDefault());
        try {
            if (this.timestampNTZFormatter != null) {
                String tsNTZStr = ResultUtil.getSFTimestampAsString(ts, 93, 9, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                this.timestampNTZStringLength = tsNTZStr.length();
            }
            if (this.timestampLTZFormatter != null) {
                String tsLTZStr = ResultUtil.getSFTimestampAsString(ts, 50000, 9, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                this.timestampLTZStringLength = tsLTZStr.length();
            }
            if (this.timestampTZFormatter != null) {
                String tsTZStr = ResultUtil.getSFTimestampAsString(ts, 50001, 9, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                this.timestampTZStringLength = tsTZStr.length();
            }
            SFTime time = SFTime.fromTimestamp(ts);
            if (this.timeFormatter != null) {
                this.timeStringLength = ResultUtil.getSFTimeAsString(time, 9, this.timeFormatter).length();
            }
            if (this.dateFormatter != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(2015, 11, 11);
                this.dateStringLength = ResultUtil.getDateAsString(new Date(calendar.getTimeInMillis()), this.dateFormatter).length();
            }
        }
        catch (SFException e) {
            logger.debug("Failed to calculate the display size. Use default one.", false);
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public SFBaseSession getSession() {
        return this.session;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getColumnIndex(String columnName) {
        Map<String, Integer> nameToIndexMap;
        columnName = this.isResultColumnCaseInsensitive ? columnName.toUpperCase() : columnName;
        Map<String, Integer> map = nameToIndexMap = this.isResultColumnCaseInsensitive ? this.columnNameUpperCasePositionMap : this.columnNamePositionMap;
        if (nameToIndexMap.get(columnName) != null) {
            return nameToIndexMap.get(columnName);
        }
        int columnIndex = this.isResultColumnCaseInsensitive ? ResultUtil.listSearchCaseInsensitive(this.columnNames, columnName) : this.columnNames.indexOf(columnName);
        nameToIndexMap.put(columnName, columnIndex);
        return columnIndex;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnType(int column) throws SFException {
        int internalColumnType;
        int externalColumnType = internalColumnType = this.getInternalColumnType(column);
        if (internalColumnType == 50000) {
            externalColumnType = 93;
        }
        if (internalColumnType == 50001) {
            externalColumnType = this.session == null ? 2014 : (this.session.getEnableReturnTimestampWithTimeZone() ? 2014 : 93);
        }
        return externalColumnType;
    }

    public int getInternalColumnType(int column) throws SFException {
        int columnIdx = column - 1;
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, column);
        }
        if (this.columnTypes.get(columnIdx) == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Missing column type for column " + column);
        }
        return this.columnTypes.get(columnIdx);
    }

    public String getColumnTypeName(int column) throws SFException {
        if (column < 1 || column > this.columnTypeNames.size()) {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, column);
        }
        if (this.columnTypeNames.get(column - 1) == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Missing column type for column " + column);
        }
        return this.columnTypeNames.get(column - 1);
    }

    public int getScale(int column) {
        if (this.scales != null && this.scales.size() >= column) {
            return this.scales.get(column - 1);
        }
        return 9;
    }

    public int getPrecision(int column) {
        if (this.precisions != null && this.precisions.size() >= column) {
            return this.precisions.get(column - 1);
        }
        return 9;
    }

    public boolean isSigned(int column) {
        return this.columnTypes.get(column - 1) == 4 || this.columnTypes.get(column - 1) == 3 || this.columnTypes.get(column - 1) == -5 || this.columnTypes.get(column - 1) == 8;
    }

    public String getColumnLabel(int column) {
        if (this.columnNames != null) {
            return this.columnNames.get(column - 1);
        }
        return "C" + Integer.toString(column - 1);
    }

    public String getColumnName(int column) {
        if (this.columnNames != null) {
            return this.columnNames.get(column - 1);
        }
        return "C" + Integer.toString(column - 1);
    }

    public int isNullable(int column) {
        if (this.nullables != null) {
            return this.nullables.get(column - 1);
        }
        return 2;
    }

    public String getCatalogName(int column) {
        if (this.columnSrcDatabases == null) {
            return "";
        }
        return this.columnSrcDatabases.get(column - 1);
    }

    public String getSchemaName(int column) {
        if (this.columnSrcDatabases == null) {
            return "";
        }
        return this.columnSrcSchemas.get(column - 1);
    }

    public String getTableName(int column) {
        if (this.columnSrcDatabases == null) {
            return "T";
        }
        return this.columnSrcTables.get(column - 1);
    }

    public Integer getColumnDisplaySize(int column) {
        if (this.columnDisplaySizes == null) {
            return 25;
        }
        return this.columnDisplaySizes.get(column - 1);
    }
}

