/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.snowflake.ingest.internal.slf4j.Logger;
import net.snowflake.ingest.internal.slf4j.LoggerFactory;

public class RingBuffer<E>
extends AbstractCollection<E>
implements Queue<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingBuffer.class.getName());
    private final E[] buffer;
    private int capacity;
    private int readIdx;
    private int writeIdx;
    private int occupied;

    public RingBuffer(int capacity) {
        LOGGER.info("Constructing RingBuffer with capacity {}", (Object)capacity);
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[capacity];
        this.capacity = capacity;
        this.readIdx = 0;
        this.writeIdx = 0;
        this.occupied = 0;
    }

    private int getNextIndex(int index) {
        return (index + 1) % this.capacity;
    }

    @Override
    public boolean offer(E obj) {
        if (this.capacity == this.occupied) {
            return false;
        }
        this.buffer[this.writeIdx] = obj;
        this.writeIdx = this.getNextIndex(this.writeIdx);
        ++this.occupied;
        return true;
    }

    @Override
    public boolean add(E obj) {
        if (this.capacity == this.occupied) {
            throw new IllegalStateException();
        }
        this.buffer[this.writeIdx] = obj;
        this.writeIdx = this.getNextIndex(this.writeIdx);
        ++this.occupied;
        return true;
    }

    @Override
    public E peek() {
        if (this.occupied == 0) {
            return null;
        }
        return this.buffer[this.readIdx];
    }

    @Override
    public E element() {
        if (this.occupied == 0) {
            throw new IllegalStateException();
        }
        return this.buffer[this.readIdx];
    }

    @Override
    public E remove() {
        if (this.occupied == 0) {
            throw new NoSuchElementException();
        }
        E ret = this.peek();
        this.readIdx = this.getNextIndex(this.readIdx);
        --this.occupied;
        return ret;
    }

    @Override
    public E poll() {
        if (this.occupied == 0) {
            return null;
        }
        E ret = this.peek();
        this.readIdx = this.getNextIndex(this.readIdx);
        --this.occupied;
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.occupied == 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.occupied;
    }

    @Override
    public void clear() {
        this.readIdx = 0;
        this.writeIdx = 0;
        this.occupied = 0;
        Arrays.fill(this.buffer, null);
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.occupied];
        int needle = this.readIdx;
        for (int i = 0; i < this.occupied; ++i) {
            ret[i] = this.buffer[needle];
            needle = this.getNextIndex(needle);
        }
        return ret;
    }

    @Override
    public boolean contains(Object obj) {
        int needle = this.readIdx;
        for (int i = 0; i < this.occupied; ++i) {
            if (obj == null && this.buffer[needle] == null) {
                return true;
            }
            if (obj != null && this.buffer[needle] != null && obj.equals(this.buffer[needle])) {
                return true;
            }
            needle = this.getNextIndex(needle);
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIterator(this);
    }

    private class RingIterator
    implements Iterator<E> {
        private int usedElems = 0;
        RingBuffer<E> ringBuffer;
        private int idx;

        RingIterator(RingBuffer<E> buffer) {
            this.ringBuffer = buffer;
            this.idx = buffer.readIdx;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.usedElems < this.ringBuffer.occupied;
        }

        @Override
        public E next() {
            if (this.usedElems >= this.ringBuffer.occupied) {
                throw new NoSuchElementException();
            }
            Object ret = this.ringBuffer.buffer[this.idx];
            ++this.usedElems;
            this.idx = this.ringBuffer.getNextIndex(this.idx);
            return ret;
        }
    }
}

