/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.jose4j.jwe;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.ingest.internal.jose4j.jca.ProviderContext;
import net.snowflake.ingest.internal.jose4j.jwa.AlgorithmInfo;
import net.snowflake.ingest.internal.jose4j.jwe.CipherUtil;
import net.snowflake.ingest.internal.jose4j.jwe.ContentEncryptionKeyDescriptor;
import net.snowflake.ingest.internal.jose4j.jwe.ContentEncryptionKeys;
import net.snowflake.ingest.internal.jose4j.jwe.JsonWebEncryption;
import net.snowflake.ingest.internal.jose4j.jwe.KeyManagementAlgorithm;
import net.snowflake.ingest.internal.jose4j.jwx.Headers;
import net.snowflake.ingest.internal.jose4j.lang.ByteUtil;
import net.snowflake.ingest.internal.jose4j.lang.ExceptionHelp;
import net.snowflake.ingest.internal.jose4j.lang.JoseException;
import net.snowflake.ingest.internal.slf4j.Logger;
import net.snowflake.ingest.internal.slf4j.LoggerFactory;

public abstract class WrappingKeyManagementAlgorithm
extends AlgorithmInfo
implements KeyManagementAlgorithm {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private AlgorithmParameterSpec algorithmParameterSpec;
    protected boolean useSuppliedKeyProviderContext = true;

    public WrappingKeyManagementAlgorithm(String javaAlg, String alg) {
        this.setJavaAlgorithm(javaAlg);
        this.setAlgorithmIdentifier(alg);
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public ContentEncryptionKeys manageForEncrypt(Key managementKey, ContentEncryptionKeyDescriptor cekDesc, Headers headers, byte[] cekOverride, ProviderContext providerContext) throws JoseException {
        byte[] contentEncryptionKey = cekOverride == null ? ByteUtil.randomBytes(cekDesc.getContentEncryptionKeyByteLength()) : cekOverride;
        return this.manageForEnc(managementKey, cekDesc, contentEncryptionKey, providerContext);
    }

    protected ContentEncryptionKeys manageForEnc(Key managementKey, ContentEncryptionKeyDescriptor cekDesc, byte[] contentEncryptionKey, ProviderContext providerContext) throws JoseException {
        ProviderContext.Context ctx = this.useSuppliedKeyProviderContext ? providerContext.getSuppliedKeyProviderContext() : providerContext.getGeneralProviderContext();
        String provider = ctx.getCipherProvider();
        Cipher cipher = CipherUtil.getCipher(this.getJavaAlgorithm(), provider);
        try {
            this.initCipher(cipher, 3, managementKey);
            String contentEncryptionKeyAlgorithm = cekDesc.getContentEncryptionKeyAlgorithm();
            byte[] encryptedKey = cipher.wrap(new SecretKeySpec(contentEncryptionKey, contentEncryptionKeyAlgorithm));
            return new ContentEncryptionKeys(contentEncryptionKey, encryptedKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | IllegalBlockSizeException e) {
            throw new JoseException("Unable to encrypt the Content Encryption Key: " + e, e);
        }
    }

    void initCipher(Cipher cipher, int mode, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.algorithmParameterSpec == null) {
            cipher.init(mode, key);
        } else {
            cipher.init(mode, key, this.algorithmParameterSpec);
        }
    }

    @Override
    public Key manageForDecrypt(Key managementKey, byte[] encryptedKey, ContentEncryptionKeyDescriptor cekDesc, Headers headers, ProviderContext providerContext) throws JoseException {
        String provider = providerContext.getSuppliedKeyProviderContext().getCipherProvider();
        Cipher cipher = CipherUtil.getCipher(this.getJavaAlgorithm(), provider);
        try {
            this.initCipher(cipher, 4, managementKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new JoseException("Unable to initialize cipher for key decryption", e);
        }
        String cekAlg = cekDesc.getContentEncryptionKeyAlgorithm();
        try {
            return cipher.unwrap(encryptedKey, cekAlg, 3);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                String flatStack = ExceptionHelp.toStringWithCausesAndAbbreviatedStack(e, JsonWebEncryption.class);
                this.log.debug("Key unwrap failed. Substituting a randomly generated CEK and proceeding. {}", (Object)flatStack);
            }
            byte[] bytes = ByteUtil.randomBytes(cekDesc.getContentEncryptionKeyByteLength());
            return new SecretKeySpec(bytes, cekAlg);
        }
    }
}

