/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.cookie;

import net.snowflake.ingest.internal.apache.http.annotation.Immutable;
import net.snowflake.ingest.internal.apache.http.cookie.ClientCookie;
import net.snowflake.ingest.internal.apache.http.cookie.CommonCookieAttributeHandler;
import net.snowflake.ingest.internal.apache.http.cookie.Cookie;
import net.snowflake.ingest.internal.apache.http.cookie.CookieOrigin;
import net.snowflake.ingest.internal.apache.http.cookie.CookieRestrictionViolationException;
import net.snowflake.ingest.internal.apache.http.cookie.MalformedCookieException;
import net.snowflake.ingest.internal.apache.http.cookie.SetCookie;
import net.snowflake.ingest.internal.apache.http.cookie.SetCookie2;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

