/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

public enum IngestStatus {
    LOAD_IN_PROGRESS(1, "Load in progress"),
    LOADED(2, "Loaded"),
    LOAD_FAILED(3, "Load failed"),
    PARTIALLY_LOADED(4, "Partially loaded");

    private final int statusId;
    private final String statusDesc;

    private IngestStatus(int statusId, String statusDesc) {
        this.statusId = statusId;
        this.statusDesc = statusDesc;
    }

    private IngestStatus(String statusDesc) throws Exception {
        IngestStatus tmp = IngestStatus.lookupByName(statusDesc);
        this.statusId = tmp.statusId;
        this.statusDesc = tmp.statusDesc;
    }

    public int getId() {
        return this.statusId;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public static IngestStatus findByStatusId(int statusId) {
        for (IngestStatus status : IngestStatus.values()) {
            if (status.statusId != statusId) continue;
            return status;
        }
        return null;
    }

    public static IngestStatus lookupByName(String name) throws Exception {
        if (name == null) {
            return null;
        }
        return IngestStatus.valueOf(name.toUpperCase());
    }

    static boolean isSuccess(int id) {
        return id == LOADED.getId() || id == PARTIALLY_LOADED.getId();
    }

    static boolean isSuccess(IngestStatus status) {
        return IngestStatus.isSuccess(status.getId());
    }
}

