/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ByteArrayInputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBIncorrectXidException;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBStandAloneConnectionManager;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
FirebirdConnectionProperties {
    private static final Logger log = LoggerFactory.getLogger(FBManagedConnectionFactory.class, false);
    private static final Map mcfInstances = new WeakHashMap();
    private ConnectionManager defaultCm;
    private int hashCode;
    private GDSType gdsType;
    private final transient Map xidMap = Collections.synchronizedMap(new HashMap());
    private final transient Object startLock = new Object();
    private transient boolean started = false;
    private FBConnectionProperties connectionProperties;
    private static final String RECOVERY_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE = 1";

    public FBManagedConnectionFactory() {
        this(GDSFactory.getDefaultGDSType(), new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType) {
        this(gdsType, new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType, FBConnectionProperties connectionProperties) {
        this.defaultCm = new FBStandAloneConnectionManager();
        this.connectionProperties = connectionProperties;
        this.setType(gdsType.toString());
    }

    public GDS getGDS() {
        return GDSFactory.getGDSForType(this.getGDSType());
    }

    public GDSType getGDSType() {
        if (this.gdsType != null) {
            return this.gdsType;
        }
        this.gdsType = GDSType.getType(this.getType());
        return this.gdsType;
    }

    public int getBlobBufferLength() {
        return this.getBlobBufferSize();
    }

    public void setBlobBufferLength(int value) {
        this.setBlobBufferSize(value);
    }

    public Integer getTransactionIsolation() {
        return new Integer(this.getDefaultTransactionIsolation());
    }

    public void setTransactionIsolation(Integer value) {
        if (value != null) {
            this.setDefaultTransactionIsolation(value);
        }
    }

    public String getTransactionIsolationName() {
        return this.getDefaultIsolation();
    }

    public void setTransactionIsolationName(String name) {
        this.setDefaultIsolation(name);
    }

    public String getLocalEncoding() {
        return this.getCharSet();
    }

    public void setLocalEncoding(String localEncoding) {
        this.setCharSet(localEncoding);
    }

    @Override
    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    @Override
    public int getBuffersNumber() {
        return this.connectionProperties.getBuffersNumber();
    }

    @Override
    public String getCharSet() {
        return this.connectionProperties.getCharSet();
    }

    @Override
    public String getDatabase() {
        return this.connectionProperties.getDatabase();
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    @Override
    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    @Override
    public String getEncoding() {
        return this.connectionProperties.getEncoding();
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    @Override
    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    @Override
    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    @Override
    public int getSocketBufferSize() {
        return this.connectionProperties.getSocketBufferSize();
    }

    @Override
    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    @Override
    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    @Override
    public String getType() {
        return this.connectionProperties.getType();
    }

    @Override
    public String getUserName() {
        return this.connectionProperties.getUserName();
    }

    @Override
    public String getUseTranslation() {
        return this.connectionProperties.getUseTranslation();
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    @Override
    public void setBlobBufferSize(int bufferSize) {
        this.connectionProperties.setBlobBufferSize(bufferSize);
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    @Override
    public void setCharSet(String charSet) {
        this.connectionProperties.setCharSet(charSet);
    }

    @Override
    public void setDatabase(String database) {
        this.connectionProperties.setDatabase(database);
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    @Override
    public void setEncoding(String encoding) {
        this.connectionProperties.setEncoding(encoding);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    @Override
    public void setPassword(String password) {
        this.connectionProperties.setPassword(password);
    }

    @Override
    public void setRoleName(String roleName) {
        this.connectionProperties.setRoleName(roleName);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setType(String type) {
        if (this.gdsType != null) {
            throw new IllegalStateException("Cannot change GDS type at runtime.");
        }
        this.connectionProperties.setType(type);
    }

    @Override
    public void setUserName(String userName) {
        this.connectionProperties.setUserName(userName);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    @Override
    public void setUseTranslation(String translationPath) {
        this.connectionProperties.setUseTranslation(translationPath);
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    public void setDefaultConnectionManager(ConnectionManager defaultCm) {
        this.defaultCm = defaultCm;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 17;
        if ((result = 37 * result + this.connectionProperties.hashCode()) == 0) {
            result = 17;
        }
        if (this.gdsType != null) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) {
            return false;
        }
        FBManagedConnectionFactory that = (FBManagedConnectionFactory)other;
        return this.connectionProperties.equals(that.connectionProperties);
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() throws ResourceException {
        try {
            return new FBConnectionRequestInfo(this.getDatabaseParameterBuffer().deepCopy());
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public FBTpb getDefaultTpb() throws ResourceException {
        int defaultTransactionIsolation = this.connectionProperties.getMapper().getDefaultTransactionIsolation();
        return this.getTpb(defaultTransactionIsolation);
    }

    public FBTpb getTpb(int defaultTransactionIsolation) throws FBResourceException {
        return new FBTpb(this.connectionProperties.getMapper().getMapping(defaultTransactionIsolation));
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.start();
        return new FBDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        this.start();
        return new FBDataSource(this, this.defaultCm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.start();
        return new FBManagedConnection(subject, cri, this);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (FBManagedConnection mc : connectionSet) {
            if (!mc.matches(subject, (FBConnectionRequestInfo)cxRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        FBManagedConnectionFactory mcf = (FBManagedConnectionFactory)mcfInstances.get(this);
        if (mcf != null) {
            return mcf;
        }
        mcf = new FBManagedConnectionFactory(this.getGDSType(), (FBConnectionProperties)this.connectionProperties.clone());
        return mcf;
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf = (FBManagedConnectionFactory)mcfInstances.get(this);
        if (mcf != null) {
            return mcf;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.started) {
                Map map = mcfInstances;
                synchronized (map) {
                    mcfInstances.put(this, this);
                }
                this.started = true;
            }
        }
    }

    void notifyStart(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.put(xid, mc);
    }

    void notifyEnd(FBManagedConnection mc, Xid xid) throws XAException {
    }

    int notifyPrepare(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        return targetMc.internalPrepare(xid);
    }

    void notifyCommit(FBManagedConnection mc, Xid xid, boolean onePhase) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(this.getGDS(), xid, true);
        } else {
            targetMc.internalCommit(xid, onePhase);
        }
        this.xidMap.remove(xid);
    }

    void notifyRollback(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(this.getGDS(), xid, false);
        } else {
            targetMc.internalRollback(xid);
        }
        this.xidMap.remove(xid);
    }

    public void forget(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.remove(xid);
    }

    public void recover(FBManagedConnection mc, Xid xid) throws GDSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCompleteInLimboTransaction(GDS gds, Xid xid, boolean commit) throws XAException {
        try {
            FBManagedConnection tempMc = new FBManagedConnection(null, null, this);
            try {
                try {
                    FirebirdLocalTransaction tempLocalTx = (FirebirdLocalTransaction)tempMc.getLocalTransaction();
                    long fbTransactionId = 0L;
                    boolean found = false;
                    tempLocalTx.begin();
                    try {
                        ArrayList inLimboIds = FBManagedConnectionFactory.fetchInLimboXids(this.getGDS(), tempMc.getGDSHelper());
                        for (FBXid foundXid : inLimboIds) {
                            if (!foundXid.equals(xid)) continue;
                            found = true;
                            fbTransactionId = foundXid.getFirebirdTransactionId();
                        }
                    }
                    catch (SQLException ex) {
                        if (log != null) {
                            log.debug("can't perform query to fetch xids", ex);
                        }
                        throw new FBXAException(-7, ex);
                    }
                    finally {
                        tempLocalTx.commit();
                    }
                    if (!found) {
                        throw new FBXAException((commit ? "Commit" : "Rollback") + " called with unknown transaction.", -4);
                    }
                    IscDbHandle dbHandle = tempMc.getGDSHelper().getCurrentDbHandle();
                    IscTrHandle trHandle = gds.createIscTrHandle();
                    gds.iscReconnectTransaction(trHandle, dbHandle, fbTransactionId);
                    if (commit) {
                        gds.iscCommitTransaction(trHandle);
                    } else {
                        gds.iscRollbackTransaction(trHandle);
                    }
                }
                catch (GDSException ex) {
                    throw new FBXAException(-3, ex);
                }
            }
            finally {
                tempMc.destroy();
            }
        }
        catch (ResourceException ex) {
            throw new FBXAException(-3, (Exception)((Object)ex));
        }
    }

    public static ArrayList fetchInLimboXids(GDS gds, GDSHelper gdsHelper2) throws GDSException, SQLException, ResourceException {
        ArrayList<FBXid> xids = new ArrayList<FBXid>();
        AbstractIscStmtHandle stmtHandle2 = (AbstractIscStmtHandle)gds.createIscStmtHandle();
        gds.iscDsqlAllocateStatement(gdsHelper2.getCurrentDbHandle(), stmtHandle2);
        gdsHelper2.prepareStatement(stmtHandle2, RECOVERY_QUERY, false);
        gdsHelper2.executeStatement(stmtHandle2, false);
        gdsHelper2.fetch(stmtHandle2, 10);
        DataProvider dataProvider0 = new DataProvider(stmtHandle2, 0);
        DataProvider dataProvider1 = new DataProvider(stmtHandle2, 1);
        FBField field0 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[0], dataProvider0, gdsHelper2, false);
        FBField field1 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[1], dataProvider1, gdsHelper2, false);
        field0.setConnection(gdsHelper2);
        field1.setConnection(gdsHelper2);
        int row = 0;
        while (row < stmtHandle2.getRows().length) {
            if (stmtHandle2.getRows()[row] == null) {
                ++row;
                continue;
            }
            dataProvider0.setRow(row);
            dataProvider1.setRow(row);
            long inLimboTxId = field0.getLong();
            byte[] inLimboMessage = field1.getBytes();
            try {
                FBXid xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                xids.add(xid);
            }
            catch (FBIncorrectXidException ex) {
                // empty catch block
            }
            ++row;
        }
        gdsHelper2.closeStatement(stmtHandle2, true);
        return xids;
    }

    AbstractConnection newConnection(FBManagedConnection mc) throws ResourceException {
        Class connectionClass = GDSFactory.getConnectionClass(this.getGDSType());
        if (!AbstractConnection.class.isAssignableFrom(connectionClass)) {
            throw new IllegalArgumentException("Specified connection class does not extend " + AbstractConnection.class.getName() + " class");
        }
        try {
            Constructor constructor = connectionClass.getConstructor(FBManagedConnection.class);
            return (AbstractConnection)constructor.newInstance(mc);
        }
        catch (NoSuchMethodException ex) {
            throw new FBResourceException("Cannot instantiate connection class " + connectionClass.getName() + ", no constructor accepting " + FBManagedConnection.class + " class as single parameter was found.");
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ex.getTargetException();
            }
            if (ex.getTargetException() instanceof Error) {
                throw (Error)ex.getTargetException();
            }
            throw new FBResourceException((Exception)ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new FBResourceException("Constructor for class " + connectionClass.getName() + " is not accessible.");
        }
        catch (InstantiationException ex) {
            throw new FBResourceException("Cannot instantiate class" + connectionClass.getName());
        }
    }

    private static class DataProvider
    implements FieldDataProvider {
        private AbstractIscStmtHandle stmtHandle;
        private int fieldPos;
        private int row;

        private DataProvider(AbstractIscStmtHandle stmtHandle, int fieldPos) {
            this.stmtHandle = stmtHandle;
            this.fieldPos = fieldPos;
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public byte[] getFieldData() {
            return this.stmtHandle.getRows()[this.row][this.fieldPos];
        }

        @Override
        public void setFieldData(byte[] data) {
            throw new UnsupportedOperationException();
        }
    }
}

