/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBRowUpdater;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableCursorFetcher;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBResultSet
implements ResultSet,
Synchronizable,
FBObjectListener.FetcherListener {
    private AbstractStatement fbStatement;
    private FBFetcher fbFetcher;
    private FirebirdRowUpdater rowUpdater;
    protected GDSHelper gdsHelper;
    public XSQLVAR[] xsqlvars;
    public byte[][] row = null;
    private int maxRows = 0;
    private boolean wasNull = false;
    private boolean wasNullValid = false;
    private boolean closed = false;
    private boolean trimStrings;
    private SQLWarning firstWarning = null;
    private FBField[] fields = null;
    private HashMap colNames = new HashMap();
    private String cursorName;
    private FBObjectListener.ResultSetListener listener;
    private int rsType = 1003;
    private int rsConcurrency = 1007;
    private int rsHoldability = 2;

    public void allRowsFetched(FBFetcher fetcher) throws SQLException {
        this.listener.allRowsFetched(this);
    }

    public void fetcherClosed(FBFetcher fetcher) throws SQLException {
    }

    public void rowChanged(FBFetcher fetcher, byte[][] newRow) throws SQLException {
        this.row = newRow;
    }

    protected FBResultSet(GDSHelper gdsHelper, AbstractStatement fbStatement, AbstractIscStmtHandle stmt, FBObjectListener.ResultSetListener listener, boolean trimStrings, int rsType, int rsConcurrency, int rsHoldability, boolean cached) throws SQLException {
        this.gdsHelper = gdsHelper;
        this.cursorName = fbStatement.getCursorName();
        this.listener = listener;
        this.rsType = rsType;
        this.rsConcurrency = rsConcurrency;
        this.rsHoldability = rsHoldability;
        this.trimStrings = trimStrings;
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.maxRows = fbStatement.getMaxRows();
        this.fbStatement = fbStatement;
        boolean updatableCursor = fbStatement.isUpdatableCursor();
        if (rsType == 1004) {
            cached = true;
        }
        if (cached) {
            this.prepareVars(true);
            this.fbFetcher = new FBCachedFetcher(gdsHelper, fbStatement.fetchSize, fbStatement.maxRows, stmt, this, rsType == 1003);
        } else {
            this.prepareVars(false);
            if (rsType == 1005) {
                fbStatement.addWarning(new FBSQLWarning("Result set type changed. ResultSet.TYPE_SCROLL_SENSITIVE is not supported."));
                rsType = 1004;
            }
            this.fbFetcher = updatableCursor ? new FBUpdatableCursorFetcher(gdsHelper, fbStatement, stmt, this, fbStatement.getMaxRows(), fbStatement.getFetchSize()) : new FBStatementFetcher(gdsHelper, fbStatement, stmt, this, fbStatement.getMaxRows(), fbStatement.getFetchSize());
        }
        if (rsConcurrency == 1008) {
            try {
                this.rowUpdater = new FBRowUpdater(gdsHelper, this.xsqlvars, this, cached, listener);
            }
            catch (FBResultSetNotUpdatableException ex) {
                fbStatement.addWarning(new FBSQLWarning("Result set concurrency changed to READ ONLY."));
                rsConcurrency = 1007;
            }
        }
    }

    protected FBResultSet(XSQLVAR[] xsqlvars, ArrayList rows) throws SQLException {
        this.maxRows = 0;
        this.fbFetcher = new FBCachedFetcher(rows, this);
        this.xsqlvars = xsqlvars;
        this.prepareVars(true);
    }

    private void prepareVars(boolean cached) throws SQLException {
        this.fields = new FBField[this.xsqlvars.length];
        this.colNames = new HashMap(this.xsqlvars.length, 1.0f);
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            final int fieldPosition = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                public byte[] getFieldData() {
                    return FBResultSet.this.row[fieldPosition];
                }

                public void setFieldData(byte[] data) {
                    FBResultSet.this.row[fieldPosition] = data;
                }
            };
            this.fields[i] = FBField.createField(this.xsqlvars[i], dataProvider, this.gdsHelper, cached);
        }
    }

    private void notifyRowUpdater() throws SQLException {
        if (this.rowUpdater != null) {
            this.rowUpdater.setRow(this.row);
        }
    }

    protected void checkCursorMove() throws SQLException {
        if (this.closed && this.rsHoldability != 1) {
            throw new FBSQLException("The result set is closed");
        }
        this.wasNullValid = false;
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].close();
        }
    }

    public Object getSynchronizationObject() throws SQLException {
        return this.fbStatement.getSynchronizationObject();
    }

    public boolean next() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.next();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean notifyListener) throws SQLException {
        this.wasNullValid = false;
        this.closed = true;
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].close();
            }
        }
        finally {
            if (this.fbFetcher != null) {
                this.fbFetcher.close();
                if (notifyListener) {
                    if (this.rowUpdater != null) {
                        this.rowUpdater.close();
                    }
                    if (this.listener != null) {
                        this.listener.resultSetClosed(this);
                    }
                }
            }
            if (this.rsHoldability != 1) {
                this.fbFetcher = null;
            }
        }
    }

    public boolean wasNull() throws SQLException {
        if (!this.wasNullValid) {
            throw new FBSQLException("Look at a column before testing null.");
        }
        if (this.row == null) {
            throw new FBSQLException("No row available for wasNull.");
        }
        return this.wasNull;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getAsciiStream();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    public String getString(int columnIndex) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnIndex).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnIndex).getString();
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getUnicodeStream();
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.xsqlvars[columnIndex - 1];
    }

    public FBField getField(int columnIndex) throws SQLException {
        FBField field = this.getField(columnIndex, true);
        this.wasNullValid = true;
        this.wasNull = this.row != null ? this.row[columnIndex - 1] == null : true;
        return field;
    }

    public FBField getField(int columnIndex, boolean checkRowPosition) throws SQLException {
        if (this.closed && this.rsHoldability != 1) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (checkRowPosition && this.row == null && this.rowUpdater == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnIndex > this.xsqlvars.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        if (this.rowUpdater != null) {
            return this.rowUpdater.getField(columnIndex - 1);
        }
        return this.fields[columnIndex - 1];
    }

    public FBField getField(String columnName) throws SQLException {
        int colNum;
        if (this.closed && this.rsHoldability != 1) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (this.row == null && this.rowUpdater == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnName == null) {
            throw new FBSQLException("Column identifier must be not null.", "HY002");
        }
        Integer fieldNum = (Integer)this.colNames.get(columnName);
        if (fieldNum == null) {
            colNum = this.findColumn(columnName);
            fieldNum = new Integer(colNum);
            this.colNames.put(columnName, fieldNum);
        }
        colNum = fieldNum;
        FBField field = this.rowUpdater != null ? this.rowUpdater.getField(colNum - 1) : this.fields[colNum - 1];
        this.wasNullValid = true;
        this.wasNull = this.row != null ? this.row[colNum - 1] == null : true;
        return field;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    public String getString(String columnName) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnName).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnName).getString();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getField(columnName).getAsciiStream();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getField(columnName).getUnicodeStream();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.xsqlvars, this.gdsHelper);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    public int findColumn(String columnName) throws SQLException {
        if (columnName == null || columnName.equals("")) {
            throw new FBSQLException("Empty string does not identify column.", "HY002");
        }
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            int i;
            columnName = columnName.substring(1, columnName.length() - 1);
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        } else {
            int i;
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        }
        throw new FBSQLException("Column name " + columnName + " not found in result set.", "HY002");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.fbFetcher.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.fbFetcher.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.fbFetcher.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.fbFetcher.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.beforeFirst();
        this.notifyRowUpdater();
    }

    public void afterLast() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.afterLast();
        this.notifyRowUpdater();
    }

    public boolean first() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.first();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public boolean last() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.last();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public int getRow() throws SQLException {
        return this.fbFetcher.getRowNum();
    }

    public boolean absolute(int row) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.absolute(row);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public boolean relative(int rows) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.relative(rows);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public boolean previous() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.previous();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException("Can't set fetch direction");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size.", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows.", "HY009");
        }
        this.fbFetcher.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.fbFetcher.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    public boolean rowInserted() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    public boolean rowDeleted() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setNull();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBoolean(x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setByte(x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setShort(x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setInteger(x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setLong(x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setFloat(x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setDouble(x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBigDecimal(x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setString(x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBytes(x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setDate(x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setTime(x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setTimestamp(x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setAsciiStream(x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setObject(x);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setObject(x);
    }

    public void updateNull(String columnName) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setNull();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBoolean(x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setByte(x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setShort(x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setInteger(x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setLong(x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setFloat(x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setDouble(x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBigDecimal(x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setString(x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBytes(x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setDate(x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setTime(x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setTimestamp(x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setAsciiStream(x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBinaryStream(x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setCharacterStream(reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setObject(x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setObject(x);
    }

    public void insertRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.insertRow();
        this.fbFetcher.insertRow(this.rowUpdater.getInsertRow());
        this.notifyRowUpdater();
    }

    public void updateRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.updateRow();
        this.fbFetcher.updateRow(this.rowUpdater.getNewRow());
        this.notifyRowUpdater();
    }

    public void deleteRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.deleteRow();
        this.fbFetcher.deleteRow();
        this.notifyRowUpdater();
    }

    public void refreshRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.refreshRow();
        this.fbFetcher.updateRow(this.rowUpdater.getOldRow());
        this.notifyRowUpdater();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.moveToCurrentRow();
    }

    public Statement getStatement() {
        return this.fbStatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    public Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    public Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    public Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    public URL getURL(int param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public URL getURL(String param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateRef(int param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateRef(String param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBlob(int param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateBlob(String param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateClob(int param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateClob(String param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateArray(int param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void updateArray(String param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public String getExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.fbStatement == null) {
            return "";
        }
        return this.fbStatement.getExecutionPlan();
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }
}

