/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.util.ITaskThreadPoolCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.TaskExecuter;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TaskThreadPool {
    private static ILogger s_log = LoggerController.createLogger(TaskThreadPool.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TaskThreadPool.class);
    private int _iFree;
    private int _threadCount;
    private List<Runnable> _tasks = new ArrayList<Runnable>();
    private MyCallback _callback = new MyCallback();
    private JFrame _parentForMessages = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(Runnable task) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("Null Runnable passed");
        }
        this._tasks.add(task);
        if (this._iFree == 0) {
            Thread th = new Thread(new TaskExecuter(this._callback));
            th.setPriority(1);
            th.setDaemon(true);
            th.start();
            ++this._threadCount;
            s_log.debug("Creating thread nbr: " + this._threadCount);
        } else {
            MyCallback myCallback = this._callback;
            synchronized (myCallback) {
                s_log.debug("Reusing existing thread");
                this._callback.notify();
            }
        }
    }

    public void setParentForMessages(JFrame parentForMessages) {
        this._parentForMessages = parentForMessages;
    }

    private final class MyCallback
    implements ITaskThreadPoolCallback {
        private MyCallback() {
        }

        @Override
        public void incrementFreeThreadCount() {
            ++TaskThreadPool.this._iFree;
            s_log.debug("Returning thread. " + TaskThreadPool.this._iFree + " threads available");
        }

        @Override
        public void decrementFreeThreadCount() {
            --TaskThreadPool.this._iFree;
            s_log.debug("Using a thread. " + TaskThreadPool.this._iFree + " threads available");
        }

        @Override
        public synchronized Runnable nextTask() {
            if (TaskThreadPool.this._tasks.size() > 0) {
                return (Runnable)TaskThreadPool.this._tasks.remove(0);
            }
            return null;
        }

        @Override
        public void showMessage(final Throwable th) {
            s_log.error("Error", th);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringBuffer msg = new StringBuffer(s_stringMgr.getString("TaskThreadPool.errorDuringTaskExecMsg"));
                    msg.append("\n");
                    msg.append(th.getMessage());
                    JOptionPane.showMessageDialog(TaskThreadPool.this._parentForMessages, msg.toString());
                    throw new RuntimeException(th);
                }
            });
        }
    }
}

