/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;

public class FileWrapperImpl
implements Serializable,
Comparable<FileWrapperImpl>,
FileWrapper {
    private File _wrappedFile = null;
    private static final long serialVersionUID = 301077366599181567L;

    public FileWrapperImpl(FileWrapperImpl impl) {
        this._wrappedFile = impl._wrappedFile;
    }

    public FileWrapperImpl(File wrappedFile) {
        this._wrappedFile = wrappedFile;
    }

    public FileWrapperImpl(String pathname) {
        this._wrappedFile = new File(pathname);
    }

    public FileWrapperImpl(String parent, String child) {
        this._wrappedFile = new File(parent, child);
    }

    public FileWrapperImpl(FileWrapper parent, String child) {
        if (parent != null) {
            FileWrapperImpl parentImpl = (FileWrapperImpl)parent;
            this._wrappedFile = new File(parentImpl._wrappedFile, child);
        } else {
            this._wrappedFile = new File((File)null, child);
        }
    }

    public FileWrapperImpl(URI uri) {
        this._wrappedFile = new File(uri);
    }

    @Override
    public String getName() {
        return this._wrappedFile.getName();
    }

    @Override
    public String getParent() {
        return this._wrappedFile.getParent();
    }

    @Override
    public FileWrapper getParentFile() {
        if (this._wrappedFile.getParentFile() == null) {
            return null;
        }
        return new FileWrapperImpl(this._wrappedFile.getParentFile());
    }

    @Override
    public String getPath() {
        return this._wrappedFile.getPath();
    }

    @Override
    public boolean isAbsolute() {
        return this._wrappedFile.isAbsolute();
    }

    @Override
    public String getAbsolutePath() {
        return this._wrappedFile.getAbsolutePath();
    }

    @Override
    public FileWrapper getAbsoluteFile() {
        return new FileWrapperImpl(this._wrappedFile.getAbsoluteFile());
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this._wrappedFile.getCanonicalPath();
    }

    @Override
    public FileWrapper getCanonicalFile() throws IOException {
        return new FileWrapperImpl(this._wrappedFile.getCanonicalFile());
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this._wrappedFile.toURI().toURL();
    }

    @Override
    public URI toURI() {
        return this._wrappedFile.toURI();
    }

    @Override
    public boolean canRead() {
        return this._wrappedFile.canRead();
    }

    @Override
    public boolean canWrite() {
        return this._wrappedFile.canWrite();
    }

    @Override
    public boolean exists() {
        return this._wrappedFile.exists();
    }

    @Override
    public boolean isDirectory() {
        return this._wrappedFile.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this._wrappedFile.isFile();
    }

    @Override
    public boolean isHidden() {
        return this._wrappedFile.isHidden();
    }

    @Override
    public long lastModified() {
        return this._wrappedFile.lastModified();
    }

    @Override
    public long length() {
        return this._wrappedFile.length();
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this._wrappedFile.createNewFile();
    }

    @Override
    public boolean delete() {
        return this._wrappedFile.delete();
    }

    @Override
    public void deleteOnExit() {
        this._wrappedFile.deleteOnExit();
    }

    @Override
    public String[] list() {
        return this._wrappedFile.list();
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return this._wrappedFile.list(filter);
    }

    @Override
    public FileWrapper[] listFiles() {
        return FileWrapperImpl.wrapFiles(this._wrappedFile.listFiles());
    }

    @Override
    public FileWrapper[] listFiles(FilenameFilter filter) {
        return FileWrapperImpl.wrapFiles(this._wrappedFile.listFiles(filter));
    }

    @Override
    public FileWrapper[] listFiles(FileFilter filter) {
        return FileWrapperImpl.wrapFiles(this._wrappedFile.listFiles(filter));
    }

    @Override
    public boolean mkdir() {
        return this._wrappedFile.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this._wrappedFile.mkdirs();
    }

    @Override
    public boolean renameTo(FileWrapper dest) {
        return this._wrappedFile.renameTo(((FileWrapperImpl)dest)._wrappedFile);
    }

    @Override
    public boolean setLastModified(long time) {
        return this._wrappedFile.setLastModified(time);
    }

    @Override
    public boolean setReadOnly() {
        return this._wrappedFile.setReadOnly();
    }

    public static FileWrapper[] listRoots() {
        return FileWrapperImpl.wrapFiles(File.listRoots());
    }

    public static FileWrapper createTempFile(String prefix, String suffix, FileWrapper directory) throws IOException {
        if (directory == null) {
            return new FileWrapperImpl(File.createTempFile(prefix, suffix, null));
        }
        return new FileWrapperImpl(File.createTempFile(prefix, suffix, ((FileWrapperImpl)directory)._wrappedFile));
    }

    public static FileWrapper createTempFile(String prefix, String suffix) throws IOException {
        return FileWrapperImpl.createTempFile(prefix, suffix, null);
    }

    @Override
    public int compareTo(FileWrapperImpl pathname) {
        return this._wrappedFile.compareTo(pathname._wrappedFile);
    }

    @Override
    public String toString() {
        return this._wrappedFile.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._wrappedFile == null ? 0 : this._wrappedFile.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileWrapperImpl other = (FileWrapperImpl)obj;
        return !(this._wrappedFile == null ? other._wrappedFile != null : !this._wrappedFile.equals(other._wrappedFile));
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    }

    private static FileWrapper[] wrapFiles(File[] resultFiles) {
        if (resultFiles == null) {
            return null;
        }
        FileWrapper[] wrappedFiles = new FileWrapper[resultFiles.length];
        for (int i = 0; i < resultFiles.length; ++i) {
            wrappedFiles[i] = new FileWrapperImpl(resultFiles[i]);
        }
        return wrappedFiles;
    }

    public static FileWrapperImpl createTempFile(String prefix, String suffix, FileWrapperImpl directory) throws IOException {
        if (directory != null) {
            return new FileWrapperImpl(File.createTempFile(prefix, suffix, directory._wrappedFile));
        }
        return new FileWrapperImpl(File.createTempFile(prefix, suffix, null));
    }
}

