/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;

public class SQLDriver
implements ISQLDriver,
Cloneable,
Serializable {
    static final long serialVersionUID = 8506401259069527981L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLDriver.class);
    private IIdentifier _id;
    private String _name;
    private String _jarFileName = null;
    private List<String> _jarFileNamesList = new ArrayList<String>();
    private String _driverClassName;
    private String _url;
    private boolean _jdbcDriverClassLoaded;
    private transient PropertyChangeReporter _propChgReporter;
    private String _websiteUrl;

    public SQLDriver(IIdentifier id) {
        this._id = id;
        this._name = "";
        this._jarFileName = null;
        this._driverClassName = null;
        this._url = "";
        this._websiteUrl = "";
    }

    public SQLDriver() {
    }

    @Override
    public synchronized void assignFrom(ISQLDriver rhs) throws ValidationException {
        this.setName(rhs.getName());
        this.setJarFileNames(rhs.getJarFileNames());
        this.setDriverClassName(rhs.getDriverClassName());
        this.setUrl(rhs.getUrl());
        this.setJDBCDriverClassLoaded(rhs.isJDBCDriverClassLoaded());
        this.setWebSiteUrl(rhs.getWebSiteUrl());
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((Object)((ISQLDriver)rhs).getIdentifier()).equals(this.getIdentifier());
        }
        return rc;
    }

    public synchronized int hashCode() {
        return ((Object)this.getIdentifier()).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        try {
            SQLDriver driver = (SQLDriver)super.clone();
            driver._propChgReporter = null;
            return driver;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    @Override
    public int compareTo(ISQLDriver rhs) {
        return this._name.compareTo(rhs.getName());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public void setReportPropertyChanges(boolean report) {
        this.getPropertyChangeReporter().setNotify(report);
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    @Override
    public String getDriverClassName() {
        return this._driverClassName;
    }

    @Override
    public void setDriverClassName(String driverClassName) throws ValidationException {
        String data = this.getString(driverClassName);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_DRIVER);
        }
        if (!data.equals(this._driverClassName)) {
            String oldValue = this._driverClassName;
            this._driverClassName = data;
            this.getPropertyChangeReporter().firePropertyChange("driverClassName", oldValue, this._driverClassName);
        }
    }

    @Override
    public String getJarFileName() {
        return this._jarFileName;
    }

    @Override
    public void setJarFileName(String value) {
        if (value == null) {
            value = "";
        }
        if (this._jarFileName == null || !this._jarFileName.equals(value)) {
            String oldValue = this._jarFileName;
            this._jarFileName = value;
            this.getPropertyChangeReporter().firePropertyChange("jarFileName", oldValue, this._jarFileName);
        }
    }

    @Override
    public synchronized String[] getJarFileNames() {
        return this._jarFileNamesList.toArray(new String[this._jarFileNamesList.size()]);
    }

    @Override
    public synchronized void setJarFileNames(String[] values) {
        String[] oldValue = this._jarFileNamesList.toArray(new String[this._jarFileNamesList.size()]);
        this._jarFileNamesList.clear();
        if (values == null) {
            values = new String[]{};
        }
        for (int i = 0; i < values.length; ++i) {
            this._jarFileNamesList.add(values[i]);
        }
        this.getPropertyChangeReporter().firePropertyChange("jarFileNames", oldValue, values);
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    @Override
    public void setUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_URL);
        }
        if (!data.equals(this._url)) {
            String oldValue = this._url;
            this._url = data;
            this.getPropertyChangeReporter().firePropertyChange("url", oldValue, this._url);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_NAME);
        }
        if (!data.equals(this._name)) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeReporter().firePropertyChange("name", oldValue, this._name);
        }
    }

    @Override
    public boolean isJDBCDriverClassLoaded() {
        return this._jdbcDriverClassLoaded;
    }

    @Override
    public void setJDBCDriverClassLoaded(boolean cl) {
        this._jdbcDriverClassLoaded = cl;
    }

    @Override
    public synchronized StringWrapper[] getJarFileNameWrappers() {
        StringWrapper[] wrappers = new StringWrapper[this._jarFileNamesList.size()];
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new StringWrapper(this._jarFileNamesList.get(i));
        }
        return wrappers;
    }

    @Override
    public StringWrapper getJarFileNameWrapper(int idx) throws ArrayIndexOutOfBoundsException {
        return new StringWrapper(this._jarFileNamesList.get(idx));
    }

    @Override
    public void setJarFileNameWrappers(StringWrapper[] value) {
        this._jarFileNamesList.clear();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this._jarFileNamesList.add(value[i].getString());
            }
        }
    }

    @Override
    public void setJarFileNameWrapper(int idx, StringWrapper value) throws ArrayIndexOutOfBoundsException {
        this._jarFileNamesList.set(idx, value.getString());
    }

    private String getString(String data) {
        return data != null ? data.trim() : "";
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    @Override
    public String getWebSiteUrl() {
        return this._websiteUrl;
    }

    @Override
    public void setWebSiteUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (!data.equals(this._websiteUrl)) {
            String oldValue = this._websiteUrl;
            this._websiteUrl = data;
            PropertyChangeReporter pcr = this.getPropertyChangeReporter();
            pcr.firePropertyChange("websiteUrl", oldValue, this._websiteUrl);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface IStrings {
        public static final String ERR_BLANK_NAME = SQLDriver.access$000().getString("SQLDriver.error.blankname");
        public static final String ERR_BLANK_DRIVER = SQLDriver.access$000().getString("SQLDriver.error.blankdriver");
        public static final String ERR_BLANK_URL = SQLDriver.access$000().getString("SQLDriver.error.blankurl");
    }
}

