/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DatabaseObjectType
implements IHasIdentifier,
Serializable {
    static final long serialVersionUID = 2325635336825122256L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DatabaseObjectType.class);
    private static final IntegerIdentifierFactory s_idFactory = new IntegerIdentifierFactory();
    public static final DatabaseObjectType OTHER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.other");
    public static final DatabaseObjectType BEST_ROW_ID = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.bestRowID");
    public static final DatabaseObjectType CATALOG = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.catalog");
    public static final DatabaseObjectType COLUMN = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.column");
    public static final DatabaseObjectType SESSION = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.database");
    public static final DatabaseObjectType DATABASE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.DATABASE_TYPE_DBO");
    public static final DatabaseObjectType DATATYPE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.datatype");
    public static final DatabaseObjectType PRIMARY_KEY = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.primarykey");
    public static final DatabaseObjectType FOREIGN_KEY = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.foreignkey");
    public static final DatabaseObjectType FUNCTION = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.function");
    public static final DatabaseObjectType INDEX_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.INDEX_TYPE_DBO");
    public static final DatabaseObjectType INDEX = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.index");
    public static final DatabaseObjectType PROCEDURE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.storproc");
    public static final DatabaseObjectType PROC_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.PROC_TYPE_DBO");
    public static final DatabaseObjectType SCHEMA = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.schema");
    public static final DatabaseObjectType SEQUENCE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.SEQUENCE_TYPE_DBO");
    public static final DatabaseObjectType SEQUENCE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.sequence");
    public static final DatabaseObjectType TABLE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.table");
    public static final DatabaseObjectType TABLE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.TABLE_TYPE_DBO");
    public static final DatabaseObjectType VIEW = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.view");
    public static final DatabaseObjectType TRIGGER_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.TRIGGER_TYPE_DBO");
    public static final DatabaseObjectType TRIGGER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.catalog");
    public static final DatabaseObjectType UDT = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.udt");
    public static final DatabaseObjectType UDT_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.UDT_TYPE_DBO");
    public static final DatabaseObjectType UDF = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.udf");
    public static final DatabaseObjectType UDF_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.UDF_TYPE_DBO");
    public static final DatabaseObjectType USER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.user");
    private final IIdentifier _id;
    private final String _name;
    private String _keyForSerializationReplace;

    private DatabaseObjectType(String name, String keyForSerializationReplace) {
        this._keyForSerializationReplace = keyForSerializationReplace;
        this._id = s_idFactory.createIdentifier();
        this._name = name != null ? name : ((Object)this._id).toString();
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getKeyForSerializationReplace() {
        return this._keyForSerializationReplace;
    }

    public String toString() {
        return this.getName();
    }

    public static DatabaseObjectType createNewDatabaseObjectTypeI18n(String key) {
        return new DatabaseObjectType(key, s_stringMgr.getString(key));
    }

    public static DatabaseObjectType createNewDatabaseObjectType(String key) {
        return new DatabaseObjectType(key, key);
    }
}

