/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.Serializable;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class DatabaseObjectInfo
implements IDatabaseObjectInfo,
Serializable {
    static final long serialVersionUID = -7138016566181091160L;
    private final String _catalog;
    private final String _schema;
    private final String _simpleName;
    private final String _qualifiedName;
    private DatabaseObjectType _dboType = DatabaseObjectType.OTHER;

    public DatabaseObjectInfo(String catalog, String schema, String simpleName, DatabaseObjectType dboType, ISQLDatabaseMetaData md) {
        if (dboType == null) {
            throw new IllegalArgumentException("DatabaseObjectType == null");
        }
        if (md == null) {
            throw new IllegalArgumentException("SQLDatabaseMetaData == null");
        }
        this._catalog = catalog;
        this._schema = schema;
        this._simpleName = simpleName;
        this._qualifiedName = this.generateQualifiedName(md);
        this._dboType = dboType;
    }

    public DatabaseObjectInfo(String catalog, String schema, String simpleName) {
        this._catalog = catalog;
        this._schema = schema;
        this._simpleName = simpleName;
        this._qualifiedName = simpleName;
    }

    public String toString() {
        return this.getSimpleName();
    }

    @Override
    public String getCatalogName() {
        return this._catalog;
    }

    @Override
    public String getSchemaName() {
        return this._schema;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }

    @Override
    public String getQualifiedName() {
        return this._qualifiedName;
    }

    @Override
    public DatabaseObjectType getDatabaseObjectType() {
        return this._dboType;
    }

    protected String generateQualifiedName(ISQLConnection conn) {
        return this.generateQualifiedName(conn.getSQLMetaData());
    }

    private String getInformixQualifiedName() {
        StringBuilder result = new StringBuilder();
        if (this._catalog != null && this._schema != null) {
            result.append(this._catalog);
            result.append(":");
            result.append("\"");
            result.append(this._schema);
            result.append("\"");
            result.append(".");
        }
        result.append(this._simpleName);
        return result.toString();
    }

    private String getProgressQualifiedName() {
        StringBuilder result = new StringBuilder();
        if (this._schema != null) {
            result.append(this._schema);
            result.append(".");
        }
        result.append(this._simpleName);
        return result.toString();
    }

    protected String generateQualifiedName(ISQLDatabaseMetaData md) {
        String catSep = null;
        String identifierQuoteString = null;
        boolean supportsSchemasInDataManipulation = false;
        boolean supportsCatalogsInDataManipulation = false;
        boolean supportsSchemasInTableDefinitions = false;
        if (DialectFactory.isInformix(md)) {
            return this.getInformixQualifiedName();
        }
        if (DialectFactory.isProgress(md)) {
            return this.getProgressQualifiedName();
        }
        try {
            supportsSchemasInDataManipulation = md.supportsSchemasInDataManipulation();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            supportsCatalogsInDataManipulation = md.supportsCatalogsInDataManipulation();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            supportsSchemasInTableDefinitions = md.supportsSchemasInTableDefinitions();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            catSep = md.getCatalogSeparator();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        if (StringUtilities.isEmpty(catSep)) {
            catSep = ".";
        }
        try {
            identifierQuoteString = md.getIdentifierQuoteString();
            if (identifierQuoteString != null && identifierQuoteString.equals(" ")) {
                identifierQuoteString = null;
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        if (DialectFactory.isSyBase(md)) {
            identifierQuoteString = this.checkSybaseIdentifierQuoteString(md, identifierQuoteString);
        }
        StringBuilder buf = new StringBuilder();
        if (supportsCatalogsInDataManipulation && !StringUtilities.isEmpty(this._catalog)) {
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(this._catalog);
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(catSep);
        }
        if (this.shouldQualifyWithSchema(supportsSchemasInDataManipulation, supportsSchemasInTableDefinitions, md)) {
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(this._schema);
            if (identifierQuoteString != null) {
                buf.append(identifierQuoteString);
            }
            buf.append(catSep);
        }
        if (identifierQuoteString != null) {
            buf.append(identifierQuoteString);
        }
        String quoteExpandedName = SQLUtilities.quoteIdentifier(this._simpleName);
        buf.append(quoteExpandedName);
        if (identifierQuoteString != null) {
            buf.append(identifierQuoteString);
        }
        return buf.toString();
    }

    private boolean shouldQualifyWithSchema(boolean supportsSchemasInDataManipulation, boolean supportsSchemasInTableDefinitions, ISQLDatabaseMetaData md) {
        if (this._schema == null || this._schema.length() == 0) {
            return false;
        }
        if (supportsSchemasInDataManipulation) {
            return true;
        }
        if (this._dboType == DatabaseObjectType.TABLE && supportsSchemasInTableDefinitions) {
            return true;
        }
        return DialectFactory.isHSQL(md);
    }

    private String checkSybaseIdentifierQuoteString(ISQLDatabaseMetaData md, String quoteString) {
        String result = quoteString;
        String productName = null;
        String sybaseTwelveVersionId = "12.";
        try {
            productName = md.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (productName != null && productName.contains(sybaseTwelveVersionId)) {
            result = "";
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            DatabaseObjectInfo info = (DatabaseObjectInfo)obj;
            if ((info._catalog == null && this._catalog == null || info._catalog != null && this._catalog != null && info._catalog.equals(this._catalog)) && (info._qualifiedName == null && this._qualifiedName == null || info._qualifiedName != null && this._qualifiedName != null && info._qualifiedName.equals(this._qualifiedName)) && (info._schema == null && this._schema == null || info._schema != null && this._schema != null && info._schema.equals(this._schema))) {
                return info._simpleName == null && this._simpleName == null || info._simpleName != null && this._simpleName != null && info._simpleName.equals(this._simpleName);
            }
        }
        return false;
    }

    public int hashCode() {
        return this._qualifiedName.hashCode();
    }

    @Override
    public int compareTo(IDatabaseObjectInfo o) {
        return this._qualifiedName.compareTo(o.getQualifiedName());
    }

    public void replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM(DatabaseObjectType type) {
        this._dboType = type;
    }

    public static interface IPropertyNames {
        public static final String CATALOG_NAME = "catalogName";
        public static final String SCHEMA_NAME = "schemaName";
        public static final String SIMPLE_NAME = "simpleName";
        public static final String QUALIFIED_NAME = "qualifiedName";
    }
}

