/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvDlg;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableExportCsvController {
    private static final String PREF_KEY_CSV_FILE = "SquirrelSQL.csvexport.csvfile";
    private static final String PREF_KEY_CSV_ENCODING = "SquirrelSQL.csvexport.csvencoding";
    private static final String PREF_KEY_WITH_HEADERS = "SquirrelSQL.csvexport.withColumnHeaders";
    private static final String PREF_KEY_SEPERATOR_TAB = "SquirrelSQL.csvexport.sepearatorTab";
    private static final String PREF_KEY_SEPERATOR_CHAR = "SquirrelSQL.csvexport.sepearatorChar";
    private static final String PREF_KEY_LINE_SEPERATOR = "SquirrelSQL.csvexport.lineSeparator";
    private static final String PREF_KEY_EXPORT_COMPLETE = "SquirrelSQL.csvexport.exportcomplete";
    private static final String PREF_KEY_USE_GLOBAL_PREFS_FORMATING = "SquirrelSQL.csvexport.useGlobalPrefsFomating";
    private static final String PREF_KEY_EXECUTE_COMMAND = "SquirrelSQL.csvexport.executeCommand";
    private static final String PREF_KEY_COMMAND = "SquirrelSQL.csvexport.commandString";
    private static final String PREF_KEY_FORMAT_CSV = "SquirrelSQL.csvexport.formatCSV";
    private static final String PREF_KEY_FORMAT_XLS = "SquirrelSQL.csvexport.formatXLS";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableExportCsvController.class);
    private TableExportCsvDlg _dlg = new TableExportCsvDlg();
    private boolean _ok = false;
    public static final int EXPORT_FORMAT_CSV = 0;
    public static final int EXPORT_FORMAT_XLS = 1;

    TableExportCsvController() {
        this.initDlg();
        this.initListeners();
        this._dlg.txtSeparatorChar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TableExportCsvController.this.onSeparatorCharChanged(e);
            }
        });
        this._dlg.getRootPane().setDefaultButton(this._dlg.btnOk);
        this.installEscapeClose();
        this._dlg.pack();
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onSeparatorCharChanged(KeyEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = ((TableExportCsvController)TableExportCsvController.this)._dlg.txtSeparatorChar.getText();
                if (null != text && 1 < text.length()) {
                    ((TableExportCsvController)TableExportCsvController.this)._dlg.txtSeparatorChar.setText(text.substring(0, 1));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
    }

    private void initListeners() {
        this._dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onOK();
            }
        });
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.closeDlg();
            }
        });
        this._dlg.radFormatCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.radFormatXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.chkSeparatorTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(false);
            }
        });
        this._dlg.chkExecCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onChkExecCommand();
            }
        });
        this._dlg.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFile();
            }
        });
        this._dlg.btnCommandFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onCommandFile();
            }
        });
    }

    private void onFormat(boolean replaceEnding) {
        if (this._dlg.radFormatCSV.isSelected()) {
            this._dlg.lblSeparator.setEnabled(true);
            this._dlg.chkSeparatorTab.setEnabled(true);
            this._dlg.txtSeparatorChar.setEnabled(true);
            this._dlg.lblCharset.setEnabled(true);
            this._dlg.charsets.setEnabled(true);
            if (this._dlg.chkSeparatorTab.isSelected()) {
                this._dlg.txtSeparatorChar.setText(null);
                this._dlg.txtSeparatorChar.setEnabled(false);
                this._dlg.lblSeparator.setEnabled(false);
            } else {
                this._dlg.txtSeparatorChar.setEnabled(true);
                this._dlg.lblSeparator.setEnabled(true);
            }
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else if (this._dlg.radFormatXLS.isSelected()) {
            this._dlg.lblSeparator.setEnabled(false);
            this._dlg.lblCharset.setEnabled(false);
            this._dlg.chkSeparatorTab.setEnabled(false);
            this._dlg.txtSeparatorChar.setEnabled(false);
            this._dlg.charsets.setEnabled(false);
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else {
            throw new IllegalStateException("No valid output format");
        }
    }

    private void replaceFileEnding() {
        String newEnding;
        if (this._dlg.radFormatCSV.isSelected()) {
            newEnding = "csv";
        } else if (this._dlg.radFormatXLS.isSelected()) {
            newEnding = "xls";
        } else {
            throw new IllegalStateException("No valid output format");
        }
        String file = this._dlg.txtFile.getText();
        if (null == file || 0 == file.trim().length() || file.toUpperCase().endsWith("." + newEnding.toUpperCase())) {
            return;
        }
        String newFile = -1 == (file = file.trim()).lastIndexOf(".") || file.lastIndexOf(".") < file.lastIndexOf(File.separator) ? file + "." + newEnding : (file.lastIndexOf(".") > file.lastIndexOf(File.separator) ? file.substring(0, file.lastIndexOf(".")) + "." + newEnding : file);
        this._dlg.txtFile.setText(newFile);
    }

    private void onCommandFile() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.commandChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.commandChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._dlg.txtCommand.setText(chooser.getSelectedFile().getPath() + " %file");
        }
    }

    private void onFile() {
        File csvFile;
        File parentFile;
        JFileChooser chooser = null;
        String csvFileName = this._dlg.txtFile.getText();
        if (null != csvFileName && 0 < csvFileName.trim().length() && null != (parentFile = (csvFile = new File(csvFileName)).getParentFile()) && parentFile.exists()) {
            chooser = new JFileChooser(parentFile);
        }
        if (null == chooser) {
            chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        }
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.fileChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.fileChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._dlg.txtFile.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onOK() {
        String msg;
        String command;
        String sepChar;
        String csvFileName = this._dlg.txtFile.getText();
        if (null == csvFileName || 0 == csvFileName.trim().length()) {
            String msg2 = s_stringMgr.getString("TableExportCsvController.noFile");
            JOptionPane.showMessageDialog(this._dlg, msg2);
            return;
        }
        if (!(this._dlg.chkSeparatorTab.isSelected() || null != (sepChar = this._dlg.txtSeparatorChar.getText()) && 1 == sepChar.trim().length())) {
            String msg3 = s_stringMgr.getString("TableExportCsvController.invalidSeparator");
            JOptionPane.showMessageDialog(this._dlg, msg3);
            return;
        }
        if (this._dlg.chkExecCommand.isSelected() && (null == (command = this._dlg.txtCommand.getText()) || 0 == command.trim().length())) {
            String msg4 = s_stringMgr.getString("TableExportCsvController.noCommand");
            JOptionPane.showMessageDialog(this._dlg, msg4);
            return;
        }
        if (new File(csvFileName).exists() && 0 != JOptionPane.showConfirmDialog(this._dlg, msg = s_stringMgr.getString("TableExportCsvController.replaceFile"))) {
            return;
        }
        this.writePrefs();
        this.closeDlg();
        this._ok = true;
    }

    private void writePrefs() {
        Preferences.userRoot().put(PREF_KEY_CSV_FILE, this._dlg.txtFile.getText());
        Preferences.userRoot().put(PREF_KEY_CSV_ENCODING, this._dlg.charsets.getSelectedItem().toString());
        Preferences.userRoot().putBoolean(PREF_KEY_WITH_HEADERS, this._dlg.chkWithHeaders.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_FORMAT_CSV, this._dlg.radFormatCSV.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_FORMAT_XLS, this._dlg.radFormatXLS.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_SEPERATOR_TAB, this._dlg.chkSeparatorTab.isSelected());
        Preferences.userRoot().put(PREF_KEY_SEPERATOR_CHAR, this._dlg.txtSeparatorChar.getText());
        Preferences.userRoot().put(PREF_KEY_LINE_SEPERATOR, ((TableExportCsvDlg.LineSeparator)((Object)this._dlg._lineSeparators.getSelectedItem())).name());
        Preferences.userRoot().putBoolean(PREF_KEY_EXPORT_COMPLETE, this._dlg.radComplete.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_USE_GLOBAL_PREFS_FORMATING, this._dlg.radUseGlobalPrefsFormating.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_EXECUTE_COMMAND, this._dlg.chkExecCommand.isSelected());
        Preferences.userRoot().put(PREF_KEY_COMMAND, this._dlg.txtCommand.getText());
    }

    private void initDlg() {
        Preferences userRoot = Preferences.userRoot();
        this._dlg.txtFile.setText(userRoot.get(PREF_KEY_CSV_FILE, null));
        this._dlg.charsets.setSelectedItem(userRoot.get(PREF_KEY_CSV_ENCODING, Charset.defaultCharset().name()));
        this._dlg.chkWithHeaders.setSelected(userRoot.getBoolean(PREF_KEY_WITH_HEADERS, true));
        this._dlg.chkSeparatorTab.setSelected(userRoot.getBoolean(PREF_KEY_SEPERATOR_TAB, false));
        if (!this._dlg.chkSeparatorTab.isSelected()) {
            this._dlg.txtSeparatorChar.setText(userRoot.get(PREF_KEY_SEPERATOR_CHAR, ","));
        }
        if (userRoot.getBoolean(PREF_KEY_FORMAT_CSV, true)) {
            this._dlg.radFormatCSV.setSelected(true);
        } else if (userRoot.getBoolean(PREF_KEY_FORMAT_XLS, false)) {
            this._dlg.radFormatXLS.setSelected(true);
        } else {
            this._dlg.radFormatCSV.setSelected(true);
        }
        this.onFormat(false);
        if (userRoot.getBoolean(PREF_KEY_EXPORT_COMPLETE, true)) {
            this._dlg.radComplete.setSelected(true);
        } else {
            this._dlg.radSelection.setSelected(true);
        }
        if (userRoot.getBoolean(PREF_KEY_USE_GLOBAL_PREFS_FORMATING, true)) {
            this._dlg.radUseGlobalPrefsFormating.setSelected(true);
        } else {
            this._dlg.radUseDefaultFormating.setSelected(true);
        }
        this._dlg.chkExecCommand.setSelected(userRoot.getBoolean(PREF_KEY_EXECUTE_COMMAND, false));
        this.onChkExecCommand();
        this._dlg.txtCommand.setText(userRoot.get(PREF_KEY_COMMAND, "openoffice.org-2.0 -calc %file"));
        TableExportCsvDlg.LineSeparator preferredLineSeparator = TableExportCsvDlg.LineSeparator.valueOf(userRoot.get(PREF_KEY_LINE_SEPERATOR, TableExportCsvDlg.LineSeparator.DEFAULT.name()));
        this._dlg._lineSeparators.setSelectedItem((Object)preferredLineSeparator);
    }

    private void onChkExecCommand() {
        this._dlg.txtCommand.setEnabled(this._dlg.chkExecCommand.isSelected());
        this._dlg.btnCommandFile.setEnabled(this._dlg.chkExecCommand.isSelected());
    }

    private void installEscapeClose() {
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableExportCsvController.this.closeDlg();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._dlg.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private void closeDlg() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    boolean isOK() {
        return this._ok;
    }

    File getFile() {
        return new File(this._dlg.txtFile.getText());
    }

    String getSeparatorChar() {
        if (this._dlg.chkSeparatorTab.isSelected()) {
            return "\t";
        }
        return this._dlg.txtSeparatorChar.getText();
    }

    String getLineSeparator() {
        TableExportCsvDlg.LineSeparator lineSepChoice = (TableExportCsvDlg.LineSeparator)((Object)this._dlg._lineSeparators.getSelectedItem());
        String result = null;
        switch (lineSepChoice) {
            case DEFAULT: {
                result = System.getProperty("line.separator");
                break;
            }
            case LF: {
                result = "\n";
                break;
            }
            case CRLF: {
                result = "\r\n";
            }
        }
        return result;
    }

    Charset getCSVCharset() {
        try {
            return Charset.forName(this._dlg.charsets.getSelectedItem().toString());
        }
        catch (IllegalCharsetNameException icne) {
            return Charset.defaultCharset();
        }
    }

    boolean includeHeaders() {
        return this._dlg.chkWithHeaders.isSelected();
    }

    boolean exportComplete() {
        return this._dlg.radComplete.isSelected();
    }

    boolean useGloablPrefsFormatting() {
        return this._dlg.radUseGlobalPrefsFormating.isSelected();
    }

    String getCommand() {
        if (this._dlg.chkExecCommand.isSelected()) {
            return this._dlg.txtCommand.getText().replaceAll("%file", this._dlg.txtFile.getText().replaceAll("\\\\", "\\\\\\\\"));
        }
        return null;
    }

    public int getExportFormat() {
        if (this._dlg.radFormatCSV.isSelected()) {
            return 0;
        }
        if (this._dlg.radFormatXLS.isSelected()) {
            return 1;
        }
        throw new IllegalStateException("No valid output format");
    }
}

