/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowRowNumbersCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyHtmlCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInsertStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyUpdateStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyWhereStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectAllCellsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.UndoMakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TablePopupMenu
extends BasePopupMenu {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TablePopupMenu.class);
    private static final KeyStroke COPY_STROKE = KeyStroke.getKeyStroke(67, 128);
    private final JMenuItem[] _menuItems = new JMenuItem[13];
    private JTable _table;
    private JCheckBoxMenuItem _alwaysAdjustAllColWidtshActionItem;
    private JCheckBoxMenuItem _showRowNumbersItem;
    private CopyAction _copy = new CopyAction();
    private CopyWithHeadersAction _copyWithHeaders = new CopyWithHeadersAction();
    private CopyHtmlAction _copyHtml = new CopyHtmlAction();
    private CopyInStatementAction _copyInStatement = new CopyInStatementAction();
    private CopyWhereStatementAction _copyWhereStatement = new CopyWhereStatementAction();
    private CopyUpdateStatementAction _copyUpdateStatement = new CopyUpdateStatementAction();
    private CopyInsertStatementAction _copyInsertStatement = new CopyInsertStatementAction();
    private ExportCsvAction _exportCvs = new ExportCsvAction();
    private AdjustAllColWidthsAction _adjustAllColWidthsAction = new AdjustAllColWidthsAction();
    private AlwaysAdjustAllColWidthsAction _alwaysAdjustAllColWidthsAction = new AlwaysAdjustAllColWidthsAction();
    private ShowRowNumbersAction _showRowNumbersAction = new ShowRowNumbersAction();
    private MakeEditableAction _makeEditable = new MakeEditableAction();
    private UndoMakeEditableAction _undoMakeEditable = new UndoMakeEditableAction();
    private DeleteRowsAction _deleteRows = new DeleteRowsAction();
    private InsertRowAction _insertRow = new InsertRowAction();
    private SelectAllAction _select = new SelectAllAction();
    private PrintAction _print = new PrintAction();
    private IDataSetUpdateableModel _updateableModel = null;
    private DataSetViewerTablePanel _viewer = null;

    public TablePopupMenu(boolean allowEditing, IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._menuItems[0] = this.add(this._copy);
        this._menuItems[0].setAccelerator(COPY_STROKE);
        this._menuItems[1] = this.add(this._copyWithHeaders);
        this._menuItems[2] = this.add(this._copyHtml);
        this._menuItems[3] = this.add(this._copyInStatement);
        this._menuItems[4] = this.add(this._copyWhereStatement);
        this._menuItems[5] = this.add(this._copyUpdateStatement);
        this._menuItems[6] = this.add(this._copyInsertStatement);
        this.addSeparator();
        this._menuItems[7] = this.add(this._exportCvs);
        this.addSeparator();
        this._menuItems[9] = this.add(this._adjustAllColWidthsAction);
        this._alwaysAdjustAllColWidtshActionItem = new JCheckBoxMenuItem();
        this._alwaysAdjustAllColWidtshActionItem.setSelected(ButtonTableHeader.isAlwaysAdjustAllColWidths());
        this._alwaysAdjustAllColWidtshActionItem.setAction(this._alwaysAdjustAllColWidthsAction);
        this._menuItems[10] = this.add(this._alwaysAdjustAllColWidtshActionItem);
        this.addSeparator();
        this._showRowNumbersItem = new JCheckBoxMenuItem();
        this._showRowNumbersItem.setSelected(false);
        this._showRowNumbersItem.setAction(this._showRowNumbersAction);
        this._menuItems[11] = this.add(this._showRowNumbersItem);
        if (allowEditing) {
            this.addSeparator();
            this.add(this._makeEditable);
        }
        if (updateableModel != null && updateableModel.editModeIsForced()) {
            this.add(this._undoMakeEditable);
        }
        this.addSeparator();
        this._menuItems[8] = this.add(this._select);
        if (this._updateableModel != null && !allowEditing) {
            this.addSeparator();
            this.add(this._insertRow);
            this.add(this._deleteRows);
        }
        this.addSeparator();
        this.add(this._print);
    }

    public TablePopupMenu(IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer, JTable table) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._table = table;
        this.replaceStandardTableCopyAction();
        this.add(this._select);
        this.addSeparator();
        this.add(this._insertRow);
        this.add(this._deleteRows);
        this.addSeparator();
        this.add(this._print);
    }

    public void setTable(JTable value) {
        this._table = value;
        this.replaceStandardTableCopyAction();
    }

    public void reset() {
        this._showRowNumbersItem.setSelected(false);
    }

    private void replaceStandardTableCopyAction() {
        this._table.getInputMap(1).put(COPY_STROKE, "CopyAction");
        this._table.getInputMap(2).put(COPY_STROKE, "CopyAction");
        this._table.getInputMap(0).put(COPY_STROKE, "CopyAction");
        this._table.getActionMap().put("CopyAction", this._copy);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
    }

    @Override
    public void show(MouseEvent evt) {
        super.show(evt);
    }

    private String getStatementSeparatorFromModel() {
        return this._updateableModel.getDataModelImplementationDetails().getStatementSeparator();
    }

    private class PrintAction
    extends BaseAction {
        PrintAction() {
            super(s_stringMgr.getString("TablePopupMenu.print"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(TablePopupMenu.this._viewer);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class SelectAllAction
    extends BaseAction {
        SelectAllAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectall"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableSelectAllCellsCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class InsertRowAction
    extends BaseAction {
        InsertRowAction() {
            super(s_stringMgr.getString("TablePopupMenu.insertrow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TablePopupMenu.this._viewer.insertRow();
        }
    }

    private class DeleteRowsAction
    extends BaseAction {
        DeleteRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.deleterows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                int[] selectedRows = TablePopupMenu.this._table.getSelectedRows();
                TablePopupMenu.this._viewer.deleteRows(selectedRows);
            }
        }
    }

    private class UndoMakeEditableAction
    extends BaseAction {
        UndoMakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.undomakeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new UndoMakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class MakeEditableAction
    extends BaseAction {
        MakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.makeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new MakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class ShowRowNumbersAction
    extends BaseAction {
        ShowRowNumbersAction() {
            super(s_stringMgr.getString("TablePopupMenu.showRowNumbers"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                JCheckBoxMenuItem mnu = (JCheckBoxMenuItem)evt.getSource();
                new ShowRowNumbersCommand(TablePopupMenu.this._viewer, mnu.isSelected()).execute();
            }
        }
    }

    private class AlwaysAdjustAllColWidthsAction
    extends BaseAction {
        AlwaysAdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.alwaysAdoptAllColWiths"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ButtonTableHeader.setAlwaysAdjustAllColWidths(TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected());
            if (TablePopupMenu.this._table != null && TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected()) {
                ((ButtonTableHeader)TablePopupMenu.this._table.getTableHeader()).adjustAllColWidths(true);
            }
        }
    }

    private class AdjustAllColWidthsAction
    extends BaseAction {
        AdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.adoptAllColWidthsAction"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null && TablePopupMenu.this._table.getTableHeader() instanceof ButtonTableHeader) {
                ((ButtonTableHeader)TablePopupMenu.this._table.getTableHeader()).adjustAllColWidths(true);
            }
        }
    }

    private class ExportCsvAction
    extends BaseAction {
        ExportCsvAction() {
            super(s_stringMgr.getString("TablePopupMenu.export"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableExportCsvCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyInsertStatementAction
    extends BaseAction {
        CopyInsertStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinsertstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyInsertStatementCommand(TablePopupMenu.this._table, TablePopupMenu.this.getStatementSeparatorFromModel()).execute();
            }
        }
    }

    private class CopyUpdateStatementAction
    extends BaseAction {
        CopyUpdateStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasupdatestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyUpdateStatementCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyWhereStatementAction
    extends BaseAction {
        CopyWhereStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyaswherestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyWhereStatementCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyInStatementAction
    extends BaseAction {
        CopyInStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyInStatementCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyHtmlAction
    extends BaseAction {
        CopyHtmlAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyashtml"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyHtmlCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyWithHeadersAction
    extends BaseAction {
        CopyWithHeadersAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyWithHeaders"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyCommand(TablePopupMenu.this._table, true).execute();
            }
        }
    }

    private class CopyAction
    extends BaseAction {
        CopyAction() {
            super(s_stringMgr.getString("TablePopupMenu.copy"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyCommand(TablePopupMenu.this._table, false).execute();
            }
        }
    }

    public static interface IOptionTypes {
        public static final int COPY = 0;
        public static final int COPY_WITH_HEADERS = 1;
        public static final int COPY_HTML = 2;
        public static final int COPY_IN_STATEMENT = 3;
        public static final int COPY_WHERE_STATEMENT = 4;
        public static final int COPY_UPDATE_STATEMENT = 5;
        public static final int COPY_INSERT_STATEMENT = 6;
        public static final int EXPORT_CSV = 7;
        public static final int SELECT_ALL = 8;
        public static final int ADJUST_ALL_COL_WIDTHS_ACTION = 9;
        public static final int ALWAYS_ADJUST_ALL_COL_WIDTHS_ACTION = 10;
        public static final int SHOW_ROW_NUMBERS = 11;
        public static final int LAST_ENTRY = 12;
    }
}

